package com.elitesland.tw.tw5.server.prd.humanresources.resource.service;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEmployeCompositeAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEmployeCompositeAbilityService;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdEmployeCompositeAbilityConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.PrdEmployeCompositeAbilityDO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEmployeCompositeAbilityPayload;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.repo.PrdEmployeCompositeAbilityRepo;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.dao.PrdEmployeCompositeAbilityDao;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEmployeCompositeAbilityVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.collection.CollectionUtil;

import java.time.LocalDate;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-10-27
 * @desc : 员工-复合能力Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdEmployeCompositeAbilityServiceImpl implements PrdEmployeCompositeAbilityService {


    private final PrdEmployeCompositeAbilityDao prdEmployeCompositeAbilityDao;

    private final PrdEmployeCompositeAbilityRepo prdEmployeCompositeAbilityRepo;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdEmployeCompositeAbilityVO save(PrdEmployeCompositeAbilityPayload prdEmployeCompositeAbilityPayload) {

        if (null == prdEmployeCompositeAbilityPayload.getState()) {
            prdEmployeCompositeAbilityPayload.setState(1);
        }
        checkData(prdEmployeCompositeAbilityPayload);
        prdEmployeCompositeAbilityPayload.setObtainTime(LocalDate.now());
        PrdEmployeCompositeAbilityDO prdEmployeCompositeAbilityDO = new PrdEmployeCompositeAbilityDO();
        prdEmployeCompositeAbilityDO = PrdEmployeCompositeAbilityConvert.INSTANCE.p2d(prdEmployeCompositeAbilityPayload);
        PrdEmployeCompositeAbilityDO res = prdEmployeCompositeAbilityRepo.save(prdEmployeCompositeAbilityDO);
        return PrdEmployeCompositeAbilityConvert.INSTANCE.d2v(res);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdEmployeCompositeAbilityVO update(PrdEmployeCompositeAbilityPayload prdEmployeCompositeAbilityPayload) {

        Assert.notNull(prdEmployeCompositeAbilityPayload.getId(), "id is null");
        PrdEmployeCompositeAbilityVO res = save(prdEmployeCompositeAbilityPayload);
        return res;

    }


    @Override
    public PrdEmployeCompositeAbilityVO get(Long id) {

        if (null == id) {
            return null;
        }
        PrdEmployeCompositeAbilityVO res = prdEmployeCompositeAbilityDao.get(id);
        return res;

    }


    @Override
    public PagingVO<PrdEmployeCompositeAbilityVO> page(PrdEmployeCompositeAbilityQuery prdEmployeCompositeAbilityQuery) {

        PagingVO<PrdEmployeCompositeAbilityVO> res = prdEmployeCompositeAbilityDao.page(prdEmployeCompositeAbilityQuery);
        // 拼接主表+ 明细 名称
        res.getRecords().forEach(x -> {
            x.setAbilityName(x.getAbilityName() + "-" + x.getLevelDtlName());
        });
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdEmployeCompositeAbilityDao.del(ids);
        return res;

    }

    @Override
    public List<PrdEmployeCompositeAbilityVO> getList(PrdEmployeCompositeAbilityQuery prdEmployeCompositeAbilityQuery) {
        if (null == prdEmployeCompositeAbilityQuery.getUserId()) {
            throw new BusinessException("userId不能为空");
        }
        List<PrdEmployeCompositeAbilityVO> res = prdEmployeCompositeAbilityDao.getList(prdEmployeCompositeAbilityQuery);
        // 拼接主表+ 明细 名称
        res.forEach(x -> {
            x.setAbilityName(x.getAbilityName() + "-" + x.getLevelDtlName());
        });
        return res;

    }

    @Override
    @Transactional
    public Boolean batchSave(List<PrdEmployeCompositeAbilityPayload> prdEmployeCompositeAbilityPayload) {
        for (PrdEmployeCompositeAbilityPayload payload : prdEmployeCompositeAbilityPayload) {
            save(payload);
        }
        return true;
    }

    @Override
    @Transactional
    public Long updateAbility(PrdEmployeCompositeAbilityPayload prdEmployeCompositeAbilityPayload) {

        // 主能力 次能力仅能生效一个
        if (null != prdEmployeCompositeAbilityPayload.getMainFlag() && prdEmployeCompositeAbilityPayload.getMainFlag()) {
            prdEmployeCompositeAbilityDao.updateAllMainFlag();
        }
        if (null != prdEmployeCompositeAbilityPayload.getAuxFlag() && prdEmployeCompositeAbilityPayload.getAuxFlag()) {
            prdEmployeCompositeAbilityDao.updateAllAuxFlag();
        }

        Long res = prdEmployeCompositeAbilityDao.updateAbility(prdEmployeCompositeAbilityPayload);
        return res;
    }

    @Override
    @Transactional
    public Boolean updateStateByFormId(PrdEmployeCompositeAbilityPayload prdEmployeCompositeAbilityPayload) {


        Boolean res = prdEmployeCompositeAbilityDao.updateStateByFormId(prdEmployeCompositeAbilityPayload);
        return res;
    }


    /**
     * 数据校验
     *
     * @param prdEmployeCompositeAbilityPayload
     */
    private void checkData(PrdEmployeCompositeAbilityPayload prdEmployeCompositeAbilityPayload) {

        if (null == (prdEmployeCompositeAbilityPayload.getUserId())) {
            throw new BusinessException("userId不能为空");
        }
        if (null == (prdEmployeCompositeAbilityPayload.getAbilityLevelId())) {
            throw new BusinessException("abilityLevelId不能为空");
        }

    }


}

