package com.elitesland.tw.tw5.server.prd.inv.dao;


import com.elitesland.tw.tw5.api.prd.inv.payload.InvInvoiceAttachedPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceAttachedQuery;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceAttachedVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.inv.entity.InvInvoiceAttachedDO;
import com.elitesland.tw.tw5.server.prd.inv.entity.QInvInvoiceAttachedDO;
import com.elitesland.tw.tw5.server.prd.inv.repo.InvInvoiceAttachedRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 发票扩展表
 *
 * @author zoey
 * @date 2023-12-06
 */
@Repository
@RequiredArgsConstructor
public class InvInvoiceAttachedDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final InvInvoiceAttachedRepo repo;
    private final QInvInvoiceAttachedDO qdo = QInvInvoiceAttachedDO.invInvoiceAttachedDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<InvInvoiceAttachedVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(InvInvoiceAttachedVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 发票ID
                qdo.invId,
                // 百望系统发票ID
                qdo.baiwangInvId,
                // 百望系统发票扩展信息ID
                qdo.baiwangId,
                // 承运人名称:承运人名称
                qdo.carrierName,
                // 承运人识别号:承运人识别号
                qdo.carrierTaxNo,
                // 受票方名称:受票方名称
                qdo.draweeName,
                // 受票方识别号:受票方识别号
                qdo.draweeTaxNo,
                // 运输货物信息:运输货物信息
                qdo.cargoInformation,
                // 起运地、经由、到达地:起运地、经由、到达地
                qdo.transportRoute,
                // 车船吨位:车船吨位
                qdo.tonnage,
                // 主管税务机关:主管税务机关
                qdo.taxAuthorityNo,
                // 主管税务名称:主管税务名称
                qdo.taxAuthorityName,
                // 身份证号码 组织机构代码:身份证号码/组织机构代码
                qdo.idCardNo,
                // 车辆类型:车辆类型
                qdo.vehicleType,
                // 车辆识别代号/车架号码:车辆识别代号/车架号码
                qdo.vehicleNo,
                // 厂牌型号:厂牌型号
                qdo.brandModel,
                // 产地:产地
                qdo.originPlace,
                // 合格证号:合格证号
                qdo.certiticateNo,
                // 商检单号:商检单号
                qdo.inspectionListNo,
                // 发动机号:发动机号
                qdo.engineNo,
                // 进口证明书号:进口证明书号
                qdo.importCertificateNo,
                // 销货单位名称:销货单位名称（销方名称）
                qdo.sellerName,
                // 销方电话:销方电话
                qdo.phoneNo,
                // 账号:账号
                qdo.account,
                // 销方地址:销方地址
                qdo.address,
                // 银行:银行
                qdo.bank,
                // 税率:税率
                qdo.goodsTaxRate,
                // 限乘人数:限乘人数
                qdo.passengersLimited,
                // 通行费标志:通行费标志 06-可抵扣通行费，07-不可抵扣通行费
                qdo.tollSign,
                // 经营，拍卖单位地址:经营，拍卖单位地址
                qdo.auctionAddress,
                // 经营，拍卖单位:经营，拍卖单位
                qdo.auctionName,
                // 经营，拍卖单位电话:经营，拍卖单位电话
                qdo.auctionPhone,
                // 经营，拍卖单位纳税人识别号:经营，拍卖单位纳税人识别号
                qdo.auctionTaxNo,
                // 开户银行及账号:开户银行及账号
                qdo.auctionBank,
                // 买方电话:买方电话
                qdo.purchaserPhone,
                // 登记证号:登记证号
                qdo.registrationNumber,
                // 二手车市场地址:二手车市场地址
                qdo.usedCarAddress,
                // 二手车市场:二手车市场
                qdo.usedCarName,
                // 二手车市场电话:二手车市场电话
                qdo.usedCarPhone,
                // 二手车市场纳税人识别号:二手车市场纳税人识别号
                qdo.usedCarTaxNo,
                // 二手车市场开户银行及账号:二手车市场开户银行及账号
                qdo.usedCarBank,
                // 车牌照号:车牌照号
                qdo.carNumber,
                // 转入地车辆车管所名称:转入地车辆车管所名称
                qdo.vehiclePlaceName,
                // 是否删除:是否删除，0-否，1-是
                qdo.isDel
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<InvInvoiceAttachedVO> getJpaQueryWhere(InvInvoiceAttachedQuery query) {
        JPAQuery<InvInvoiceAttachedVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(InvInvoiceAttachedQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(InvInvoiceAttachedQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 发票ID 精确 */
        if (!ObjectUtils.isEmpty(query.getInvId())) {
            list.add(qdo.invId.eq(query.getInvId()));
        }
        /** 百望系统发票ID 精确 */
        if (!ObjectUtils.isEmpty(query.getBaiwangInvId())) {
            list.add(qdo.baiwangInvId.eq(query.getBaiwangInvId()));
        }
        /** 百望系统发票扩展信息ID 精确 */
        if (!ObjectUtils.isEmpty(query.getBaiwangId())) {
            list.add(qdo.baiwangId.eq(query.getBaiwangId()));
        }
        /** 承运人名称:承运人名称 精确 */
        if (!ObjectUtils.isEmpty(query.getCarrierName())) {
            list.add(qdo.carrierName.eq(query.getCarrierName()));
        }
        /** 承运人识别号:承运人识别号 精确 */
        if (!ObjectUtils.isEmpty(query.getCarrierTaxNo())) {
            list.add(qdo.carrierTaxNo.eq(query.getCarrierTaxNo()));
        }
        /** 受票方名称:受票方名称 精确 */
        if (!ObjectUtils.isEmpty(query.getDraweeName())) {
            list.add(qdo.draweeName.eq(query.getDraweeName()));
        }
        /** 受票方识别号:受票方识别号 精确 */
        if (!ObjectUtils.isEmpty(query.getDraweeTaxNo())) {
            list.add(qdo.draweeTaxNo.eq(query.getDraweeTaxNo()));
        }
        /** 运输货物信息:运输货物信息 精确 */
        if (!ObjectUtils.isEmpty(query.getCargoInformation())) {
            list.add(qdo.cargoInformation.eq(query.getCargoInformation()));
        }
        /** 起运地、经由、到达地:起运地、经由、到达地 精确 */
        if (!ObjectUtils.isEmpty(query.getTransportRoute())) {
            list.add(qdo.transportRoute.eq(query.getTransportRoute()));
        }
        /** 车船吨位:车船吨位 精确 */
        if (!ObjectUtils.isEmpty(query.getTonnage())) {
            list.add(qdo.tonnage.eq(query.getTonnage()));
        }
        /** 主管税务机关:主管税务机关 精确 */
        if (!ObjectUtils.isEmpty(query.getTaxAuthorityNo())) {
            list.add(qdo.taxAuthorityNo.eq(query.getTaxAuthorityNo()));
        }
        /** 主管税务名称:主管税务名称 精确 */
        if (!ObjectUtils.isEmpty(query.getTaxAuthorityName())) {
            list.add(qdo.taxAuthorityName.eq(query.getTaxAuthorityName()));
        }
        /** 身份证号码 组织机构代码:身份证号码/组织机构代码 精确 */
        if (!ObjectUtils.isEmpty(query.getIdCardNo())) {
            list.add(qdo.idCardNo.eq(query.getIdCardNo()));
        }
        /** 车辆类型:车辆类型 精确 */
        if (!ObjectUtils.isEmpty(query.getVehicleType())) {
            list.add(qdo.vehicleType.eq(query.getVehicleType()));
        }
        /** 车辆识别代号/车架号码:车辆识别代号/车架号码 精确 */
        if (!ObjectUtils.isEmpty(query.getVehicleNo())) {
            list.add(qdo.vehicleNo.eq(query.getVehicleNo()));
        }
        /** 厂牌型号:厂牌型号 精确 */
        if (!ObjectUtils.isEmpty(query.getBrandModel())) {
            list.add(qdo.brandModel.eq(query.getBrandModel()));
        }
        /** 产地:产地 精确 */
        if (!ObjectUtils.isEmpty(query.getOriginPlace())) {
            list.add(qdo.originPlace.eq(query.getOriginPlace()));
        }
        /** 合格证号:合格证号 精确 */
        if (!ObjectUtils.isEmpty(query.getCertiticateNo())) {
            list.add(qdo.certiticateNo.eq(query.getCertiticateNo()));
        }
        /** 商检单号:商检单号 精确 */
        if (!ObjectUtils.isEmpty(query.getInspectionListNo())) {
            list.add(qdo.inspectionListNo.eq(query.getInspectionListNo()));
        }
        /** 发动机号:发动机号 精确 */
        if (!ObjectUtils.isEmpty(query.getEngineNo())) {
            list.add(qdo.engineNo.eq(query.getEngineNo()));
        }
        /** 进口证明书号:进口证明书号 精确 */
        if (!ObjectUtils.isEmpty(query.getImportCertificateNo())) {
            list.add(qdo.importCertificateNo.eq(query.getImportCertificateNo()));
        }
        /** 销货单位名称:销货单位名称（销方名称） 精确 */
        if (!ObjectUtils.isEmpty(query.getSellerName())) {
            list.add(qdo.sellerName.eq(query.getSellerName()));
        }
        /** 销方电话:销方电话 精确 */
        if (!ObjectUtils.isEmpty(query.getPhoneNo())) {
            list.add(qdo.phoneNo.eq(query.getPhoneNo()));
        }
        /** 账号:账号 精确 */
        if (!ObjectUtils.isEmpty(query.getAccount())) {
            list.add(qdo.account.eq(query.getAccount()));
        }
        /** 销方地址:销方地址 精确 */
        if (!ObjectUtils.isEmpty(query.getAddress())) {
            list.add(qdo.address.eq(query.getAddress()));
        }
        /** 银行:银行 精确 */
        if (!ObjectUtils.isEmpty(query.getBank())) {
            list.add(qdo.bank.eq(query.getBank()));
        }
        /** 税率:税率 精确 */
        if (!ObjectUtils.isEmpty(query.getGoodsTaxRate())) {
            list.add(qdo.goodsTaxRate.eq(query.getGoodsTaxRate()));
        }
        /** 限乘人数:限乘人数 精确 */
        if (!ObjectUtils.isEmpty(query.getPassengersLimited())) {
            list.add(qdo.passengersLimited.eq(query.getPassengersLimited()));
        }
        /** 通行费标志:通行费标志 06-可抵扣通行费，07-不可抵扣通行费 精确 */
        if (!ObjectUtils.isEmpty(query.getTollSign())) {
            list.add(qdo.tollSign.eq(query.getTollSign()));
        }
        /** 经营，拍卖单位地址:经营，拍卖单位地址 精确 */
        if (!ObjectUtils.isEmpty(query.getAuctionAddress())) {
            list.add(qdo.auctionAddress.eq(query.getAuctionAddress()));
        }
        /** 经营，拍卖单位:经营，拍卖单位 精确 */
        if (!ObjectUtils.isEmpty(query.getAuctionName())) {
            list.add(qdo.auctionName.eq(query.getAuctionName()));
        }
        /** 经营，拍卖单位电话:经营，拍卖单位电话 精确 */
        if (!ObjectUtils.isEmpty(query.getAuctionPhone())) {
            list.add(qdo.auctionPhone.eq(query.getAuctionPhone()));
        }
        /** 经营，拍卖单位纳税人识别号:经营，拍卖单位纳税人识别号 精确 */
        if (!ObjectUtils.isEmpty(query.getAuctionTaxNo())) {
            list.add(qdo.auctionTaxNo.eq(query.getAuctionTaxNo()));
        }
        /** 开户银行及账号:开户银行及账号 精确 */
        if (!ObjectUtils.isEmpty(query.getAuctionBank())) {
            list.add(qdo.auctionBank.eq(query.getAuctionBank()));
        }
        /** 买方电话:买方电话 精确 */
        if (!ObjectUtils.isEmpty(query.getPurchaserPhone())) {
            list.add(qdo.purchaserPhone.eq(query.getPurchaserPhone()));
        }
        /** 登记证号:登记证号 精确 */
        if (!ObjectUtils.isEmpty(query.getRegistrationNumber())) {
            list.add(qdo.registrationNumber.eq(query.getRegistrationNumber()));
        }
        /** 二手车市场地址:二手车市场地址 精确 */
        if (!ObjectUtils.isEmpty(query.getUsedCarAddress())) {
            list.add(qdo.usedCarAddress.eq(query.getUsedCarAddress()));
        }
        /** 二手车市场:二手车市场 精确 */
        if (!ObjectUtils.isEmpty(query.getUsedCarName())) {
            list.add(qdo.usedCarName.eq(query.getUsedCarName()));
        }
        /** 二手车市场电话:二手车市场电话 精确 */
        if (!ObjectUtils.isEmpty(query.getUsedCarPhone())) {
            list.add(qdo.usedCarPhone.eq(query.getUsedCarPhone()));
        }
        /** 二手车市场纳税人识别号:二手车市场纳税人识别号 精确 */
        if (!ObjectUtils.isEmpty(query.getUsedCarTaxNo())) {
            list.add(qdo.usedCarTaxNo.eq(query.getUsedCarTaxNo()));
        }
        /** 二手车市场开户银行及账号:二手车市场开户银行及账号 精确 */
        if (!ObjectUtils.isEmpty(query.getUsedCarBank())) {
            list.add(qdo.usedCarBank.eq(query.getUsedCarBank()));
        }
        /** 车牌照号:车牌照号 精确 */
        if (!ObjectUtils.isEmpty(query.getCarNumber())) {
            list.add(qdo.carNumber.eq(query.getCarNumber()));
        }
        /** 转入地车辆车管所名称:转入地车辆车管所名称 精确 */
        if (!ObjectUtils.isEmpty(query.getVehiclePlaceName())) {
            list.add(qdo.vehiclePlaceName.eq(query.getVehiclePlaceName()));
        }
        /** 是否删除:是否删除，0-否，1-是 精确 */
        if (!ObjectUtils.isEmpty(query.getIsDel())) {
            list.add(qdo.isDel.eq(query.getIsDel()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public InvInvoiceAttachedVO queryByKey(Long id) {
        JPAQuery<InvInvoiceAttachedVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<InvInvoiceAttachedVO> queryListDynamic(InvInvoiceAttachedQuery query) {
        JPAQuery<InvInvoiceAttachedVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<InvInvoiceAttachedVO> queryPaging(InvInvoiceAttachedQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<InvInvoiceAttachedVO> jpaQuery = getJpaQueryWhere(query);
        List<InvInvoiceAttachedVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<InvInvoiceAttachedVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public InvInvoiceAttachedDO save(InvInvoiceAttachedDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<InvInvoiceAttachedDO> saveAll(List<InvInvoiceAttachedDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(InvInvoiceAttachedPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 发票ID
        if (payload.getInvId() != null) {
            update.set(qdo.invId, payload.getInvId());
        }
        // 百望系统发票ID
        if (payload.getBaiwangInvId() != null) {
            update.set(qdo.baiwangInvId, payload.getBaiwangInvId());
        }
        // 百望系统发票扩展信息ID
        if (payload.getBaiwangId() != null) {
            update.set(qdo.baiwangId, payload.getBaiwangId());
        }
        // 承运人名称:承运人名称
        if (payload.getCarrierName() != null) {
            update.set(qdo.carrierName, payload.getCarrierName());
        }
        // 承运人识别号:承运人识别号
        if (payload.getCarrierTaxNo() != null) {
            update.set(qdo.carrierTaxNo, payload.getCarrierTaxNo());
        }
        // 受票方名称:受票方名称
        if (payload.getDraweeName() != null) {
            update.set(qdo.draweeName, payload.getDraweeName());
        }
        // 受票方识别号:受票方识别号
        if (payload.getDraweeTaxNo() != null) {
            update.set(qdo.draweeTaxNo, payload.getDraweeTaxNo());
        }
        // 运输货物信息:运输货物信息
        if (payload.getCargoInformation() != null) {
            update.set(qdo.cargoInformation, payload.getCargoInformation());
        }
        // 起运地、经由、到达地:起运地、经由、到达地
        if (payload.getTransportRoute() != null) {
            update.set(qdo.transportRoute, payload.getTransportRoute());
        }
        // 车船吨位:车船吨位
        if (payload.getTonnage() != null) {
            update.set(qdo.tonnage, payload.getTonnage());
        }
        // 主管税务机关:主管税务机关
        if (payload.getTaxAuthorityNo() != null) {
            update.set(qdo.taxAuthorityNo, payload.getTaxAuthorityNo());
        }
        // 主管税务名称:主管税务名称
        if (payload.getTaxAuthorityName() != null) {
            update.set(qdo.taxAuthorityName, payload.getTaxAuthorityName());
        }
        // 身份证号码 组织机构代码:身份证号码/组织机构代码
        if (payload.getIdCardNo() != null) {
            update.set(qdo.idCardNo, payload.getIdCardNo());
        }
        // 车辆类型:车辆类型
        if (payload.getVehicleType() != null) {
            update.set(qdo.vehicleType, payload.getVehicleType());
        }
        // 车辆识别代号/车架号码:车辆识别代号/车架号码
        if (payload.getVehicleNo() != null) {
            update.set(qdo.vehicleNo, payload.getVehicleNo());
        }
        // 厂牌型号:厂牌型号
        if (payload.getBrandModel() != null) {
            update.set(qdo.brandModel, payload.getBrandModel());
        }
        // 产地:产地
        if (payload.getOriginPlace() != null) {
            update.set(qdo.originPlace, payload.getOriginPlace());
        }
        // 合格证号:合格证号
        if (payload.getCertiticateNo() != null) {
            update.set(qdo.certiticateNo, payload.getCertiticateNo());
        }
        // 商检单号:商检单号
        if (payload.getInspectionListNo() != null) {
            update.set(qdo.inspectionListNo, payload.getInspectionListNo());
        }
        // 发动机号:发动机号
        if (payload.getEngineNo() != null) {
            update.set(qdo.engineNo, payload.getEngineNo());
        }
        // 进口证明书号:进口证明书号
        if (payload.getImportCertificateNo() != null) {
            update.set(qdo.importCertificateNo, payload.getImportCertificateNo());
        }
        // 销货单位名称:销货单位名称（销方名称）
        if (payload.getSellerName() != null) {
            update.set(qdo.sellerName, payload.getSellerName());
        }
        // 销方电话:销方电话
        if (payload.getPhoneNo() != null) {
            update.set(qdo.phoneNo, payload.getPhoneNo());
        }
        // 账号:账号
        if (payload.getAccount() != null) {
            update.set(qdo.account, payload.getAccount());
        }
        // 销方地址:销方地址
        if (payload.getAddress() != null) {
            update.set(qdo.address, payload.getAddress());
        }
        // 银行:银行
        if (payload.getBank() != null) {
            update.set(qdo.bank, payload.getBank());
        }
        // 税率:税率
        if (payload.getGoodsTaxRate() != null) {
            update.set(qdo.goodsTaxRate, payload.getGoodsTaxRate());
        }
        // 限乘人数:限乘人数
        if (payload.getPassengersLimited() != null) {
            update.set(qdo.passengersLimited, payload.getPassengersLimited());
        }
        // 通行费标志:通行费标志 06-可抵扣通行费，07-不可抵扣通行费
        if (payload.getTollSign() != null) {
            update.set(qdo.tollSign, payload.getTollSign());
        }
        // 经营，拍卖单位地址:经营，拍卖单位地址
        if (payload.getAuctionAddress() != null) {
            update.set(qdo.auctionAddress, payload.getAuctionAddress());
        }
        // 经营，拍卖单位:经营，拍卖单位
        if (payload.getAuctionName() != null) {
            update.set(qdo.auctionName, payload.getAuctionName());
        }
        // 经营，拍卖单位电话:经营，拍卖单位电话
        if (payload.getAuctionPhone() != null) {
            update.set(qdo.auctionPhone, payload.getAuctionPhone());
        }
        // 经营，拍卖单位纳税人识别号:经营，拍卖单位纳税人识别号
        if (payload.getAuctionTaxNo() != null) {
            update.set(qdo.auctionTaxNo, payload.getAuctionTaxNo());
        }
        // 开户银行及账号:开户银行及账号
        if (payload.getAuctionBank() != null) {
            update.set(qdo.auctionBank, payload.getAuctionBank());
        }
        // 买方电话:买方电话
        if (payload.getPurchaserPhone() != null) {
            update.set(qdo.purchaserPhone, payload.getPurchaserPhone());
        }
        // 登记证号:登记证号
        if (payload.getRegistrationNumber() != null) {
            update.set(qdo.registrationNumber, payload.getRegistrationNumber());
        }
        // 二手车市场地址:二手车市场地址
        if (payload.getUsedCarAddress() != null) {
            update.set(qdo.usedCarAddress, payload.getUsedCarAddress());
        }
        // 二手车市场:二手车市场
        if (payload.getUsedCarName() != null) {
            update.set(qdo.usedCarName, payload.getUsedCarName());
        }
        // 二手车市场电话:二手车市场电话
        if (payload.getUsedCarPhone() != null) {
            update.set(qdo.usedCarPhone, payload.getUsedCarPhone());
        }
        // 二手车市场纳税人识别号:二手车市场纳税人识别号
        if (payload.getUsedCarTaxNo() != null) {
            update.set(qdo.usedCarTaxNo, payload.getUsedCarTaxNo());
        }
        // 二手车市场开户银行及账号:二手车市场开户银行及账号
        if (payload.getUsedCarBank() != null) {
            update.set(qdo.usedCarBank, payload.getUsedCarBank());
        }
        // 车牌照号:车牌照号
        if (payload.getCarNumber() != null) {
            update.set(qdo.carNumber, payload.getCarNumber());
        }
        // 转入地车辆车管所名称:转入地车辆车管所名称
        if (payload.getVehiclePlaceName() != null) {
            update.set(qdo.vehiclePlaceName, payload.getVehiclePlaceName());
        }
        // 是否删除:是否删除，0-否，1-是
        if (payload.getIsDel() != null) {
            update.set(qdo.isDel, payload.getIsDel());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 发票ID
            if (nullFields.contains("invId")) {
                update.setNull(qdo.invId);
            }
            // 百望系统发票ID
            if (nullFields.contains("baiwangInvId")) {
                update.setNull(qdo.baiwangInvId);
            }
            // 百望系统发票扩展信息ID
            if (nullFields.contains("baiwangId")) {
                update.setNull(qdo.baiwangId);
            }
            // 承运人名称:承运人名称
            if (nullFields.contains("carrierName")) {
                update.setNull(qdo.carrierName);
            }
            // 承运人识别号:承运人识别号
            if (nullFields.contains("carrierTaxNo")) {
                update.setNull(qdo.carrierTaxNo);
            }
            // 受票方名称:受票方名称
            if (nullFields.contains("draweeName")) {
                update.setNull(qdo.draweeName);
            }
            // 受票方识别号:受票方识别号
            if (nullFields.contains("draweeTaxNo")) {
                update.setNull(qdo.draweeTaxNo);
            }
            // 运输货物信息:运输货物信息
            if (nullFields.contains("cargoInformation")) {
                update.setNull(qdo.cargoInformation);
            }
            // 起运地、经由、到达地:起运地、经由、到达地
            if (nullFields.contains("transportRoute")) {
                update.setNull(qdo.transportRoute);
            }
            // 车船吨位:车船吨位
            if (nullFields.contains("tonnage")) {
                update.setNull(qdo.tonnage);
            }
            // 主管税务机关:主管税务机关
            if (nullFields.contains("taxAuthorityNo")) {
                update.setNull(qdo.taxAuthorityNo);
            }
            // 主管税务名称:主管税务名称
            if (nullFields.contains("taxAuthorityName")) {
                update.setNull(qdo.taxAuthorityName);
            }
            // 身份证号码 组织机构代码:身份证号码/组织机构代码
            if (nullFields.contains("idCardNo")) {
                update.setNull(qdo.idCardNo);
            }
            // 车辆类型:车辆类型
            if (nullFields.contains("vehicleType")) {
                update.setNull(qdo.vehicleType);
            }
            // 车辆识别代号/车架号码:车辆识别代号/车架号码
            if (nullFields.contains("vehicleNo")) {
                update.setNull(qdo.vehicleNo);
            }
            // 厂牌型号:厂牌型号
            if (nullFields.contains("brandModel")) {
                update.setNull(qdo.brandModel);
            }
            // 产地:产地
            if (nullFields.contains("originPlace")) {
                update.setNull(qdo.originPlace);
            }
            // 合格证号:合格证号
            if (nullFields.contains("certiticateNo")) {
                update.setNull(qdo.certiticateNo);
            }
            // 商检单号:商检单号
            if (nullFields.contains("inspectionListNo")) {
                update.setNull(qdo.inspectionListNo);
            }
            // 发动机号:发动机号
            if (nullFields.contains("engineNo")) {
                update.setNull(qdo.engineNo);
            }
            // 进口证明书号:进口证明书号
            if (nullFields.contains("importCertificateNo")) {
                update.setNull(qdo.importCertificateNo);
            }
            // 销货单位名称:销货单位名称（销方名称）
            if (nullFields.contains("sellerName")) {
                update.setNull(qdo.sellerName);
            }
            // 销方电话:销方电话
            if (nullFields.contains("phoneNo")) {
                update.setNull(qdo.phoneNo);
            }
            // 账号:账号
            if (nullFields.contains("account")) {
                update.setNull(qdo.account);
            }
            // 销方地址:销方地址
            if (nullFields.contains("address")) {
                update.setNull(qdo.address);
            }
            // 银行:银行
            if (nullFields.contains("bank")) {
                update.setNull(qdo.bank);
            }
            // 税率:税率
            if (nullFields.contains("goodsTaxRate")) {
                update.setNull(qdo.goodsTaxRate);
            }
            // 限乘人数:限乘人数
            if (nullFields.contains("passengersLimited")) {
                update.setNull(qdo.passengersLimited);
            }
            // 通行费标志:通行费标志 06-可抵扣通行费，07-不可抵扣通行费
            if (nullFields.contains("tollSign")) {
                update.setNull(qdo.tollSign);
            }
            // 经营，拍卖单位地址:经营，拍卖单位地址
            if (nullFields.contains("auctionAddress")) {
                update.setNull(qdo.auctionAddress);
            }
            // 经营，拍卖单位:经营，拍卖单位
            if (nullFields.contains("auctionName")) {
                update.setNull(qdo.auctionName);
            }
            // 经营，拍卖单位电话:经营，拍卖单位电话
            if (nullFields.contains("auctionPhone")) {
                update.setNull(qdo.auctionPhone);
            }
            // 经营，拍卖单位纳税人识别号:经营，拍卖单位纳税人识别号
            if (nullFields.contains("auctionTaxNo")) {
                update.setNull(qdo.auctionTaxNo);
            }
            // 开户银行及账号:开户银行及账号
            if (nullFields.contains("auctionBank")) {
                update.setNull(qdo.auctionBank);
            }
            // 买方电话:买方电话
            if (nullFields.contains("purchaserPhone")) {
                update.setNull(qdo.purchaserPhone);
            }
            // 登记证号:登记证号
            if (nullFields.contains("registrationNumber")) {
                update.setNull(qdo.registrationNumber);
            }
            // 二手车市场地址:二手车市场地址
            if (nullFields.contains("usedCarAddress")) {
                update.setNull(qdo.usedCarAddress);
            }
            // 二手车市场:二手车市场
            if (nullFields.contains("usedCarName")) {
                update.setNull(qdo.usedCarName);
            }
            // 二手车市场电话:二手车市场电话
            if (nullFields.contains("usedCarPhone")) {
                update.setNull(qdo.usedCarPhone);
            }
            // 二手车市场纳税人识别号:二手车市场纳税人识别号
            if (nullFields.contains("usedCarTaxNo")) {
                update.setNull(qdo.usedCarTaxNo);
            }
            // 二手车市场开户银行及账号:二手车市场开户银行及账号
            if (nullFields.contains("usedCarBank")) {
                update.setNull(qdo.usedCarBank);
            }
            // 车牌照号:车牌照号
            if (nullFields.contains("carNumber")) {
                update.setNull(qdo.carNumber);
            }
            // 转入地车辆车管所名称:转入地车辆车管所名称
            if (nullFields.contains("vehiclePlaceName")) {
                update.setNull(qdo.vehiclePlaceName);
            }
            // 是否删除:是否删除，0-否，1-是
            if (nullFields.contains("isDel")) {
                update.setNull(qdo.isDel);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

