package com.elitesland.tw.tw5.server.prd.inv.service;

import com.baiwang.bop.client.BopException;
import com.baiwang.open.entity.request.OutputProductcodeQueryRequest;
import com.baiwang.open.entity.response.OutputProductcodeQueryResponse;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.inv.payload.InvItemPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvItemQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvItemService;
import com.elitesland.tw.tw5.api.prd.inv.service.TwInvoiceSendMsgService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvItemVO;
import com.elitesland.tw.tw5.server.prd.inv.convert.InvItemConvert;
import com.elitesland.tw.tw5.server.prd.inv.dao.InvItemDAO;
import com.elitesland.tw.tw5.server.prd.inv.entity.InvItemCatDO;
import com.elitesland.tw.tw5.server.prd.inv.entity.InvItemDO;
import com.elitesland.tw.tw5.server.prd.inv.repo.InvItemCatRepo;
import com.elitesland.tw.tw5.server.prd.inv.repo.InvItemRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 发票商品对象（百望）
 *
 * @author zoey
 * @date 2023-07-31
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class InvItemServiceImpl extends BaseServiceImpl implements InvItemService {

    private final InvItemRepo invItemRepo;
    private final InvItemDAO invItemDAO;
    private final InvItemCatRepo invItemCatRepo;
    private final TwInvoiceSendMsgService invoiceSendMsgService;

    @Override
    public PagingVO<InvItemVO> queryPaging(InvItemQuery query) {
        return invItemDAO.queryPaging(query);
    }

    @Override
    public List<InvItemVO> queryListDynamic(InvItemQuery query) {
        List<InvItemVO> invItemVOS = invItemDAO.queryListDynamic(query);
        Map<String, List<InvItemVO>> collect = invItemVOS.stream()
                .collect(Collectors.groupingBy(v -> (v.getTwGoodsCode() + "&" + v.getTwGoodsCodeName())));

        List<InvItemVO> result = new ArrayList<>(collect.size());
        for (String group : collect.keySet()) {
            List<InvItemVO> detailViews = collect.get(group);
            String[] values = group.split("&");
            InvItemVO view = new InvItemVO();
            view.setTwGoodsCode(values[0]);
            view.setTwGoodsCodeName(values[1]);
            view.setChildren(detailViews);
            view.setGoodsNo(values[0]);
            view.setGoodsName(values[1]);
            result.add(view);
        }
        return result;
    }

    @Override
    public InvItemVO queryByKey(Long key) {
        InvItemDO entity = invItemRepo.findById(key).orElseGet(InvItemDO::new);
        Assert.notNull(entity.getId(), "不存在");
        InvItemVO vo = InvItemConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public InvItemVO insert(InvItemPayload payload) {
        InvItemDO entityDo = InvItemConvert.INSTANCE.toDo(payload);
        return InvItemConvert.INSTANCE.toVo(invItemRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public InvItemVO update(InvItemPayload payload) {
        InvItemDO entity = invItemRepo.findById(payload.getId()).orElseGet(InvItemDO::new);
        Assert.notNull(entity.getId(), "不存在");
        InvItemDO entityDo = InvItemConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return InvItemConvert.INSTANCE.toVo(invItemRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(InvItemPayload payload) {
        InvItemDO entity = invItemRepo.findById(payload.getId()).orElseGet(InvItemDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = invItemDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            invItemDAO.deleteSoft(keys);
        }
    }

    @Override
    public int getInvoiceItemFromBaiwang() {
        List<InvItemCatDO> cats = invItemCatRepo.findAll();
        for (InvItemCatDO cat : cats) {
            OutputProductcodeQueryRequest request = new OutputProductcodeQueryRequest() {{
            }};
            try {
                OutputProductcodeQueryResponse response = invoiceSendMsgService.invoiceProductCodeQuery(request);
                // 经测试，不抛异常，即为成功
                //log.info("[从百望获取发票商品信息成功],省市：", cat.getProvince(), "税局商品分类：",
                //    cat.getGoodsCodeName(), ",税局商品编码：", cat.getGoodsCode());
                log.info("[从百望获取发票商品信息成功],省市：{};税局商品分类：{};税局商品编码：{}", cat.getProvince(),
                        cat.getGoodsCodeName(), cat.getGoodsCode());
//                List<InvoiceGoodsCode> childrenNodeList = response.getResponse();
                //TODO:暂不清楚其必要性，后续待完善

            } catch (BopException e) {
                log.error("[从百望获取发票商品信息失败],省市：{};税局商品分类:{};税局商品编码:{}", cat.getProvince(),
                        cat.getGoodsCodeName(), cat.getGoodsCode(), e);
//                throw new RuntimeException("从百望获取发票商品信息失败,返回信息：" + e);
            }

        }
        return 0;
    }

}
