package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.tw.tw5.api.prd.my.payload.PwdForgotPayload;
import com.elitesland.tw.tw5.api.prd.my.service.PrdUserService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDate;
import java.util.Map;

/**
 * 个人管理
 *
 * @author wangding
 */
@Api("个人管理")
@RestController
@RequiredArgsConstructor
//@RequestMapping(API_SYSTEM)
@RequestMapping("/api/my")
@Slf4j
public class PrdUserController {

    private final PrdUserService service;
    private final PrdOrgEmployeeEqvaRatioService eqvaRatioService;
    private static final String PC_TYPE = "v5_pc_";


    /**
     * 查询个人菜单
     *
     * @return result
     */
    @GetMapping("/user/queryMenus")
    public TwOutputUtil queryMenus() {
        return TwOutputUtil.ok(service.queryMenus());
    }

    /**
     * 查询个人数据
     *
     * @return result
     */
    @PutMapping("/user/queryDetail")
    @UdcNameClass
    public TwOutputUtil queryDetail() {
        return TwOutputUtil.ok(service.queryUserDetail());
    }


    /**
     * 查询个人当前时间的当量系数
     *
     * @return result
     */
    @PutMapping("/user/eqvaRatio")
    public TwOutputUtil queryeqvaRatio(Long userId, String date) {
        LocalDate date1 = null;
        try {
            date1 = LocalDate.parse(date);
        } catch (Exception e) {
            throw TwException.error("", "日期格式不正确");
        }
        return TwOutputUtil.ok(eqvaRatioService.getEqvaRatio(userId, date1));
    }


    /**
     * 修改密码
     *
     * @param oldAndNewPassword 密码
     * @return result
     */
    @ApiOperation("")
    @PostMapping("/user/updatePassword")
    public TwOutputUtil updatePassword(@RequestBody Map<String, Object> oldAndNewPassword) {
        String oldPassword = oldAndNewPassword.get("oldPassword") + "";
        String newPassword = oldAndNewPassword.get("newPassword") + "";
        service.updatePassword(oldPassword, newPassword);
        return TwOutputUtil.ok();
    }

    /**
     * 修改个人快捷入口
     *
     * @param shortcutIds 快捷入口ids(","拼接字符串)
     * @return result
     */
    @PutMapping("/user/updateShortcut")
    public TwOutputUtil updateShortcut(String shortcutIds) {
        service.updateShortcut(shortcutIds);
        return TwOutputUtil.ok();
    }

    /**
     * 查询我的工作代办
     *
     * @return result
     */
    @GetMapping("/user/findMyWork")
    public TwOutputUtil findMyWork() {
        return TwOutputUtil.ok(service.findMyWork());
    }

    /**
     * 查询我的提醒
     *
     * @return result
     */
    @GetMapping("/user/findMyRemind")
    public TwOutputUtil findMyRemind() {
        return TwOutputUtil.ok(service.findMyRemind());
    }

    /**
     * 修改我的提醒
     *
     * @param remindType 提醒类型
     * @return result
     */
    @GetMapping("/user/updateMyRemind")
    public TwOutputUtil updateMyRemind(String remindType) {
        service.updateMyRemind(remindType);
        return TwOutputUtil.ok();
    }

    /**
     * 查询我的所有组织
     *
     * @return result
     */
    @GetMapping("/user/queryOrgList")
    public TwOutputUtil queryOrgList() {
        return TwOutputUtil.ok(service.queryOrgList());
    }

    /**
     * 查询我的所有下级
     *
     * @param orgId 组织id
     * @return result
     */
    @GetMapping("/user/queryLowList")
    public TwOutputUtil queryLowList(Long orgId) {
        return TwOutputUtil.ok(service.queryLowListByKey(orgId));
    }

    /**
     * 通过ticket获取用户数据
     * 接口作用：
     * 1、tw5.0跳转4.0，例如：5.0创建合同跳转至4.0
     * 2、tw4.0校验ticket
     *
     * @return result
     */
    @PostMapping("/user/queryUserByTicket")
    public void queryUserByTicket(HttpServletRequest request, HttpServletResponse response) {
        service.queryUserByTicket(request, response);
        // return TwOutputUtil.ok();
    }

    @ApiOperation("获取验证码-发送至邮箱")
    @PostMapping("/captcha/toEmail")
    public TwOutputUtil captcha2Email(@RequestParam String email) {
        //获取随机验证码，并保证5分钟内只能获取一次 ->发送至邮件
        try {
            service.captcha2Email(email, PC_TYPE);
        } catch (Exception exception) {
            log.error("验证码生成失败，原因 is {}", exception.getMessage());
            return TwOutputUtil.error("COM-ERROR", "验证码生成失败", null);
        }
        return TwOutputUtil.ok();
    }

    @ApiOperation("忘记密码")
    @PostMapping("/pwd/forgot")
    public TwOutputUtil forgotPwd(@RequestBody PwdForgotPayload payload) {
        try {
            service.forgotPwd(payload, PC_TYPE);
        } catch (IllegalArgumentException illArgException) {
            log.error("参数校验失败，原因 is {}", illArgException.getMessage());
            return TwOutputUtil.error("COM-ERROR", illArgException.getMessage(), null);
        } catch (BusinessException businessException) {
            log.error("邮箱/验证码/密码校验失败，原因 is {}", businessException.getMessage());
            return TwOutputUtil.error("COM-ERROR", businessException.getMessage(), null);
        }
        return TwOutputUtil.ok();
    }

}
