package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitesland.tw.tw5.api.prd.my.payload.ResActivityPayload;
import com.elitesland.tw.tw5.api.prd.my.query.ResActivityQuery;
import com.elitesland.tw.tw5.api.prd.my.service.ResActivityService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
* 工时-资源活动
*
* @author duh
* @date 2022-12-21
*/
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/my/resActivity")
@Slf4j
@Deprecated
public class ResActivityController {

    private final ResActivityService resActivityService;

    /**
    * 新增
    *
    * @param payload 有效载荷
    * @return {@link TwOutputUtil}
    */
    @PostMapping
    public TwOutputUtil insert(@RequestBody ResActivityPayload payload){
        return TwOutputUtil.ok(resActivityService.insert(payload));
    }

    /**
    * 更新
    *
    * @param payload 有效载荷
    * @return {@link TwOutputUtil}
    */
    @PutMapping
    public TwOutputUtil update(@RequestBody ResActivityPayload payload){
        return TwOutputUtil.ok(resActivityService.update(payload));
    }

    /**
    * 主键查询
    *
    * @param key 关键
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/{key}")
    // @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(resActivityService.queryByKey(key));
    }

    /**
    * 分页
    *
    * @param query 查询
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/paging")
    // @UdcNameClass
    public TwOutputUtil paging(ResActivityQuery query) {
        return TwOutputUtil.ok(resActivityService.paging(query));
    }

    /**
    * 查询列表
    *
    * @param query 查询
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/list")
    // @UdcNameClass
    public TwOutputUtil queryList(ResActivityQuery query) {
        return TwOutputUtil.ok(resActivityService.queryList(query));
    }

    /**
    * 删除
    *
    * @param keys 主键id
    * @return result
    */
    @DeleteMapping("/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        resActivityService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
