package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TAttendanceOtherPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TAttendanceOtherQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.ResAttendanceOtherVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceOtherVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.my.entity.QTAttendanceOtherDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TAttendanceOtherDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TAttendanceOtherRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;


@Repository
@RequiredArgsConstructor
public class TAttendanceOtherDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final TAttendanceOtherRepo repo;
    private final QTAttendanceOtherDO qdo = QTAttendanceOtherDO.tAttendanceOtherDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TAttendanceOtherVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(TAttendanceOtherVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 打卡人员
                qdo.attendanceResId,
                // 打卡日期
                qdo.attendanceDate,
                // 上班时间
                qdo.attendanceTimeStart,
                // 下班时间
                qdo.attendanceTimeEnd,
                // 打卡经度
                qdo.attendanceSiteLongitude,
                // 打卡维度
                qdo.attendanceSiteLatitude,
                // 打卡位置
                qdo.attendanceLocation,
                // 打卡说明
                qdo.attendanceRemark,
                // 打卡设备
                qdo.attendanceDevice
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<TAttendanceOtherVO> getJpaQueryWhere(TAttendanceOtherQuery query) {
        JPAQuery<TAttendanceOtherVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(TAttendanceOtherQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(TAttendanceOtherQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 打卡人员 精确 */
        if (!ObjectUtils.isEmpty(query.getAttendanceResId())) {
            list.add(qdo.attendanceResId.eq(query.getAttendanceResId()));
        }
        /** 打卡日期 精确 */
        if (!ObjectUtils.isEmpty(query.getAttendanceDate())) {
            list.add(qdo.attendanceDate.eq(query.getAttendanceDate()));
        }
        /** 上班时间 精确 */
        if (!ObjectUtils.isEmpty(query.getAttendanceTimeStart())) {
            list.add(qdo.attendanceTimeStart.eq(query.getAttendanceTimeStart()));
        }
        /** 下班时间 精确 */
        if (!ObjectUtils.isEmpty(query.getAttendanceTimeEnd())) {
            list.add(qdo.attendanceTimeEnd.eq(query.getAttendanceTimeEnd()));
        }
        /** 打卡经度 精确 */
        if (!ObjectUtils.isEmpty(query.getAttendanceSiteLongitude())) {
            list.add(qdo.attendanceSiteLongitude.eq(query.getAttendanceSiteLongitude()));
        }
        /** 打卡维度 精确 */
        if (!ObjectUtils.isEmpty(query.getAttendanceSiteLatitude())) {
            list.add(qdo.attendanceSiteLatitude.eq(query.getAttendanceSiteLatitude()));
        }
        /** 打卡位置 精确 */
        if (!ObjectUtils.isEmpty(query.getAttendanceLocation())) {
            list.add(qdo.attendanceLocation.eq(query.getAttendanceLocation()));
        }
        /** 打卡说明 精确 */
        if (!ObjectUtils.isEmpty(query.getAttendanceRemark())) {
            list.add(qdo.attendanceRemark.eq(query.getAttendanceRemark()));
        }
        /** 打卡设备 精确 */
        if (!ObjectUtils.isEmpty(query.getAttendanceDevice())) {
            list.add(qdo.attendanceDevice.eq(query.getAttendanceDevice()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public TAttendanceOtherVO queryByKey(Long id) {
        JPAQuery<TAttendanceOtherVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<TAttendanceOtherVO> queryListDynamic(TAttendanceOtherQuery query) {
        JPAQuery<TAttendanceOtherVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<TAttendanceOtherVO> queryPaging(TAttendanceOtherQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<TAttendanceOtherVO> jpaQuery = getJpaQueryWhere(query);
        List<TAttendanceOtherVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<TAttendanceOtherVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public TAttendanceOtherDO save(TAttendanceOtherDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<TAttendanceOtherDO> saveAll(List<TAttendanceOtherDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(TAttendanceOtherPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 打卡人员
        if (payload.getAttendanceResId() != null) {
            update.set(qdo.attendanceResId, payload.getAttendanceResId());
        }
        // 打卡日期
        if (payload.getAttendanceDate() != null) {
            update.set(qdo.attendanceDate, payload.getAttendanceDate());
        }
        // 上班时间
        if (payload.getAttendanceTimeStart() != null) {
            update.set(qdo.attendanceTimeStart, payload.getAttendanceTimeStart());
        }
        // 下班时间
        if (payload.getAttendanceTimeEnd() != null) {
            update.set(qdo.attendanceTimeEnd, payload.getAttendanceTimeEnd());
        }
        // 打卡经度
        if (payload.getAttendanceSiteLongitude() != null) {
            update.set(qdo.attendanceSiteLongitude, payload.getAttendanceSiteLongitude());
        }
        // 打卡维度
        if (payload.getAttendanceSiteLatitude() != null) {
            update.set(qdo.attendanceSiteLatitude, payload.getAttendanceSiteLatitude());
        }
        // 打卡位置
        if (payload.getAttendanceLocation() != null) {
            update.set(qdo.attendanceLocation, payload.getAttendanceLocation());
        }
        // 打卡说明
        if (payload.getAttendanceRemark() != null) {
            update.set(qdo.attendanceRemark, payload.getAttendanceRemark());
        }
        // 打卡设备
        if (payload.getAttendanceDevice() != null) {
            update.set(qdo.attendanceDevice, payload.getAttendanceDevice());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 打卡人员
            if (nullFields.contains("attendanceResId")) {
                update.setNull(qdo.attendanceResId);
            }
            // 打卡日期
            if (nullFields.contains("attendanceDate")) {
                update.setNull(qdo.attendanceDate);
            }
            // 上班时间
            if (nullFields.contains("attendanceTimeStart")) {
                update.setNull(qdo.attendanceTimeStart);
            }
            // 下班时间
            if (nullFields.contains("attendanceTimeEnd")) {
                update.setNull(qdo.attendanceTimeEnd);
            }
            // 打卡经度
            if (nullFields.contains("attendanceSiteLongitude")) {
                update.setNull(qdo.attendanceSiteLongitude);
            }
            // 打卡维度
            if (nullFields.contains("attendanceSiteLatitude")) {
                update.setNull(qdo.attendanceSiteLatitude);
            }
            // 打卡位置
            if (nullFields.contains("attendanceLocation")) {
                update.setNull(qdo.attendanceLocation);
            }
            // 打卡说明
            if (nullFields.contains("attendanceRemark")) {
                update.setNull(qdo.attendanceRemark);
            }
            // 打卡设备
            if (nullFields.contains("attendanceDevice")) {
                update.setNull(qdo.attendanceDevice);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    public List<ResAttendanceOtherVO> getAttendanceResOther(Long resId, LocalDate attendanceDateStart, LocalDate attendanceDateEnd) {
        JPAQuery<ResAttendanceOtherVO> jpaQuery = jpaQueryFactory.select(Projections.bean(ResAttendanceOtherVO.class,
                        qdo.id,
                        qdo.attendanceDate,
                        qdo.attendanceTimeStart,
                        qdo.attendanceTimeEnd,
                        qdo.attendanceRemark
                ))
                .from(qdo)
                .where(qdo.attendanceResId.eq(resId));

        if (attendanceDateStart != null) {
            jpaQuery.where(qdo.attendanceDate.goe(attendanceDateStart));
        }
        if (attendanceDateEnd != null) {
            jpaQuery.where(qdo.attendanceDate.loe(attendanceDateEnd));
        }

        return jpaQuery.orderBy(qdo.attendanceTimeStart.asc())
                .fetch();
    }
}