package com.elitesland.tw.tw5.server.prd.my.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TUserVacationCancelPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.UserVacationApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TUserVacationCancelQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetService;
import com.elitesland.tw.tw5.api.prd.my.service.TUserVacationCancelService;
import com.elitesland.tw.tw5.api.prd.my.vo.TUserVacationCancelVO;
import com.elitesland.tw.tw5.api.prd.my.vo.UserVacationApplyVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.VacationTypeEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.TUserVacationCancelConvert;
import com.elitesland.tw.tw5.server.prd.my.convert.UserVacationApplyConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TUserVacationCancelDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.UserVacationApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.UserVacationApplyDetailDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.UserVacationDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TUserVacationCancelDO;
import com.elitesland.tw.tw5.server.prd.my.entity.UserVacationApplyDO;
import com.elitesland.tw.tw5.server.prd.my.entity.UserVacationApplyDetailDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TUserVacationCancelRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.UserVacationApplyRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.DeleteProcessPayload;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 假期取消申请
 *
 * @author carl
 * @date 2024-06-18
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TUserVacationCancelServiceImpl extends BaseServiceImpl implements TUserVacationCancelService {

    private final TUserVacationCancelRepo tUserVacationCancelRepo;
    private final TUserVacationCancelDAO tUserVacationCancelDAO;
    private final WorkflowUtil workflowUtil;
    private final CacheUtil cacheUtil;
    private final TransactionUtilService transactionUtilService;
    //接口不好加，只能直接调用dao
    private final UserVacationApplyRepo userVacationApplyRepo;
    private final UserVacationApplyDAO userVacationApplyDAO;
    private final UserVacationApplyDetailDAO userVacationApplyDetailDAO;
    private final UserVacationDAO userVacationDAO;
    private final PmsProjectService pmsProjectService;
    private final PrdSystemRoleService roleService;
    private final PmsTimesheetService timesheetService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TUserVacationCancelVO insertOrUpdate(TUserVacationCancelPayload payload) {

        checkData(payload);
        String procInstId = null;
        if (payload.getId() != null) {
            TUserVacationCancelVO tUserVacationCancelVO = tUserVacationCancelDAO.queryByKey(payload.getId());
            if (tUserVacationCancelVO == null) {
                throw TwException.error("", "变更数据不存在");
            }
            procInstId = tUserVacationCancelVO.getProcInstId();
        } else {
            payload.setCancelDate(LocalDate.now());
        }
        TUserVacationCancelDO aDo = TUserVacationCancelConvert.INSTANCE.toDo(payload);
        TUserVacationCancelDO save = tUserVacationCancelDAO.save(aDo);
        payload.setId(save.getId());
        payload.setProcInstId(procInstId);

        Boolean isUp = false;
        TUserVacationCancelPayload payload0 = new TUserVacationCancelPayload();
        if (!StringUtils.hasText(procInstId)) {
            //发起流程
            startProcess(payload, payload0);
            isUp = true;
        } else {
            if (!StringUtils.hasText(payload.getProcInstStatus()) || ProcInstStatus.NOTSUBMIT.name().equals(payload.getProcInstStatus()) || ProcInstStatus.REJECTED.name().equals(payload.getProcInstStatus())) {
                // 重新给流程参数赋值
                HashMap<String, Object> variables = new HashMap<>();
                dealVariables(payload, variables);
                workflowUtil.setVariables(SetVariablesPayload.of(payload.getProcInstId(), variables));
                payload0.setId(payload.getId());
                payload0.setProcInstStatus(ProcInstStatus.APPROVING.name());
                isUp = true;
            }

        }
        if (isUp) {
            transactionUtilService.executeWithRunnable(() -> {
                tUserVacationCancelDAO.updateByKeyDynamic(payload0);
            });
        }

        return TUserVacationCancelConvert.INSTANCE.toVo(save);
    }

    void checkData(TUserVacationCancelPayload payload) {
        if (payload.getApplyId() == null) {
            throw TwException.error("", "变更假期传值错误");
        }
        Optional<UserVacationApplyDO> userVacationApply = userVacationApplyRepo.findById(payload.getApplyId());
        if (!userVacationApply.isPresent()) {
            throw TwException.error("", "变更数据不存在");
        }
        UserVacationApplyDO userVacationApplyDO = userVacationApply.get();
        if (!StringUtils.hasText(userVacationApplyDO.getProcInstStatus().name()) || !ProcInstStatus.APPROVED.name().equals(userVacationApplyDO.getProcInstStatus().name())) {
            throw TwException.error("", "仅支持审批通过数据处理");
        }
        if (VacationTypeEnum.REWARD.getCode().equals(userVacationApplyDO.getVacationType())) {
            throw TwException.error("", "奖励假暂不支持变更");
        }
        //判断是否重复对请假单撤销
        TUserVacationCancelQuery query = new TUserVacationCancelQuery();
        query.setApplyId(payload.getApplyId());
        List<TUserVacationCancelVO> vos = tUserVacationCancelDAO.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(vos)) {
            List<String> stringList = Arrays.asList(ProcInstStatus.DELETE.name(), ProcInstStatus.INVALID.name());
            List<TUserVacationCancelVO> collect = vos.stream().filter(vo -> !stringList.contains(vo.getProcInstStatus())).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(collect)) {
                if (payload.getId() == null) {
                    throw TwException.error("", "请假单号：【" + userVacationApplyDO.getApplyNo() + "】不可重复操作");
                } else {
                    if (collect.size() > 1 || collect.get(0).getId().longValue() != payload.getId().longValue()) {
                        throw TwException.error("", "请假单号：【" + userVacationApplyDO.getApplyNo() + "】不可重复操作");
                    }
                }
            }

        }

        payload.setApplyNo(userVacationApplyDO.getApplyNo());
        //赋值请假数据
        payload.setUserVacationApplyPayload(UserVacationApplyConvert.INSTANCE.doToPayload(userVacationApplyDO));
    }

    /**
     * 提交流程
     *
     * @param payload
     */
    void startProcess(TUserVacationCancelPayload payload, TUserVacationCancelPayload payload0) {
        HashMap<String, Object> variables = new HashMap<>();
        // 处理对应的审批参数
        dealVariables(payload, variables);

        String operTypeDesc = "取消请假申请";
        if (StringUtils.hasText(payload.getOperType()) && "2".equals(payload.getOperType())) {
            operTypeDesc = "修改请假申请";
        }
        String userName = cacheUtil.getUserName(payload.getUserId());
        String procInstName = "A36." + ProcDefKey.RES_VACATION_CANCEL.getDesc() + "-" + userName + "-" + payload.getApplyNo() + "-" + operTypeDesc;
        //发起流程审批
        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                ProcDefKey.RES_VACATION_CANCEL.name(),
                procInstName,
                payload.getId() + "",
                variables)
        );
        payload0.setId(payload.getId());
        payload0.setProcInstId(processInfo.getProcInstId());
        payload0.setProcInstStatus(processInfo.getProcInstStatus().name());
    }

    // 处理审批参数
    private void dealVariables(TUserVacationCancelPayload payload, HashMap<String, Object> variables) {
        UserVacationApplyPayload userVacationApplyPayload = payload.getUserVacationApplyPayload();
        //是否在项目上
        Boolean inProjectFlag = false;
        if (userVacationApplyPayload.getInProjectFlag() != null) {
            int b = userVacationApplyPayload.getInProjectFlag().intValue();
            inProjectFlag = (b == 0 ? false : true);
        }
        variables.put("inProjectFlag", inProjectFlag);
        //请假人
        variables.put("Activity_01j7rlu", CollUtil.newArrayList(payload.getUserId()));
        //项目经理
        variables.put("Activity_0y8vbtz", 0);
        if (inProjectFlag && userVacationApplyPayload.getProjectId() != null) {
            PmsProjectVO pmsProjectVO = pmsProjectService.queryByKeySimple(userVacationApplyPayload.getProjectId());
            PmsProjectVO projectVO = pmsProjectVO;
            Long pmUserId = projectVO.getPmResId();
            variables.put("Activity_0y8vbtz", CollUtil.newArrayList(pmUserId));
        }
        //直属领导
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = cacheUtil.getUserDefaultOrg(payload.getUserId());
        if (prdOrgEmployeeRefVO == null) {
            throw TwException.error("", "员工组织关系异常,请联系管理员");
        }
        if (prdOrgEmployeeRefVO.getParentId() == null) {
            throw TwException.error("", "员工上级不存在,请联系管理员");
        }
        variables.put("Activity_1dth2c5", CollUtil.newArrayList(prdOrgEmployeeRefVO.getParentId()));
        //休假管理员
        List<Long> vacationAdmin = roleService.queryUserIdByRoleCodes(CollUtil.newArrayList(RoleEnum.PLAT_SALARY_MANAGER.getCode(), RoleEnum.PLAT_SALARY_SPECIALIST.getCode()));
        variables.put("Activity_0y87nt8", vacationAdmin);
    }

    @Override
    public PagingVO<TUserVacationCancelVO> queryPaging(TUserVacationCancelQuery query) {
        return tUserVacationCancelDAO.queryPaging(query);
    }

    @Override
    public List<TUserVacationCancelVO> queryListDynamic(TUserVacationCancelQuery query) {
        return tUserVacationCancelDAO.queryListDynamic(query);
    }

    @Override
    public TUserVacationCancelVO queryByKey(Long key) {
        TUserVacationCancelVO tUserVacationCancelVO = tUserVacationCancelDAO.queryByKey(key);
        //  tUserVacationCancelVO.setCompanyName(cacheUtil.getCompanyName(tUserVacationCancelVO.getCompanyId()));
        UserVacationApplyDO userVacationApplyDO = userVacationApplyRepo.findById(tUserVacationCancelVO.getApplyId()).get();
        UserVacationApplyVO userVacationApplyVO = UserVacationApplyConvert.INSTANCE.doToVo(userVacationApplyDO);
        if (StringUtils.hasText(userVacationApplyVO.getProjectId())) {
            PmsProjectVO pmsProjectVO = pmsProjectService.queryByKeySimple(Long.valueOf(userVacationApplyVO.getProjectId()));
            userVacationApplyVO.setProjectName(pmsProjectVO.getProjName());
        }

        tUserVacationCancelVO.setUserVacationApplyVO(userVacationApplyVO);
        return tUserVacationCancelVO;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TUserVacationCancelPayload payload) {
//        TUserVacationCancelDO entity = tUserVacationCancelRepo.findById(payload.getId()).orElseGet(TUserVacationCancelDO::new);
//        Assert.notNull(entity.getId(), "不存在");
        long result = tUserVacationCancelDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<TUserVacationCancelVO> tUserVacationCancelVOS = tUserVacationCancelDAO.queryByKeys(keys);
            tUserVacationCancelVOS.forEach(vo -> {
                if (!ProcInstStatus.NOTSUBMIT.name().equals(vo.getProcInstStatus()) && !ProcInstStatus.REJECTED.name().equals(vo.getProcInstStatus())) {
                    throw TwException.error("", "不支持删除操作");
                }
                try {
                    //删除流程
                    if (StringUtils.hasText(vo.getProcInstId())) {
                        workflowUtil.deleteProcess(DeleteProcessPayload.of(vo.getProcInstId(), ""));
                    }
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
            tUserVacationCancelDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void processStatusChange(TUserVacationCancelPayload payload) {
        /**
         * 1.非审批通过
         *   1.1 直接更新数据
         * 2.审批通过
         *   2.1 先回退假期
         *   2.2 修改假期申请状态
         *   2.3 修改假期申请明细状态
         *   2.4 删除工时
         *   2.5 直接更新数据
         */
        if (ProcInstStatus.APPROVED.name().equals(payload.getProcInstStatus())) {

            TUserVacationCancelVO tUserVacationCancelVO = tUserVacationCancelDAO.queryByKey(payload.getId());
            payload.setApplyId(tUserVacationCancelVO.getApplyId());
            UserVacationApplyDO applyDO = userVacationApplyRepo.findById(payload.getApplyId()).get();
            if (!ObjectUtils.isEmpty(applyDO.getVacationId()) && !ObjectUtils.isEmpty(applyDO.getVacationDays())) {
                // 2.1 先回退假期
                BigDecimal negate = applyDO.getVacationDays().negate();
                userVacationDAO.updateUsedDays(applyDO.getVacationId(), negate);
            }
            // 2.2 修改假期申请状态
            UserVacationApplyPayload userVacationApplyPayload = new UserVacationApplyPayload();
            userVacationApplyPayload.setId(payload.getApplyId());
            userVacationApplyPayload.setProcInstStatus(ProcInstStatus.INVALID);
            userVacationApplyDAO.updateProcData(userVacationApplyPayload);
            //2.3 修改假期申请明细状态
            userVacationApplyDetailDAO.updateProcStatusByApplyId(payload.getApplyId(), ProcInstStatus.INVALID);
            // 2.4 删除工时
            List<UserVacationApplyDetailDO> vacationApplyDetailDOS = userVacationApplyDetailDAO.findByApplyId(payload.getApplyId());
            List<Long> applyDetailIds = vacationApplyDetailDOS.stream().map(e -> e.getId()).collect(Collectors.toList());
            timesheetService.deleteVacationPrivateTimesheet(applyDetailIds);
        }
        //1.1 直接更新数据
        tUserVacationCancelDAO.updateByKeyDynamic(payload);
    }

}
