package com.elitesland.tw.tw5.server.prd.my.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.ResActivityPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TaskPayload;
import com.elitesland.tw.tw5.api.prd.my.query.ResActivityQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TaskAuthorizedDetailsQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TaskQuery;
import com.elitesland.tw.tw5.api.prd.my.service.ResActivityService;
import com.elitesland.tw.tw5.api.prd.my.service.TaskAuthorizedDetailsService;
import com.elitesland.tw.tw5.api.prd.my.service.TaskAuthorizedService;
import com.elitesland.tw.tw5.api.prd.my.service.TaskService;
import com.elitesland.tw.tw5.api.prd.my.vo.*;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.my.constant.TaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.ResActivityConvert;
import com.elitesland.tw.tw5.server.prd.my.convert.TaskConvert;
import com.elitesland.tw.tw5.server.prd.my.entity.ProjectDO;
import com.elitesland.tw.tw5.server.prd.my.entity.ResActivityDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TaskAuthorizedDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TaskDO;
import com.elitesland.tw.tw5.server.prd.my.repo.*;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 工时用-任务表
 *
 * @author duwh
 * @date 2022-12-09
 */
@Service
@RequiredArgsConstructor
@Slf4j
@Deprecated
public class TaskServiceImpl implements TaskService {

    private final TaskRepo taskRepo;
    private final HttpUtil httpUtil;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final ProjectRepo projectRepo;
    private final ResActivityService resActivityService;
    private final TaskAuthorizedService taskAuthorizedService;
    private final TaskAuthorizedRepo taskAuthorizedRepo;
    private final TaskAuthorizedDetailsService taskAuthorizedDetailsService;
    private final TimesheetPlanRepo timesheetPlanRepo;
    private final TimesheetPlanTempRepo timesheetPlanTempRepo;
    private final TimesheetBiweeklyRepo timesheetBiweeklyRepo;
    private final PrdOrgEmployeeService employeeService;
    private final ResActivityRepo resActivityRepo;

    @Value("${tw4.timesheet.task:api/openReport/v1/sync/taskApply}")
    private String timesheet_task;

    @Value("${tw4.url}")
    private String tw4_url;
    @Value("${tw4.sync.getProjectEqvaInfo:api/openReport/v1/sync/getProjectEqvaInfo}")
    private String getProjectEqvaInfo;

    @Override
    public PagingVO<TaskVO> paging(TaskQuery query) {
        Page<TaskDO> page = taskRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(TaskConvert.INSTANCE::toVo));
    }

    @Override
    public List<TaskVO> queryList(TaskQuery query) {
        Sort sort = Sort.by(Sort.Direction.DESC, "effectiveEqva");
        return TaskConvert.INSTANCE.toVoList(taskRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), sort));
    }

    @Override
    public List<ProjectAndTaskVO> queryListForSelect(TaskQuery query) {
        return TaskConvert.INSTANCE.toSelectVoList(taskRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Override
    public TaskVO queryByKey(Long key) {
        TaskDO entity = taskRepo.findById(key).orElseGet(TaskDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TaskVO vo = TaskConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    public TaskVO queryByTaskIdV4(Long taskIdV4) {
        TaskDO entity = taskRepo.getByTaskIdV4(taskIdV4);
        Assert.notNull(entity, "任务不存在");
        TaskVO vo = TaskConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TaskVO insert(TaskPayload payload) {
        // 校验任务包关联的项目类型，如果是自主研发（软件），禁止申请
        if(payload.getReasonType()!=null && payload.getReasonType().equals("01")){
            // 这里用的是4.0的id,要考虑到后面切换过来的问题
            Long reasonId = payload.getReasonId();
            //通过项目id查合同
            String workType = projectRepo.findWorkTypeById(reasonId);
            String workType1 = projectRepo.findWorkTypeById1(reasonId);
            if((StringUtils.hasText(workType) && workType.equals("INDEPENDENT")) || (StringUtils.hasText(workType1) && workType1.equals("INDEPENDENT"))){
                throw TwException.error("","自主研发（软件）项目无法申请任务包！");
            }
        }
//        check(payload);
        //将旧值克隆出来
        TaskPayload taskCopyPayload = new TaskPayload();
        BeanUtils.copyProperties(payload, taskCopyPayload);
        //同步数据到4.0
        if (null != payload.getReceiverUserId()) {
            taskCopyPayload.setReceiverUserId(employeeDAO.getV4UserId(payload.getReceiverUserId()));
        }
        if (null != payload.getDisterUserId()) {
            taskCopyPayload.setDisterUserId(employeeDAO.getV4UserId(payload.getDisterUserId()));
        }
//        Long reasonId = taskCopyPayload.getReasonId();//项目id
//        taskCopyPayload.setReasonId(projectRepo.queryByProjectIdV4(reasonId));

        Map<String, Object> map = BeanUtil.beanToMap(taskCopyPayload);
        map.put("eqvaRatio", null);//不同步派发当量系数到4.0
        String result = httpUtil.sendPost(tw4_url + timesheet_task, map);
//        Map<String,Object> resultMap = (Map) JSON.parse("result");
//        if(resultMap.get("ok").equals("false")){
//            String errmsg = resultMap.get("reason") + "";
//            throw TwException.error(resultMap.get("errcode") + "", "同步数据失败,详情：" + errmsg);
//        }
//        String taskDatum = httpUtil.geResultDataSimple(result);
        Map parse = (Map) JSON.parse(result);
        if ((parse.get("ok") + "").equals("true")) {
            if (parse.get("datum") != null) {
                parse = (Map) parse.get("datum");
                Object taskId = parse.get("id");
                String taskNo = (String) parse.get("taskNo");
                BigDecimal taskEqva = (BigDecimal) parse.get("eqvaQty");
                Long reasonId = -1L;
                if (parse.get("reasonId") != null) {
                    reasonId = Long.valueOf(parse.get("reasonId").toString());
                }
                List<Map<String, Object>> resActivityList = (List<Map<String, Object>>) parse.get("resActivityList");
                for (Map<String, Object> stringObjectMap : resActivityList) {
                    ResActivityPayload resActivityPayload = BeanUtil.mapToBean(ResActivityPayload.class, stringObjectMap, new ArrayList<>());
                    resActivityPayload.setActivityIdV4(resActivityPayload.getId());
                    resActivityService.insert(resActivityPayload);
                }

                long taskIdV4 = -999;
                taskIdV4 = Long.valueOf(taskId.toString());
                payload.setTaskIdV4(taskIdV4);
                payload.setTaskNo(taskNo);
                payload.setReasonIdv4(reasonId);
                payload.setBaseTaskEqva(payload.getEqvaQty());
                payload.setEqvaRatio(null);
                payload.setTaskStatus("DISPATCH");
                payload.setEffectiveEqva(taskEqva);
                TaskDO entityDo = TaskConvert.INSTANCE.toDo(payload);
                TaskVO taskVO = TaskConvert.INSTANCE.toVo(taskRepo.save(entityDo));
                //4.0taskId获取活动列表
                ResActivityQuery resActivityQuery = new ResActivityQuery();
                resActivityQuery.setTaskId(taskVO.getTaskIdV4());
                List<ResActivityVO> resActivityVOS = resActivityService.queryList(resActivityQuery);
                taskVO.setActivityList(resActivityVOS);
                return taskVO;
            }
            return null;

        } else {
            throw TwException.error(parse.get("errCode") + "", parse.get("reason") + "");
        }
    }

    /**
     * 参数校验
     *
     * @param payload 有效载荷
     */
    private void check(TaskPayload payload) {
//        final int yearWeek = Integer.parseInt(DateUtil.getYearWeek(payload.getWorkDate()));
//        final int lastyearWeek = Integer.parseInt(DateUtil.getYearWeek(payload.getWorkDate().minusWeeks(1)));
//        // 校验已提交周报的 不允许再编辑新增
//        TimesheetBiweeklyQuery timesheetBiweeklyQuery = new TimesheetBiweeklyQuery();
//        timesheetBiweeklyQuery.setYearWeekIn(Arrays.asList(yearWeek,lastyearWeek));
//        timesheetBiweeklyQuery.setTsUserId(GlobalUtil.getLoginUserId());
//        final Long count = timesheetBiweeklyRepo
//                .count((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, timesheetBiweeklyQuery, criteriaBuilder));
//        if (count > 0) {
//            throw TwException.error("", "审批中的数据不可以操作");
//        }
    }
    @Override
    @Transactional(rollbackFor = Exception.class)
    public TaskVO update(TaskPayload payload) {
        TaskDO entity = taskRepo.findById(payload.getId()).orElseGet(TaskDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TaskDO entityDo = TaskConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TaskConvert.INSTANCE.toVo(taskRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            taskRepo.deleteSoft(keys);
        }
    }

    @Override
    public List<TaskVO> selectTaskForTimesheet(TaskQuery query, Long projIdV4, boolean test) {
        if (null == query.getEffectiveEqva()) {
            query.setEffectiveEqva(new BigDecimal("0.05"));
        }
        if (projIdV4 == 0) {
            /**
             * @Select({"select id id,task_name taskName,reason_id reasonId,task_status taskStatus",
             *             "from T_TASK where del_flag = 0 and task_status = 'IN PROCESS' and reason_type != '01' and RECEIVER_RES_ID = #{resId} "})
             *
             */
            query.setTaskStatus(TaskStatusEnum.ACTIVE.getCode());
            query.setNotEqualReasonType("01");
            // 查询接包人是自己的
            if (!test) {
                query.setReceiverUserId(GlobalUtil.getLoginUserId());
            }
            // 如果项目ID为0，则查询事由类型为bu和售前的任务包
            final List<TaskVO> taskVOS = queryList(query);
            List<Long> taskIdList = taskVOS.stream().map(e -> e.getTaskIdV4()).collect(Collectors.toList());
            ResActivityQuery resActivityQuery = new ResActivityQuery();
            resActivityQuery.setTaskIds(taskIdList);
            List<ResActivityDO> resActivityDOS = resActivityRepo.queryByTaskIdIn(taskIdList);
            final List<ResActivityVO> resActivityVOS = resActivityDOS.stream().map(e -> ResActivityConvert.INSTANCE.toVo(e)).collect(Collectors.toList());

            if (!CollectionUtils.isEmpty(taskVOS)) {
                taskVOS.forEach(taskVO -> {
//                    ResActivityQuery resActivityQuery = new ResActivityQuery();
//                    resActivityQuery.setTaskId(taskVO.getTaskIdV4());
//                    final List<ResActivityVO> resActivityVOS = resActivityService.queryList(resActivityQuery);
                    List<ResActivityVO> resActivityVOS1= resActivityVOS.stream().filter(e->e.getTaskId().equals(taskVO.getTaskIdV4())).collect(Collectors.toList());
                    taskVO.setActivityList(resActivityVOS1);
                });
            }
            return taskVOS;
        } else {
            /**
             *  @Select({"select id id,task_name taskName,reason_id reasonId,task_status taskStatus, plan_start_date planStartDate, plan_end_date planEndDate",
             *             "from T_TASK where del_flag = 0 and task_status in( 'IN PROCESS','PENDING') and reason_type = '01' and reason_id = #{id} and RECEIVER_RES_ID = #{resId} "})
             *
             */
            // 否则查询项目关联的任务包
            //query.setTaskStatus("IN PROCESS");
            List<String> taskStatusList = new ArrayList<>();
            taskStatusList.add(TaskStatusEnum.ACTIVE.getCode());
            //taskStatusList.add(TaskStatusEnum.PENDING.getCode());
            query.setTaskStatusList(taskStatusList);
            query.setReasonType("01");
            // 查询接包人是自己的
            if (!test) {
                query.setReceiverUserId(GlobalUtil.getLoginUserId());
            }
            query.setReasonIdv4(projIdV4);

            final List<TaskVO> taskVOS = queryList(query);
            if (!CollectionUtils.isEmpty(taskVOS)) {
                taskVOS.forEach(taskVO -> {
                    ResActivityQuery resActivityQuery = new ResActivityQuery();
                    resActivityQuery.setTaskId(taskVO.getTaskIdV4());
                    final List<ResActivityVO> resActivityVOS = resActivityService.queryList(resActivityQuery);
                    taskVO.setActivityList(resActivityVOS);
                });
            }
            return taskVOS;
        }
    }

    @Override
    public Map<Long, Long> getV4AndV5TaskIds() {
        Map<Long, Long> taskMap = new HashMap<>();
        //查询用户列表
        List<Map<String, Object>> v4AndV5TaskIds = taskRepo.getV4AndV5TaskIds();
        for (Map<String, Object> v4AndV5TaskId : v4AndV5TaskIds) {
            Long taskId = (Long) v4AndV5TaskId.get("taskId");
            Long taskIdV4 = (Long) v4AndV5TaskId.get("taskIdV4");
            taskMap.put(taskIdV4, taskId);
        }
        return taskMap;
    }

    @Override
    @Transactional
    public String updateTaskStatus(Long idV4, String status) {
        taskRepo.updateTaskStatus(idV4, status);
        List<TaskDO> taskDOS = taskRepo.queryByTaskIdV4In(Collections.singletonList(idV4));
        TaskDO taskDO = taskDOS.get(0);
        timesheetPlanRepo.updateByTaskId(taskDO.getTaskIdV4(), taskDO.getTaskName(), status, taskDO.getEqvaQty());
        timesheetPlanTempRepo.updateByTaskId(taskDO.getTaskIdV4(), taskDO.getTaskName(), status, taskDO.getEqvaQty());
        return null;
    }

    @Override
    @Transactional
    public String updateTaskReason(Long taskIdV4, String reasonType, Long reasonId, Long expenseBuId) {
        //这里用的都是4.0的id
        taskRepo.updateTaskMess(taskIdV4, reasonId, expenseBuId);
        return null;
    }

    @Override
    public List<PrdOrgEmployeeVO> getDisterUserIds(Long projectId) {
        Set<Long> userIds = new HashSet<>();
        PrdOrgEmployeeQuery query = new PrdOrgEmployeeQuery();
        // 查项目经理及任务包被授权人
        ProjectDO projectDO = projectRepo.findByProjIdV4(projectId).orElse(null);
        if (!ObjectUtils.isEmpty(projectDO)){
            Long pmUserId = projectDO.getPmUserId();
            // 查询任务包授权列表
            List<TaskAuthorizedDO> taskAuthorizedDOS = taskAuthorizedRepo.queryByReasonTypeAndReasonIdAndDeleteFlag("01", projectId,0);
            List<Long> collect = taskAuthorizedDOS.stream().map(e -> e.getReceiverUserId()).collect(Collectors.toList());
            if(pmUserId!=null){
                userIds.add(pmUserId);
            }
            if(!CollectionUtils.isEmpty(collect)){
                userIds.addAll(collect);
            }
        } else{
            throw TwException.error("","未找到对应的项目");
        }
        query.setUserIdList(userIds);
        return employeeService.queryList(query);
    }

    /**
     * 根据任务主键判断是否是基于授权的任务包
     * 根据授权配置 取审批人是PM(项目经理) or PL（授权接收资源）
     *
     * @param taskId 任务id
     * @return {@link Long}
     */
    @Override
    public Long getApprResIdByAuthInfo(Long taskId) {
        // 如果是基于授权发放的任务包，需要判断授权配置中是授权派发人（一般是PM）审批 还是授权接收人（一般是PL）
        TaskAuthorizedDetailsQuery authorizedDetailsQuery = new TaskAuthorizedDetailsQuery();
        authorizedDetailsQuery.setTaskId(taskId);
        final List<TaskAuthorizedDetailsVO> taskAuthorizedDetailsVOS = taskAuthorizedDetailsService.queryList(authorizedDetailsQuery);
        if (!CollectionUtils.isEmpty(taskAuthorizedDetailsVOS)) {
            final Long authId = taskAuthorizedDetailsVOS.get(0).getAuthIdV5();

            final TaskAuthorizedVO taskAuthorizedVO = taskAuthorizedService.queryByKey(authId);
            if (null != taskAuthorizedVO) {
                final String approvedType = taskAuthorizedVO.getApprovedType();
                if (StringUtils.hasText(approvedType)) {
                    if (approvedType.equals("PM")) {
                        return taskAuthorizedVO.getDisterUserId();
                    } else if (approvedType.equals("PL")) {
                        return taskAuthorizedVO.getReceiverUserId();
                    } else {
                        log.info("===================>基于授权发放的任务包;授权配置APPROVED_TYPE[" + approvedType + "]异常：授权主键=" + authId + ";");
                    }
                } else {
                    log.info("===================>基于授权发放的任务包;授权配置异常：授权主键=" + authId + ";");
                }
            }
        }
        return null;
    }


}
