package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanDetailService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanDetailVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetListPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPayload;
import com.elitesland.tw.tw5.api.prd.my.query.ProjectQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetApproveQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.service.*;
import com.elitesland.tw.tw5.api.prd.my.vo.*;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeLeaderQuery;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeSuperiorQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsApprovalResPayload;
import com.elitesland.tw.tw5.api.prd.ts.query.TsApprovalResQuery;
import com.elitesland.tw.tw5.api.prd.ts.service.TsApprovalResService;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsApprovalResVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RestStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdUserDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.TimesheetDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.OvertimeApplicationDO;
import com.elitesland.tw.tw5.server.prd.my.entity.QTimesheetDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TaskRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetBiweeklyReadFlagRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.VacationRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgEmployeeRepo;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.work.dao.OvertimeApplicationDAO;
import com.elitesland.tw.tw5.server.prd.work.repo.OvertimeApplicationRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

import static com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus.*;

/**
 * 工时表
 *
 * @author duwh
 * @date 2022-12-09
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TimesheetServiceImpl implements TimesheetService {

    private final TimesheetRepo timesheetRepo;
    private final TaskService taskService;
    private final TaskRepo taskRepo;
    private final ResActivityService resActivityService;
    private final CrmOperationPlanDetailService crmOperationPlanDetailService;
    private final ProjectService projectService;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdUserService prdUserService;
    private final HttpUtil httpUtil;
    private final PrdOrgSyncLogDAO daoLog;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final PrdUserDAO daoUser;
    private final PrdOrgOrganizationDAO prdOrgOrganizationDAO;
    private final TimesheetDAO timesheetDAO;
    private final TimesheetBiweeklyReadFlagRepo biweeklyReadFlagRepo;
    private final PrdOrgEmployeeEqvaRatioService employeeEqvaRatioService;
    private final QyWxCommunicationService qyWxCommunicationService;
    private final PrdOrgEmployeeDAO prdOrgEmployeeDAO;
    private final PrdOrgEmployeeRepo prdOrgEmployeeRepo;
    private final OvertimeApplicationRepo overtimeApplicationRepo;
    private final OvertimeApplicationDAO overtimeApplicationDAO;
    private final PrdOrgEmployeeService prdOrgEmployeeService;
    private final VacationRepo vacationRepo;

    private final UserVacationApplyService vacationApplyService;


    @Value("${tw4.url}")
    private String tw4_url;
    @Value("${tw4.sync.getProjectEqvaInfo:api/openReport/v1/sync/getProjectEqvaInfo}")
    private String getProjectEqvaInfo;
    private final TsApprovalResService tsApprovalResService;


    /**
     * 工时分页查询
     * see PmsTimesheetServiceImpl.paging
     *
     * @param query 查询
     * @return {@link PagingVO}<{@link TimesheetVO}>
     */
    @Override
    @Deprecated
    public PagingVO<TimesheetVO> paging(TimesheetQuery query) {
        getPermissionParams(query);
        return PagingVO.empty();
        // return timesheetDAO.queryPaging(query);
//        Page<TimesheetDO> page = timesheetRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
//        return PageUtil.toPageVo(page.map(TimesheetConvert.INSTANCE::toVo));
    }


    private void getPermissionParams(TimesheetQuery query) {
        if (query.getIsPermission()) {
            final Long loginUserId = GlobalUtil.getLoginUserId();
            // 判断 管理员
            final boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
            if (!isSystemAdmin) {
                // 判断当前登录人是否是系统管理员or 拥有角色【客户经营管理员	CUST_OPER_MANAGER】
                List<Long> userIdsByPlatRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.TIME_SHEET_MANAGER.getCode()));
                // BU级权限（查看当前登录人是否是部门负责人）
                final List<PrdOrgOrganizationDO> organizationDOList = prdOrgOrganizationDAO.queryByManagerId(loginUserId);
                Set<Long> orgIdList = null;
                if (!CollectionUtils.isEmpty(organizationDOList)) {
                    orgIdList = organizationDOList.stream().map(PrdOrgOrganizationDO::getId).collect(Collectors.toSet());
                }
                // 上下级权限
                //查出来userId的所有下级userId
                final List<PrdOrgEmployeeRefVO> empRef = daoUser.queryLowListByKey(null, loginUserId);
                final Set<Long> empRefUserIdList = empRef.stream().map(prdOrgEmployeeRefVO -> prdOrgEmployeeRefVO.getUserId()).collect(Collectors.toSet());
                // 有没有平台级权限
                if (CollectionUtils.isEmpty(userIdsByPlatRole) || !userIdsByPlatRole.contains(loginUserId)) {
                    Set<Long> queryUserIds = new HashSet<>();
                    //最基础的权限要查看自己
                    queryUserIds.add(loginUserId);
                    //有没有部门级别权限
                    if (orgIdList != null && !orgIdList.isEmpty()) {
                        // 部门成员
                        //查询部门下的成员
                        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = prdOrgOrganizationDAO.queryEmployeeList(orgIdList);
                        Set<Long> collect = prdOrgEmployeeRefVOS.stream().map(e -> e.getUserId()).collect(Collectors.toSet());
                        queryUserIds.addAll(collect);
                    }
                    if (empRefUserIdList != null && !empRefUserIdList.isEmpty()) {
                        // 查询下级
                        queryUserIds.addAll(empRefUserIdList);
                    }
                    query.setTsUserIdList(queryUserIds);
                }
            }
        }
    }


    /**
     * 工时审批分页查询
     *
     * @param query 查询
     * @return {@link PagingVO}<{@link TimesheetVO}>
     */
    @Override
    public PagingVO<TimesheetVO> pagingSingle(TimesheetQuery query) {
        if (!ObjectUtils.isEmpty(query.getTsUserIdName())) {
            PrdOrgEmployeeQuery employeeQuery = new PrdOrgEmployeeQuery();
            employeeQuery.setPersonName(query.getTsUserIdName());
            PagingVO<PrdOrgEmployeeVO> paging = prdOrgEmployeeService.paging(employeeQuery);
            if (!ObjectUtils.isEmpty(paging.getRecords())) {
                Set<Long> userIdList = paging.getRecords().stream().map(PrdOrgEmployeeVO::getUserId).collect(Collectors.toSet());
                query.setTsUserIdList(userIdList);
            }
        }
        Page<TimesheetDO> page = timesheetRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(TimesheetConvert.INSTANCE::toVo));
    }


    @Override
    public PagingVO pagingGroup(TimesheetQuery query) {
        query.setOrders(null);
        if (!ObjectUtils.isEmpty(query.getTsUserIdName())) {
            PrdOrgEmployeeQuery employeeQuery = new PrdOrgEmployeeQuery();
            employeeQuery.setPersonName(query.getTsUserIdName());
            PagingVO<PrdOrgEmployeeVO> paging = prdOrgEmployeeService.paging(employeeQuery);
            if (!ObjectUtils.isEmpty(paging.getRecords())) {
                Set<Long> userIdList = paging.getRecords().stream().map(PrdOrgEmployeeVO::getUserId).collect(Collectors.toSet());
                query.setTsUserIdList(userIdList);
            }
        } else {
            query.setTsUserIdList(new HashSet<>());
        }
        final Page<Object[]> page = timesheetRepo.pagingGroup(query.getTsUserId(), query.getApprUserId(), query.getTsStatus(), query.getTsUserBuId(), query.getTimesheetIdV4IsNull(), query.getPageRequest(), query.getBlurryQuery(), query.getTsUserIdList());
        final List<Object[]> content = page.getContent();
        final List<TimesheetVO> all = getAll(content);
        // 理论支出当量
        // setTheoryGetEqva(all);
        return PagingVO.<TimesheetVO>builder().records(all).total(page.getTotalElements()).build();
    }


    /**
     * 理论支出当量
     *
     * @param list 列表
     */
    @Deprecated
    public void setTheoryGetEqva(List<TimesheetVO> list) {
        if (list != null && list.size() > 0) {
            for (TimesheetVO timeView : list) {
                String[] groupIdsArr = timeView.getGroupIds().split(",");
                BigDecimal bd = new BigDecimal("0");
                for (int i = 0; i < groupIdsArr.length; i++) {
                    final TimesheetVO data = queryByKey(Long.valueOf(groupIdsArr[i]));
                    if (data.getTaskId() != null && data.getTaskId() > 0) {
                        final TaskVO task = taskService.queryByTaskIdV4(data.getTaskId());
                        if (task != null && "04".equals(task.getAcceptMethod())) {
                            bd = bd.add(data.getWorkHour().divide(new BigDecimal("8"), 1, RoundingMode.UP).multiply(task.getEqvaRatio()));
                        }
                    }
                }
                timeView.setTheoryGetEqva(bd);
            }
        }
    }

    public List<TimesheetVO> getAll(List<Object[]> objects) {
        List<TimesheetVO> list = new ArrayList<>();
        for (Object[] obj : objects) {
            TimesheetVO timesheetVO = new TimesheetVO();
            timesheetVO.setGroupIds(String.valueOf(obj[0]));
            timesheetVO.setWorkHour(BigDecimal.valueOf(Double.parseDouble(String.valueOf(obj[1]))));
            timesheetVO.setProjId(obj[2] != null ? Long.valueOf(String.valueOf(obj[2])) : null);
            timesheetVO.setProjNo(String.valueOf(obj[3]));
            timesheetVO.setProjName(String.valueOf(obj[4]));
            timesheetVO.setTsStatus(String.valueOf(obj[5]));
            timesheetVO.setApprUserId(obj[6] != null ? Long.valueOf(String.valueOf(obj[6])) : null);
            timesheetVO.setWeekStartDate(obj[7] != null ? LocalDate.parse(String.valueOf(obj[7])) : null);
            timesheetVO.setTaskId(obj[8] != null ? Long.valueOf(String.valueOf(obj[8])) : null);
            timesheetVO.setTaskNo(String.valueOf(obj[9]));
            timesheetVO.setTaskName(String.valueOf(obj[10]));
            timesheetVO.setTsUserId(obj[11] != null ? Long.valueOf(String.valueOf(obj[11])) : null);
            timesheetVO.setTsUserBuId(obj[12] != null ? Long.valueOf(String.valueOf(obj[12])) : null);
            timesheetVO.setTsUserBuName(obj[13] != null ? String.valueOf(obj[13]) : "");
            list.add(timesheetVO);
        }
        return list;
    }

    @Override
    public List<TimesheetVO> listGroup(TimesheetQuery query) {
        QTimesheetDO qTimesheetDO = QTimesheetDO.timesheetDO;
        final JPAQuery<TimesheetDO> jpaQuery = jpaQueryFactory.select(qTimesheetDO)
                .from(qTimesheetDO)
                .where(qTimesheetDO.deleteFlag.eq(0));
        if (null != query.getTsUserId()) {
            jpaQuery.where(qTimesheetDO.tsUserId.eq(query.getTsUserId()));
        }
        if (null != query.getApprUserId()) {
            jpaQuery.where(qTimesheetDO.apprUserId.eq(query.getApprUserId()));
        }
        if (StringUtils.hasText(query.getTsStatus())) {
            jpaQuery.where(qTimesheetDO.tsStatus.eq(query.getTsStatus()));
        }
        final QueryResults<TimesheetDO> queryResults = jpaQuery.groupBy(qTimesheetDO.projId, qTimesheetDO.yearWeek, qTimesheetDO.tsUserId)
                .orderBy(qTimesheetDO.yearWeek.desc(), qTimesheetDO.tsUserId.desc())
                .fetchResults();
        final List<TimesheetVO> timesheetVOList = TimesheetConvert.INSTANCE.toVoList(queryResults.getResults());
        return timesheetVOList;
    }

    /**
     * 工时查询列表
     *
     * @param query 查询
     * @return {@link List}<{@link TimesheetVO}>
     */
    @Override
    public List<TimesheetVO> queryList(TimesheetQuery query) {
        return TimesheetConvert.INSTANCE.toVoList(timesheetRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Override
    public Map<LocalDate, Object> getTimesheetOverview(TimesheetQuery query) {
        Map<LocalDate, Object> result = new HashMap<>();
        final Long loginUserId = GlobalUtil.getLoginUserId();
//        final Long loginUserId = 579785889740361181L;
        if (loginUserId == null) {
            throw TwException.error("", "用户查询失败！");
        }
        query.setTsUserId(loginUserId);
        List<TimesheetVO> timesheetVOS = queryList(query);
        //按日期进行分组
        Map<LocalDate, List<TimesheetVO>> groupTimesheetMap = timesheetVOS.stream().collect(Collectors.groupingBy(TimesheetVO::getWorkDate));
        List<LocalDate> workDate = query.getWorkDate();
        LocalDate startDate = workDate.get(0);
        LocalDate endDate = workDate.get(1);
        for (LocalDate localDate = startDate; localDate.isBefore(endDate.plusDays(1)); localDate = localDate.plusDays(1)) {
            List<TimesheetVO> timesheetVOS1 = groupTimesheetMap.get(localDate);
            if (timesheetVOS1 == null || timesheetVOS1.isEmpty()) {
                result.put(localDate, "");
            } else {
                String status = "";
                int rejectedNum = 0;
                int createNum = 0;
                int approvingNum = 0;
                int approvedNum = 0;
                int settledNum = 0;
                for (TimesheetVO timesheetVO : timesheetVOS1) {
                    String tsStatus = timesheetVO.getTsStatus();
                    switch (TimesheetStatus.valueOf(tsStatus)) {
                        case CREATE:
                            createNum++;
                            break;
                        case REJECTED:
                            rejectedNum++;
                            break;
                        case APPROVING:
                            approvingNum++;
                            break;
                        case APPROVED:
                            approvedNum++;
                            break;
                        case SETTLED:
                            settledNum++;
                    }
                }
                if (rejectedNum > 0) {
                    status = REJECTED.getCode();
                } else if (createNum > 0) {
                    status = CREATE.getCode();
                } else if (approvingNum > 0) {
                    status = APPROVING.getCode();
                } else if (approvedNum > 0) {
                    status = APPROVED.getCode();
                } else if (settledNum > 0) {
                    status = SETTLED.getCode();
                }
                BigDecimal reduce = BigDecimal.ZERO;
                if (!CollectionUtils.isEmpty(timesheetVOS1)) {
                    // 总工时
                    reduce = timesheetVOS1.stream().map(e -> e.getWorkHour()).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                Map<String, Object> result1 = new HashMap<>();
                result1.put("status", status);
                result1.put("hour", reduce);
                result.put(localDate, result1);
            }
        }
        return result;
    }

    @Override
    public Boolean checkMonthlyTimesheet(String checkDate) {
        LocalDate date = LocalDate.parse(checkDate);
        //本月的第一天
        LocalDate firstDay = LocalDate.of(date.getYear(), date.getMonth(), 1);
        //本月的最后一天
        LocalDate lastDay = date.with(TemporalAdjusters.lastDayOfMonth());
        //获取当前登陆人
        Long loginUserId = GlobalUtil.getLoginUserId();
        // Long loginUserId = 579786372043377650L;
        //获取入职日期
        PrdOrgEmployeeDO prdOrgEmployeeDO = employeeDAO.queryByUserId(loginUserId);
        if (prdOrgEmployeeDO == null || prdOrgEmployeeDO.getEnrollDate() == null) {
            return true;
        }
        LocalDate enrollDate = prdOrgEmployeeDO.getEnrollDate();

        if (enrollDate.isAfter(firstDay)) {
            firstDay = enrollDate;
        }
        //获取填写工时的工作日
        List<LocalDate> workDates = vacationRepo.selectWorkDaysByDays(firstDay, lastDay);
        //校验工作日的工时
        TimesheetQuery query = new TimesheetQuery();
        query.setWorkDateIn(workDates);
        query.setTsUserId(loginUserId);
        List<TimesheetVO> timesheetVOS = queryList(query);
        //按日期进行分组
        Map<LocalDate, List<TimesheetVO>> groupTimesheetMap = timesheetVOS.stream().collect(Collectors.groupingBy(TimesheetVO::getWorkDate));
        boolean checkFlag = true;
        for (LocalDate localDate:workDates) {
            List<TimesheetVO> timesheetVOS1 = groupTimesheetMap.get(localDate);
            BigDecimal reduce = BigDecimal.ZERO;
            if (!CollectionUtils.isEmpty(timesheetVOS1)) {
                // 总工时
                reduce = timesheetVOS1.stream().map(e -> e.getWorkHour()).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if (reduce.compareTo(BigDecimal.valueOf(8L)) == -1) {
                checkFlag = false;
                break;
            }
        }
        return checkFlag;
    }


    @Override
    public void updateApprovingUser(List<Long> keys, Long apprUserId) {
        if (null == apprUserId || CollectionUtils.isEmpty(keys)) {
            log.warn("请求参数为空，工时列表变更审批人错误");
            return;
        }
        // 审批记录查询
        TsApprovalResQuery tsApprovalResQuery = new TsApprovalResQuery();
        tsApprovalResQuery.setTimesheetIds(keys);
        tsApprovalResQuery.setApprovalStatus(APPROVING.getCode());
        List<TsApprovalResVO> tsApprovalResVOS = tsApprovalResService.queryListDynamic(tsApprovalResQuery);
        for (TsApprovalResVO tsApprovalResVO : tsApprovalResVOS) {
            TsApprovalResPayload approvalResPayload = new TsApprovalResPayload();
            approvalResPayload.setId(tsApprovalResVO.getId());
            approvalResPayload.setApprovalResId(apprUserId);
            tsApprovalResService.updateByKeyDynamic(approvalResPayload);
        }
        timesheetRepo.updateApprovingUser(keys, apprUserId);
    }

    /**
     * 生成法定假日工时
     *
     * @param param
     */
    @Override
    public void generateVacationPublicTimesheet(String param) {
        //TODO duwh补 5.0项目、任务上线后删除
    }

    /**
     * 生成请假工时
     *
     * @param applyId
     */
    @Override
    public void generateVacationPrivateTimesheet(Long applyId) {
        //TODO duwh补 5.0项目、任务上线后删除

        UserVacationApplyVO applyVO = vacationApplyService.queryApplyByKey(String.valueOf(applyId));
        List<UserVacationApplyDetailVO> applyDetailVOList = vacationApplyService.getDetailByApplyKey(applyId);

        if (applyVO != null && applyDetailVOList != null && !applyDetailVOList.isEmpty()) {
            //插入数据到T_TIMESHEET表
            if (!"OTHER".equals(applyVO.getVacationType())) {
                // 请假申请期间有没有填写工时
                TimesheetQuery query = new TimesheetQuery();
                List<LocalDate> workDateBetween = Arrays.asList(applyVO.getStartDate(), applyVO.getEndDate());
                query.setTsUserId(applyVO.getUserId());
                query.setWorkDateBetween(workDateBetween);
                List<TimesheetVO> timesheetVOList = queryList(query);
                //获取请假的日期时间
                List<LocalDate> timeDate = new ArrayList<>();
                for (TimesheetVO time : timesheetVOList) {
                    // 判断工时 workHour 为空或者 未超过4小时
                    //final boolean flag = null != time.getWorkHour() && time.getWorkHour().compareTo(new BigDecimal("4")) < 1;
                    //if (null == time.getWorkHour() || flag) {
                    //
                    //} else {
                    timeDate.add(time.getWorkDate());
                    //}
                }
                for (UserVacationApplyDetailVO detail : applyDetailVOList) {
                    if (timesheetVOList != null && timesheetVOList.size() > 0) {
                        BigDecimal workHour = new BigDecimal(8).multiply(detail.getVDays()).setScale(2, RoundingMode.HALF_UP);

                        if (timeDate.contains(detail.getVDate())) {
                            // 已填写的工时数据
                            final List<TimesheetVO> list = timesheetVOList.stream()
                                    .filter(twTimesheetListView -> twTimesheetListView.getWorkDate().equals(detail.getVDate())).collect(Collectors.toList());
                            hadleTimesheetInsert(applyVO, detail.getVDate(), workHour, list, detail.getVInterval());
                            //continue;
                        } else {
                            hadleTimesheetInsert(applyVO, detail.getVDate(), workHour, null, detail.getVInterval());
                        }
                    } else {
                        BigDecimal workHour = new BigDecimal(8).multiply(detail.getVDays()).setScale(2, RoundingMode.HALF_UP);
                        hadleTimesheetInsert(applyVO, detail.getVDate(), workHour, null, detail.getVInterval());
                    }
                }
            }
        }
    }

    /**
     * 请假自动插入工时
     *
     * @param view     假期对象
     * @param workDate 工时日期
     * @param workHour 工时小时数
     * @param list     已填写工时集合
     */
    @Transactional(rollbackFor = Exception.class)
    void hadleTimesheetInsert(UserVacationApplyVO view, LocalDate workDate, BigDecimal workHour, List<TimesheetVO> list, String vInterval) {
        TimesheetPayload timesheetEntity = new TimesheetPayload();
        timesheetEntity.setTsUserId(view.getUserId());
        //timesheetEntity.setTsStatus("APPROVED");
        timesheetEntity.setTsStatus(APPROVED.getCode());
        timesheetEntity.setWorkDate(workDate);
        timesheetEntity.setApprUserId(1381L);
        timesheetEntity.setApprovalTime(LocalDateTime.now());
        //BigDecimal workHour1 = new BigDecimal(8);
        //  获取当前用户的组织信息
        final List<PrdOrgDataRefVO> prdOrgDataRefVOS = daoUser.queryOrgListByKey(view.getUserId());
        if (!CollectionUtils.isEmpty(prdOrgDataRefVOS)) {
            final List<PrdOrgDataRefVO> refList = prdOrgDataRefVOS.stream()
                    .filter(prdOrgDataRefVO -> prdOrgDataRefVO.getIsDefault().equals(0))
                    .collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(refList)) {
                final Long orgId = refList.get(0).getOrgId();
                final String orgName = refList.get(0).getOrgName();
                timesheetEntity.setTsUserBuId(orgId);
                timesheetEntity.setTsUserBuName(orgName);
            }
        }
        timesheetEntity.setWorkHour(workHour);
        timesheetEntity.setWorkDesc("请假流程自动填写");
        int weekBaseYear = timesheetEntity.getWorkDate().get(WeekFields.ISO.weekBasedYear());//2018-12-31 返回2019
        int weeks = timesheetEntity.getWorkDate().get(WeekFields.ISO.weekOfWeekBasedYear());
        String week = weeks < 10 ? "0" + weeks : weeks + "";
        String yearWeek = weekBaseYear + week;
        timesheetEntity.setWeekStartDate(timesheetEntity.getWorkDate().with(DayOfWeek.MONDAY));
        timesheetEntity.setYearWeek(Integer.parseInt(yearWeek));
        timesheetEntity.setAutoSaveFlag(1);
        //timesheetEntity.setRemark("请假自动生成工时");
        timesheetEntity.setProjId(0L);//设置项目为无项目1
        timesheetEntity.setProjName("无项目");
//        timesheetEntity.setApprUserId(0L);//设置审批人
        timesheetEntity.setApprResult("审批通过");
        // 事假
        if (view.getVacationType().equals("PERSONAL")) {
            // 事假
            timesheetEntity.setTsActIden(view.getVacationType());
        }
        // 公假	OFFICIAL   婚假	MARRIAGE    丧假	FUNERAL    法定年休	ANNUAL
        if (view.getVacationType().equals("OFFICIAL") || view.getVacationType().equals("MARRIAGE") || view.getVacationType().equals("FUNERAL")
                || view.getVacationType().equals("ANNUAL")) {
            // 婚假/丧假/公假/年休假/工伤假
            timesheetEntity.setTsActIden(view.getVacationType());
        }
        // 产前检查假	PRENATAL_EXA     哺乳假	BREASTFEED    产假	MATERNITY
        if (view.getVacationType().equals("PRENATAL_EXA") || view.getVacationType().equals("BREASTFEED") || view.getVacationType().equals("MATERNITY")
                || view.getVacationType().equals("PATERNITY")) {
            // 产假	MATERNITYLEAVE
            timesheetEntity.setTsActIden("MATERNITYLEAVE");
        }
        // 病假	SICK
        if (view.getVacationType().equals("SICK")) {
            // 病假	SICKLEAVE
            timesheetEntity.setTsActIden("SICKLEAVE");
        }
        if (view.getVacationType().equals("IN_LIEU")) {
            // 调休	SHIFTING
            timesheetEntity.setTsActIden("SHIFTING");
        }
        timesheetEntity.setTsTaskIden("VACATION");
        timesheetEntity.setSettleStatus("NONE");
        timesheetEntity.setProcId(view.getProcInstId());
//        timesheetEntity.setVInterval(vInterval);
        timesheetRepo.save(TimesheetConvert.INSTANCE.toDo(timesheetEntity));

        // 针对存在已填写记录的工时处理
        // 先备份已填写的数据 到一个临时表  5  2  1
        // 修改已填写的数据 工时数据  已填写工时8-请假工时4= 修改后的工时4（4怎么分配）
        if (!CollectionUtils.isEmpty(list)) {
            AtomicReference<BigDecimal> tempWorkHour = new AtomicReference<>(workHour);
            List<TimesheetPayload> updateList = new ArrayList<>();
            list.forEach(twTimesheetListView -> {
                TimesheetPayload entityTemp = new TimesheetPayload();
                TimesheetPayload updateEntity = new TimesheetPayload();
                BeanUtils.copyProperties(twTimesheetListView, entityTemp);
                BeanUtils.copyProperties(twTimesheetListView, updateEntity);
                // 请假工时 减完以后 就跳过
                if (tempWorkHour.get().compareTo(BigDecimal.ZERO) > 0) {
                    // 左(已填工时数)>=右（请教工时数）
                    if (updateEntity.getWorkHour().compareTo(tempWorkHour.get()) > -1) {
                        // 5-4 = 1
                        final BigDecimal subtract = updateEntity.getWorkHour().subtract(tempWorkHour.get());
                        // 结果大于等于0的话
                        updateEntity.setWorkHour(subtract);
                    } else {
                        updateEntity.setWorkHour(BigDecimal.ZERO);
                    }
                }
                updateEntity.setAutoSaveFlag(1);
                updateEntity.setProcId(view.getProcInstId());
                updateEntity.setAutoUpdateFlag(1);
                updateList.add(updateEntity);
            });
            //修改已填写的数据 工时数据  已填写工时8-请假工时4= 修改后的工时4（2怎么分配）
            if (!CollectionUtils.isEmpty(updateList)) {
                updateList.forEach(twTimesheetEntity -> {
                    update(twTimesheetEntity);
                });
            }
        }
    }

    @Override
    public List<TimesheetSyncDataVO> querySyncDataList(TimesheetQuery query) {
        return TimesheetConvert.INSTANCE.doListToSyncVo(timesheetRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Override
    public long count(TimesheetQuery query) {
        return timesheetRepo.count((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder));
    }

    @Override
    public TimesheetVO queryByKey(Long key) {
        TimesheetDO entity = timesheetRepo.findById(key).orElseGet(TimesheetDO::new);
        Assert.notNull(entity.getId(), "工时不存在");
        TimesheetVO vo = TimesheetConvert.INSTANCE.toVo(entity);
        return vo;
    }

    /**
     * 插入
     * <p>
     * 待补4.0逻辑 ：// 新建工时时,将对应的活动修改为进行中的状态(未开始和延迟状态的才修改)
     *
     * @param payload 有效载荷
     * @return {@link TimesheetVO}
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public TimesheetVO insert(TimesheetPayload payload) {
        if (payload.getProjId() != null && payload.getProjId() != 0) {
            payload.setTsTaskIden(null);
            payload.setTsActIden(null);
        }
        // 参数校验
        // 提交验证
        check(payload);
        //  根据日期查询已审批、审批中、已结算状态的工作小时，验证是否大于8
        // 校验任务包当量
        initData(payload);
        TimesheetDO entityDo = TimesheetConvert.INSTANCE.toDo(payload);
        // 将4.0工时标志设置为空，防止5.0修改假期工时后提交，导致不会同步到4.0
//        entityDo.setTimesheetIdV4(null);
        // 更新周报读取状态
        LocalDate workDate = payload.getWorkDate();
        int yearWeek = Integer.parseInt(DateUtil.getYearWeek(workDate));
        biweeklyReadFlagRepo.updateReadFlag(payload.getTsUserId(), 0);
        return TimesheetConvert.INSTANCE.toVo(timesheetRepo.save(entityDo));
    }

    /**
     * 检查
     *
     * @param payload 有效载荷
     */
    private void check(TimesheetPayload payload) {
        if (payload.isSubmitted()) {
            if (payload.getId() != null && payload.getId() > 0) {
                final TimesheetVO timesheetVO = queryByKey(payload.getId());
                // 提交单据状态校验 只能提交新建或已退回的单据
                if (!TimesheetStatus.CREATE.getCode().equals(timesheetVO.getTsStatus()) &&
                        !TimesheetStatus.REJECTED.getCode().equals(timesheetVO.getTsStatus())) {
                    throw TwException.error("", "只能提交新建或已退回的单据");
                }
            } else {
                payload.setSubmitTime(LocalDateTime.now());
            }
            // 项目id、 必填   --任务id、活动id
            // 工作日期、工时、工作说明
            // 字段必填验证
            if (null == payload.getProjId()) {
                throw TwException.error("", "请选择项目");
            }
            if (null == payload.getWorkDate()) {
                throw TwException.error("", "请选择工作日期");
            }
            if (!StringUtils.hasText(payload.getWorkDesc())) {
                throw TwException.error("", "请输入工作日志");
            }
            if (null == payload.getWorkHour()) {
                throw TwException.error("", "请填写工时");
            }
            if (null != payload.getTaskId()) {
                final TaskVO taskVO = taskService.queryByTaskIdV4(payload.getTaskId());
                if (null == taskVO) {
                    throw TwException.error("", "任务包不存在");
                }
                if (!taskVO.getTaskStatus().equals("IN PROCESS") && !taskVO.getTaskIdV4().equals(0L)) {
                    throw TwException.error("", "请选择【激活】状态的任务包");
                }
            }

        }
    }

    /**
     * 批量插入
     *
     * @param payload 有效载荷
     * @return {@link List}<{@link TimesheetVO}>
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @Deprecated
    public List<TimesheetVO> batchInsert(TimesheetListPayload payload) {
        return null;
    }

    /**
     * 计算多个任务包的已填工时当量
     *
     * @param taskIdList 任务v4主键集合
     * @return 任务包id，已填工时当量 map
     */
    private Map<Long, BigDecimal> calTsUsedEqvasByIds(List<Long> taskIdList) {
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        timesheetQuery.setTaskIdList(taskIdList);
        List<String> tsStatusList = new ArrayList<>();
        tsStatusList.add(APPROVED.getCode());
        tsStatusList.add(APPROVING.getCode());
        timesheetQuery.setTsStatusList(tsStatusList);
        // 查询工时列表信息 人、日期、工时、baseBu
        // 根据任务包查询工时
        List<TimesheetVO> tsViews = queryList(timesheetQuery);

        if (tsViews == null || tsViews.size() == 0) {// 任务包没有关联任何工时
            return null;
        }

        //计算每条工时占用的当量
        Map<Long, BigDecimal> tsEqvaMap = calTsUsedEqvasByTsIds(tsViews.stream()
                .map(ts -> ts.getId()).collect(Collectors.toList()));
        tsViews = tsViews.stream().map(ts -> {
            ts.setEqvaTimeSheet(tsEqvaMap.get(ts.getId()));
            return ts;
        }).collect(Collectors.toList());

        //按任务包对工时进行分组，并求当量和
        Map<Long, BigDecimal> returnMap = new HashMap<>();
        Map<Long, List<TimesheetVO>> taskTsMap = tsViews.stream().collect(Collectors.groupingBy(TimesheetVO::getTaskId));
        Set<Long> taskIdSet = taskTsMap.keySet();
        for (Long taskId : taskIdSet) {
            returnMap.put(taskId, taskTsMap.get(taskId).stream().
                    map(ts -> ts.getEqvaTimeSheet() == null ? BigDecimal.ZERO : ts.getEqvaTimeSheet())
                    .reduce(BigDecimal::add).get());
        }
        return returnMap;
    }

    /**
     * 计算工时占用任务包的当量
     *
     * @param timeSheetIds 工时id
     * @return 工时id 工时占用当量
     */
    private Map<Long, BigDecimal> calTsUsedEqvasByTsIds(List<Long> timeSheetIds) {
        log.warn("debug:::目标操作的工时列表" + timeSheetIds);
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        timesheetQuery.setIdList(timeSheetIds);
        // 查询工时列表信息 人、日期、工时、baseBu
        //根据id查询工时List
        final List<TimesheetVO> tsViews = queryList(timesheetQuery);
        List<Long> tsUserIdList = tsViews.stream().map(v -> v.getTsUserId()).collect(Collectors.toList());
        // 5.0临时方案 只要一个最新的当量
        final List<PrdOrgEmployeeDO> prdOrgEmployeeDOS = employeeDAO.queryListByUserIdList(tsUserIdList);
//        final Map<Long, BigDecimal> eqvaRatioMap = prdOrgEmployeeDOS.stream()
//            .collect(Collectors.toMap(PrdOrgEmployeeDO::getUserId, PrdOrgEmployeeDO::getEqvaRatio));
        for (TimesheetVO v : tsViews) {
            // 查询任务包的信息
            final TaskVO taskVO = taskService.queryByTaskIdV4(v.getTaskId());
            if ("04".equals(taskVO.getAcceptMethod()) && taskVO.getEqvaRatio() != null) {// 人天任务包使用任务包的派发当量系数，跳过计算当量系数，节约系统资源
                continue;
            }
            // 计算工时的当量系数
            // 非人天任务包，不能用任务包的派发当量系数当做计算当量的系数
            v.setEqvaRatio(null);
            final BigDecimal eqvaRatio = employeeEqvaRatioService.getEqvaRatio(v.getTsUserId(), v.getWorkDate());
            v.setEqvaRatio(eqvaRatio);
        }
        // 计算工时占用的当量
        // 工时当量系数计算完成后，直接调用v.getEqvaTimeSheet()方法即可
//        return tsViews.stream().collect(Collectors.toMap(TimesheetVO::getId, TimesheetVO::getEqvaTimeSheet));
        // 解决value为空问题
        return tsViews.stream().collect(HashMap::new, (map, item) -> map.put(item.getId(), item.getEqvaTimeSheet()), HashMap::putAll);

        // 原有4.0逻辑
        //TwEqvaRationQuery query = TwEqvaRationQuery.builder().resIds(tsUserIdList).build();// 先查出任务包关联的所有人的当量系数
        //List<TwEqvaRatioView> ratioList = eqvaRatioMapper.getRatioList(query);//当量系数：查询指定资源当量系数维护记录
        // 计算每条工时的当量系数、占用当量
//        for (TwTimesheetListView v : tsViews) {
//            if ("04".equals(v.getAcceptMethod()) && v.getEqvaRatio() != null) {// 人天任务包使用任务包的派发当量系数，跳过计算当量系数，节约系统资源
//                continue;
//            }
//            //计算工时的当量系数
//            v.setEqvaRatio(null);// 非人天任务包，不能用任务包的派发当量系数当做计算当量的系数
//            if (!CollectionUtils.isEmpty(ratioList)) {
//                TwEqvaRatioView view = ratioList.stream().filter(r ->
//                        (r.getResId() != null && v.getTsResId() != null && r.getResId().longValue() == v.getTsResId().longValue())
////                            有的资源的任务包跨度很大，有可能任务包存在两个当量系数
////                        && (r.getBuId() != null && v.getBaseBuId() != null && r.getBuId().longValue() == v.getBaseBuId().longValue())
//                            && (r.getStartDate() == null || !r.getStartDate().isAfter(v.getWorkDate()))
//                            && (r.getEndDate() == null || !r.getEndDate().isBefore(v.getWorkDate()))
//                ).sorted(new Comparator<TwEqvaRatioView>() {
//                    @Override
//                    public int compare(TwEqvaRatioView o1, TwEqvaRatioView o2) {
//                        return o2.getStartDate() != null && o1.getStartDate() != null ? (int) (o2.getStartDate().toEpochDay() - o1.getStartDate().toEpochDay()) : 0;
//                    }
//                }).findFirst().orElse(null);// 仅查basebu的话，会导致发生bu变更的时候，变更前的人找不到当量系数，导致工时不占用任务包当量；应该用最新的当量系数兜底
//                if (view == null || view.getEqvaRatio() == null) {
//                    // 查员工最新的当量系数
//                    TwEqvaRationQuery queryTmp = TwEqvaRationQuery.builder().resId(ratioList.get(0).getResId()).build();
//                    List<TwEqvaRatioView> ratioListTmp = eqvaRatioMapper.getRatioList(queryTmp);
//                    if (ratioListTmp != null && ratioListTmp.size() > 0 && ratioListTmp.get(0) != null) {
//                        v.setEqvaRatio(ratioListTmp.get(0).getEqvaRatio());
//                    }
//                } else {
//                    v.setEqvaRatio(view.getEqvaRatio());//设置当量系数
//                }
//            }
//            //计算工时占用的当量
//            // 工时当量系数计算完成后，直接调用v.getEqva()方法即可
//        }
//        return tsViews.stream().collect(Collectors.toMap(TwTimesheetListView::getId, TwTimesheetListView::getEqva));
    }

    /**
     * 校验工作时间
     *
     * @param payload 有效载荷
     * @return boolean
     */
    private boolean workHourValidate(TimesheetListPayload payload) {
        //  过滤已审批、审批中状态的数据 用于校验工作小时
        Map<LocalDate, Double> resultMap =
                payload.getTimesheetList().stream()
                        .filter(timesheetPayload -> timesheetPayload.getTsStatus() != null &&
                                (timesheetPayload.getTsStatus().equals(CREATE.getCode()) || timesheetPayload.getTsStatus().equals(REJECTED.getCode()))
                        ).collect(
                        Collectors.groupingBy(TimesheetPayload::getWorkDate,
                                Collectors.summingDouble(TimesheetPayload::getDoubleWorkHour)
                        )
                );
        List<Boolean> isValid = new ArrayList<>();

        resultMap.forEach((date, workHour) -> {
            // 根据日期查询已审批、审批中、已结算状态的工作小时，验证是否大于8
            TimesheetQuery query = new TimesheetQuery();
            query.setTsStatusList(Arrays.asList(APPROVED.getCode(), APPROVING.getCode(), SETTLED.getCode()));
            query.setTsUserId(GlobalUtil.getLoginUserId());
            query.setWorkDateQuery(date);
            final List<TimesheetVO> timesheetVOList = queryList(query);
            // 已提交的工作小时
            Double wh = timesheetVOList.stream().collect(Collectors.summingDouble(t -> t.getWorkHour().doubleValue()));
            if (workHour + wh > 8d) {
                isValid.add(false);
            }
        });
        return !isValid.contains(false);
    }

    /**
     * 初始化数据
     *
     * @param payload 有效载荷
     */
    private void initData(TimesheetPayload payload) {
        // 新增情况
        //if (null == payload.getId()) {
        payload.setWorkDayOffStatus("UNGEN");
        payload.setWorkFlag("NO");
        payload.setSettleStatus("NONE");
        payload.setAutoSaveFlag(0);
        if (payload.getTsUserId() == null) {
            // 设置填写人为当前登录人
            payload.setTsUserId(GlobalUtil.getLoginUserId());
        }
        // TODO 获取当前用户的组织信息
//        final List<PrdOrgDataRefVO> prdOrgDataRefVOS = prdUserService.queryOrgList();
        final List<PrdOrgDataRefVO> prdOrgDataRefVOS = daoUser.queryOrgListByKey(payload.getTsUserId());
        if (!CollectionUtils.isEmpty(prdOrgDataRefVOS)) {
            final List<PrdOrgDataRefVO> list = prdOrgDataRefVOS.stream()
                    .filter(prdOrgDataRefVO -> prdOrgDataRefVO.getIsDefault().equals(0))
                    .collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(list)) {
                final Long orgId = list.get(0).getOrgId();
                final String orgName = list.get(0).getOrgName();
                payload.setTsUserBuId(orgId);
                payload.setTsUserBuName(orgName);
            }
        }
        //}
        if (null != payload.getProjId()) {
            final ProjectVO projectVO = projectService.queryByProjIdV4(payload.getProjId());
            if (!StringUtils.hasText(payload.getProjNo())) {
                payload.setProjNo(null != projectVO ? projectVO.getProjNo() : "");
            }
            if (!StringUtils.hasText(payload.getProjName())) {
                payload.setProjName(null != projectVO ? projectVO.getProjName() : "");
            }
        }
        // 任务 冗余翻译
        if (null != payload.getTaskId()) {
            final TaskVO taskVO = taskService.queryByTaskIdV4(payload.getTaskId());
            if (!StringUtils.hasText(payload.getTaskNo())) {
                payload.setTaskNo(null != taskVO ? taskVO.getTaskNo() : "");
            }
            if (!StringUtils.hasText(payload.getTaskName())) {
                payload.setTaskName(null != taskVO ? taskVO.getTaskName() : "");
            }
            if (null == payload.getEqva()) {
                payload.setEqva(null != taskVO ? taskVO.getEqvaQty() : null);
            }
        }
        // 活动 冗余翻译
//        if (null != payload.getActId()) {
//            final ResActivityVO resActivityVO = resActivityService.queryByActivityIdV4(payload.getActId());
//            if (!StringUtils.hasText(payload.getActNo())) {
//                payload.setActNo(null != resActivityVO ? resActivityVO.getActNo() : "");
//            }
//            if (!StringUtils.hasText(payload.getActName())) {
//                payload.setActName(null != resActivityVO ? resActivityVO.getActName() : "");
//            }
//        }
        // 经营计划冗余翻译
        if (null != payload.getOperPlanId()) {
            final CrmOperationPlanDetailVO planDetailVO = crmOperationPlanDetailService.queryByKey(payload.getOperPlanId());
            if (!StringUtils.hasText(payload.getOperPlanName())) {
                payload.setOperPlanName(null != planDetailVO ? planDetailVO.getPlanName() : "");
            }
        }
        payload.setApprResult(null);
        if (payload.isSubmitted()) {
            // 设置为审批中状态
            payload.setTsStatus(APPROVING.getCode());
            // ！！！！审批资源Id
            payload.setApprUserId(findApprUserId(payload));
            // 提交时间
            if (payload.getId() != null && payload.getId() > 0) {
                TimesheetDO entity = timesheetRepo.findById(payload.getId()).orElseGet(TimesheetDO::new);
                Assert.notNull(entity.getId(), "工时不存在");
                payload.setSubmitTime(entity.getSubmitTime());
            } else {
                payload.setSubmitTime(LocalDateTime.now());
            }

        } else {
            if (payload.getId() != null && payload.getId() > 0) {
                // 非新建时，设置为原单据状态
                TimesheetDO entity = timesheetRepo.findById(payload.getId()).orElseGet(TimesheetDO::new);
                Assert.notNull(entity.getId(), "工时不存在");
                payload.setSubmitTime(entity.getSubmitTime());
                payload.setTsStatus(entity.getTsStatus());
            } else {
                // 设置为创建状态
                payload.setTsStatus(TimesheetStatus.CREATE.getCode());
            }
        }
        if (payload.getWorkDate() != null) {
            // 设置当前年周
            payload.setYearWeek(Integer.parseInt(DateUtil.getYearWeek(payload.getWorkDate())));
            // entity.setWeekStartDate(entity.getWorkDate().with(TemporalAdjusters.previousOrSame( DayOfWeek.MONDAY)));
            payload.setWeekStartDate(DateUtil.getStartWeekDay(payload.getWorkDate()));
        }
    }

    /**
     * 工时的审批资源ID取值 (无详设) 业务描述者:曹继旺、张勇强、薛老师
     * <p>
     * desc:
     * 1、选择了任务包，并且任务包的发包人存在，则任务包的发包人为审批人
     * 1、1 选择了任务包，如果是基于授权方法的任务包，则根据授权配置中指定的审批角色判断（PM:项目经理 PL:授权接收人）
     * 2、如果没选择任务包或者任务包的发包人为空，则项目经理作为审批人
     * 3、项目、任务包都没有选或项目经理、任务包的发包人都是空，则资源上级为审批人
     *
     * @param payload 工时
     * @return
     */
    private Long findApprUserId(TimesheetPayload payload) {
        //选择了任务包，并且任务包的发包人存在，则任务包的发包人为审批人
        if (payload.getTaskId() != null) {
            // 选择了任务包，如果是基于授权方法的任务包，则根据授权配置中指定的审批角色判断（PM:项目经理 PL:授权接收人）
            final Long apprResIdByAuthInfo = taskService.getApprResIdByAuthInfo(payload.getTaskId());
            if (null != apprResIdByAuthInfo) {
                return apprResIdByAuthInfo;
            }

            // 根据4.0任务id查询
            Long taskDister = taskService.queryByTaskIdV4(payload.getTaskId()).getDisterUserId();//任务包的发包人
            if (taskDister != null && taskDister >= 0) {
                return taskDister;
            }
        }
        //如果没选择任务包或者任务包的发包人为空，则项目经理作为审批人
        if (payload.getProjId() != null) {
            ProjectQuery twProjectQuery = new ProjectQuery();
            twProjectQuery.setProjIdV4(payload.getProjId());
            final List<ProjectVO> projects = projectService.queryList(twProjectQuery);
            if (projects != null && projects.size() > 0) {
                Long pmId = projects.get(0).getPmUserId();
                if (pmId != null && pmId > 0) {
                    return pmId;
                }
            }
        }

        /*if (entity.getTaskId() != null) {//选了任务包，审批人为任务包的发包者
            return taskMapper.findTask(entity.getTaskId()).getDisterResId();
        }*/
        //项目、任务包都没有选或项目经理、任务包的发包人都是空，则资源上级为审批人
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = employeeDAO.queryUserOrgData(payload.getTsUserId());
        if (null == prdOrgEmployeeRefVO) {
            log.error("【匹配不到审批人】：工时填报用户主键：{} ; 工时数据：{}", payload.getTsUserId(), payload);
            throw TwException.error("", "匹配不到审批人，请联系管理员");
            //  查找自己的上级、管理员没有上级的情况就是自己
            //return payload.getTsUserId();
        }
        // 用户的部门
        Long tsUserBuId = payload.getTsUserBuId();
        PrdOrgOrganizationDO prdOrgOrganizationDO = prdOrgOrganizationDAO.queryById(tsUserBuId);
        String organizationType = prdOrgOrganizationDO.getOrganizationType();
        if (organizationType != null) {
            Long apprUserId = null;
            switch (organizationType) {
                case "BD":
                case "BY":
                    // 查询当前登录人是不是部门负责人
                    // BU级权限（查看当前登录人是否是部门负责人）
                    final List<PrdOrgOrganizationDO> organizationDOList = prdOrgOrganizationDAO.queryByManagerId(payload.getTsUserId());
                    Set<Long> orgIdList = null;
                    if (!CollectionUtils.isEmpty(organizationDOList)) {
                        orgIdList = organizationDOList.stream().map(PrdOrgOrganizationDO::getId).collect(Collectors.toSet());
                        if (orgIdList.contains(tsUserBuId)) {
                            //上级审批
                            Long parentId = prdOrgEmployeeRefVO.getParentId();
                            return parentId;
                        } else {
                            // 部门负责人审批
                            Long manageId = prdOrgEmployeeRefVO.getManageId();
                            return manageId;
                        }
                    }
                    // 部门负责人审批
                    apprUserId = prdOrgEmployeeRefVO.getManageId();
                    break;
                case "BM":
                case "BS":
                    //查找资源的父id
                    apprUserId = prdOrgEmployeeRefVO.getParentId();
                    break;
            }
            return apprUserId;
        } else {
            //查找资源的父id
            Long parentId = prdOrgEmployeeRefVO.getParentId();
            return parentId;
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    @Deprecated
    public TimesheetVO update(TimesheetPayload payload) {
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<TimesheetDO> optional = timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = optional.get();
                    // 判断状态是否为创建
                    if (!TimesheetStatus.CREATE.getCode().equals(entity.getTsStatus()) &&
                            !TimesheetStatus.REJECTED.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error("", "只能删除状态为创建或者退回的工时");
                    }

                    // 对于调休的工时删除修改加班的状态
                    String overtimeApplicationId = entity.getExt2();
                    if (StringUtils.hasText(overtimeApplicationId) && "SHIFTING".equals(entity.getTsActIden())) {

                        OvertimeApplicationDO overtimeApplicationDO = new OvertimeApplicationDO();
                        overtimeApplicationDO.setRestStatus(RestStatusEnum.CREATE.getCode());
                        overtimeApplicationDO.setRestDate(entity.getWorkDate());
                        overtimeApplicationDO.setId(Long.valueOf(overtimeApplicationId));
                        overtimeApplicationDAO.updateRestStatusById(overtimeApplicationDO);
                    }
                }
            });
            timesheetDAO.deleteSoft(keys);
        }
    }

    /**
     * 审批通过
     *
     * @param keys 键
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @Deprecated
    public void toApproved(List<Long> keys) {
    }

    /**
     * 高级审批
     *
     * @param keys 键
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void toAdvanced(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<TimesheetDO> optional = timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = optional.get();
                    if (!APPROVING.getCode().equals(entity.getTsStatus()) && !CREATE.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error("", "只有审批中或新建的单据才允许审批通过");
                    }
                    entity.setTsStatus(APPROVED.getCode());
                    entity.setApprResult("审批通过");
                    timesheetRepo.save(entity);

                }
            });
        }
    }

    /**
     * 审批拒绝
     *
     * @param keys       键
     * @param apprResult 从结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @Deprecated
    public void rejected(List<Long> keys, String apprResult) {

    }

    /**
     * 撤回
     *
     * @param keys 键
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void revoked(List<Long> keys) {

    }

    /**
     * 更新任务包工时当量信息
     *
     * @param taskIdList 任务id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateTaskTimesheetEqva(List<Long> taskIdList) {
    }

    @Override
    public Map<Long, Long> getTimesheetAndPlanIds() {
        Map<Long, Long> orgMap = new HashMap<>();
        List<Map<String, Object>> timeSheetAndPlanIds = timesheetRepo.getTimesheetAndPlanIds();
        for (Map<String, Object> timesheetAndPlanId : timeSheetAndPlanIds) {
            Long timesheetId = (Long) timesheetAndPlanId.get("timesheetId");
            Long workPlanId = (Long) timesheetAndPlanId.get("workPlanId");
            if (timesheetId != null && workPlanId != null) {
                orgMap.put(timesheetId, workPlanId);
            }
        }
        return orgMap;
    }

    @Override
    public Map<Long, Long> getV4AndV5TimesheetIds() {
        Map<Long, Long> timesheetMap = new HashMap<>();
        List<Map<String, Object>> v4AndV5TimesheetIds = timesheetRepo.getV4AndV5TimesheetIds();
        for (Map<String, Object> v4AndV5TimesheetId : v4AndV5TimesheetIds) {
            Long timesheetId = (Long) v4AndV5TimesheetId.get("timesheetId");
            Long timesheetIdV4 = (Long) v4AndV5TimesheetId.get("timesheetIdV4");
            if (timesheetId != null && timesheetIdV4 != null) {
                timesheetMap.put(timesheetIdV4, timesheetId);
            }
        }
        return timesheetMap;
    }

    /**
     * 工时填写企业微信自动提醒(BU/研发BU全员)
     */
    @Override
    public String timesheetAlertAll(Long employeeId) {
        List<PrdOrgEmployeeDO> onJobUsers = prdOrgEmployeeDAO.getOnJobUser();
        if(employeeId!=null){
            onJobUsers = Arrays.asList(prdOrgEmployeeRepo.findById(employeeId).get());
        }
        LocalDate firstDayMonth = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
        LocalDate today = LocalDate.now();
        LocalDate workDay = firstDayMonth;
        List<LocalDate> workDays = vacationRepo.selectWorkDaysByDays(firstDayMonth, today);
        if(workDays.contains(today)) {
            long difference = LocalDate.now().toEpochDay() - firstDayMonth.toEpochDay();
            List<LocalDate> dateList = new ArrayList<>();
            List<String> sendLogList = new ArrayList<>();
            List<String> unSendLogList = new ArrayList<>();
            if (difference >= 0) {
                while (workDay.isBefore(LocalDate.now().plusDays(1))) {
                    dateList.add(workDay);
                    workDay = workDay.plusDays(1);
                }
                for (PrdOrgEmployeeDO user : onJobUsers) {
                    List<LocalDate> writeDateList;
                    LocalDate enrollDate = user.getEnrollDate();
                    HashSet<LocalDate> unWritedSet;
                    HashSet<LocalDate> writedSet;
                    if (!ObjectUtils.isEmpty(enrollDate)) {
                        if (enrollDate.isBefore(firstDayMonth)) {
                            writeDateList = timesheetDAO.writedDate(user.getUserId(), firstDayMonth, today);
                            unWritedSet = new HashSet<>(dateList);
                        } else if (enrollDate.isAfter(today)) {
                            writeDateList = new ArrayList<>(0);
                            unWritedSet = new HashSet<>(0);
                        } else {
                            List<LocalDate> enDateList = new ArrayList<>();
                            while (enrollDate.isBefore(today.plusDays(1))) {
                                enDateList.add(enrollDate);
                                enrollDate = enrollDate.plusDays(1);
                            }
                            writeDateList = timesheetDAO.writedDate(user.getUserId(), firstDayMonth, today);
                            unWritedSet = new HashSet<>(enDateList);
                        }
                    } else {
                        writeDateList = timesheetDAO.writedDate(user.getUserId(), firstDayMonth, today);
                        unWritedSet = new HashSet<>(dateList);
                    }
                    writedSet = new HashSet<>(writeDateList);
                    unWritedSet.removeAll(writedSet);
                    if (unWritedSet.size() > 0) {
                        List<LocalDate> unWriteDateList = unWritedSet.stream().toList();
                        String content = "您" + unWriteDateList + "工时未提交或提交不足8小时,请及时提交";
                        String employeeName = user.getEmployeeName();
                        boolean sendFlag = qyWxCommunicationService.sendMessageToUserByWecomId(user.getWecomId(), content);
                        if (sendFlag) {
                            sendLogList.add(employeeName);
                        } else {
                            unSendLogList.add(employeeName);
                        }
                    }
                }
            }
            return "成功:" + sendLogList + "失败:" + unSendLogList;
        }else{
            return null;
        }
    }


    /**
     * 工时填写企业微信自动提醒(BU/研发BU全员)
     */
    @Override
    public String timesheetAlertAllBack(Long employeeId) {
        List<PrdOrgEmployeeDO> onJobUsers = prdOrgEmployeeDAO.getOnJobUser();
        if(employeeId!=null){
            onJobUsers = Arrays.asList(prdOrgEmployeeRepo.findById(employeeId).get());
        }
        LocalDate firstDayMonth = LocalDate.now().minusMonths(1).with(TemporalAdjusters.firstDayOfMonth());
        LocalDate today = LocalDate.now();
        LocalDate workDay = firstDayMonth;
        List<LocalDate> workDays = vacationRepo.selectWorkDaysByDays(firstDayMonth, today);
        if(workDays.contains(today)) {
            long difference = LocalDate.now().toEpochDay() - firstDayMonth.toEpochDay();
            List<LocalDate> dateList = new ArrayList<>();
            List<String> sendLogList = new ArrayList<>();
            List<String> unSendLogList = new ArrayList<>();
            if (difference >= 0) {
                while (workDay.isBefore(LocalDate.now().plusDays(1))) {
                    dateList.add(workDay);
                    workDay = workDay.plusDays(1);
                }
                for (PrdOrgEmployeeDO user : onJobUsers) {
                    List<LocalDate> backDateList;
                    LocalDate enrollDate = user.getEnrollDate();
                    HashSet<LocalDate> backSet;
                    if (!ObjectUtils.isEmpty(enrollDate)) {
                        if (enrollDate.isBefore(firstDayMonth)) {
                            backDateList = timesheetDAO.backDate(user.getUserId(), firstDayMonth, today);
                            backSet = new HashSet<>(backDateList);
                        } else if (enrollDate.isAfter(today)) {
                            backDateList = new ArrayList<>(0);
                            backSet = new HashSet<>(0);
                        } else {
                            List<LocalDate> enDateList = new ArrayList<>();
                            while (enrollDate.isBefore(today.plusDays(1))) {
                                enDateList.add(enrollDate);
                                enrollDate = enrollDate.plusDays(1);
                            }
                            backDateList = timesheetDAO.backDate(user.getUserId(), firstDayMonth, today);
                            backSet = new HashSet<>(backDateList);
                        }
                    } else {
                        backDateList = timesheetDAO.backDate(user.getUserId(), firstDayMonth, today);
                        backSet = new HashSet<>(backDateList);
                    }
                    if (backSet.size() > 0) {
                        backDateList = backSet.stream().toList();
                        String content = "您" + backDateList + "工时被退回，请及时进入TW处理";
                        String employeeName = user.getEmployeeName();
                        boolean sendFlag = qyWxCommunicationService.sendMessageToUserByWecomId(user.getWecomId(), content);
                        if (sendFlag) {
                            sendLogList.add(employeeName);
                        } else {
                            unSendLogList.add(employeeName);
                        }
                    }
                }
            }
            return "成功:" + sendLogList + "失败:" + unSendLogList;
        }else{
            return null;
        }
    }



    @Override
    public String timesheetAlertSuperior() {
        List<PrdOrgEmployeeDO> onJobUsers = prdOrgEmployeeDAO.getOnJobUser();

        LocalDate firstDayMonth = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
        LocalDate lastThreeDay = LocalDate.now().minusDays(3);
        LocalDate workDay = firstDayMonth;
        List<PrdOrgEmployeeSuperiorQuery> userSuperiorList = prdOrgEmployeeDAO.getUserSuperior();
        Map<Long, Long> userSuperiorMap = userSuperiorList.stream().collect(Collectors.toMap(PrdOrgEmployeeSuperiorQuery::getEmployeeId, PrdOrgEmployeeSuperiorQuery::getSuperiorId));
        Map<Long, String> superiorNameMap = userSuperiorList.stream().collect(Collectors.toMap(PrdOrgEmployeeSuperiorQuery::getSuperiorId, PrdOrgEmployeeSuperiorQuery::getSuperiorName, (val1, val2) -> val2));
        Map<Long, String> superiorWxMap = userSuperiorList.stream().collect(Collectors.toMap(PrdOrgEmployeeSuperiorQuery::getSuperiorId, PrdOrgEmployeeSuperiorQuery::getSuperiorWxId, (val1, val2) -> val2));
        Map<Long, String> superiorMap = new HashMap<>();
        List<String> sendLogList = new ArrayList<>();
        List<String> unSendLogList = new ArrayList<>();
        List<LocalDate> dateList = new ArrayList<>();
        long difference = lastThreeDay.toEpochDay() - firstDayMonth.toEpochDay();
        if (difference >= 0) {
            while (workDay.isBefore(lastThreeDay.plusDays(1))) {
                dateList.add(workDay);
                workDay = workDay.plusDays(1);
            }
            for (PrdOrgEmployeeDO user : onJobUsers) {
                if (userSuperiorMap.containsKey(user.getUserId())) {
                    List<LocalDate> writeDateList;
                    LocalDate enrollDate = user.getEnrollDate();
                    HashSet<LocalDate> unWritedSet;
                    HashSet<LocalDate> writedSet;
                    if (!ObjectUtils.isEmpty(enrollDate)) {
                        if (enrollDate.isBefore(firstDayMonth)) {
                            writeDateList = timesheetDAO.writedDate(user.getUserId(), firstDayMonth, lastThreeDay);
                            unWritedSet = new HashSet<>(dateList);
                        } else if (enrollDate.isAfter(lastThreeDay)) {
                            writeDateList = new ArrayList<>(0);
                            unWritedSet = new HashSet<>(0);
                        } else {
                            List<LocalDate> enDateList = new ArrayList<>();
                            while (enrollDate.isBefore(lastThreeDay.plusDays(1))) {
                                enDateList.add(enrollDate);
                                enrollDate = enrollDate.plusDays(1);
                            }
                            writeDateList = timesheetDAO.writedDate(user.getUserId(), firstDayMonth, lastThreeDay);
                            unWritedSet = new HashSet<>(enDateList);
                        }
                    } else {
                        writeDateList = timesheetDAO.writedDate(user.getUserId(), firstDayMonth, lastThreeDay);
                        unWritedSet = new HashSet<>(dateList);
                    }
                    writedSet = new HashSet<>(writeDateList);
                    unWritedSet.removeAll(writedSet);
                    if (unWritedSet.size() > 0) {
                        String userContent = user.getEmployeeName();
                        Long superiorId = userSuperiorMap.get(user.getUserId());
                        if (superiorMap.containsKey(superiorId)) {
                            String content = superiorMap.get(superiorId);
                            content = content + ',' + userContent;
                            superiorMap.put(superiorId, content);
                        } else {
                            superiorMap.put(superiorId, userContent);
                        }
                    }
                }
            }
            for (Long superiorId : superiorMap.keySet()) {
                String content = "您的下级【" + superiorMap.get(superiorId) + "】 工时已长时间延误未填写，请帮忙跟催以免影响工时结算。";
                boolean sendFlag = qyWxCommunicationService.sendMessageToUserByWecomId(superiorWxMap.get(superiorId), content);
                String log = superiorNameMap.get(superiorId) + ":【" + superiorMap.get(superiorId) + "】" +
                        "\n";
                if (sendFlag) {
                    sendLogList.add(log);
                } else {
                    unSendLogList.add(log);
                }
            }
        }
        return "成功:" + sendLogList + "失败:" + unSendLogList;
    }

    @Override
    public String timesheetAlertBuLeader() {
        List<PrdOrgEmployeeDO> onJobUsers = prdOrgEmployeeDAO.getOnJobUser();

        LocalDate lastMonday = LocalDate.now().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).minusDays(7);
        LocalDate lastFriday = lastMonday.plusDays(4);
        LocalDate workDay = lastMonday;
        List<PrdOrgEmployeeLeaderQuery> userBuLeaderList = prdOrgEmployeeDAO.getUserBuLeader();
        Map<Long, Long> userBuLeaderMap = userBuLeaderList.stream().collect(Collectors.toMap(PrdOrgEmployeeLeaderQuery::getEmployeeId, PrdOrgEmployeeLeaderQuery::getOrgLeaderId));
        Map<Long, String> userBuLeaderNameMap = userBuLeaderList.stream().collect(Collectors.toMap(PrdOrgEmployeeLeaderQuery::getOrgLeaderId, PrdOrgEmployeeLeaderQuery::getOrgLeaderName, (val1, val2) -> val2));
        Map<Long, String> buLeaderWxMap = userBuLeaderList.stream().collect(Collectors.toMap(PrdOrgEmployeeLeaderQuery::getOrgLeaderId, PrdOrgEmployeeLeaderQuery::getOrgLeaderWxId, (val1, val2) -> val2));
        Map<Long, String> buLeaderMap = new HashMap<>();
        List<LocalDate> dateList = new ArrayList<>();
        List<String> sendLogList = new ArrayList<>();
        List<String> unSendLogList = new ArrayList<>();
        while (workDay.isBefore(lastFriday.plusDays(1))) {
            dateList.add(workDay);
            workDay = workDay.plusDays(1);
        }
        for (PrdOrgEmployeeDO user : onJobUsers) {
            if (userBuLeaderMap.containsKey(user.getUserId())) {
                List<LocalDate> writeDateList;
                LocalDate enrollDate = user.getEnrollDate();
                HashSet<LocalDate> unWritedSet;
                HashSet<LocalDate> writedSet;
                if (!ObjectUtils.isEmpty(enrollDate)) {
                    if (enrollDate.isBefore(lastMonday)) {
                        writeDateList = timesheetDAO.writedDate(user.getUserId(), lastMonday, lastFriday);
                        unWritedSet = new HashSet<>(dateList);
                    } else if (enrollDate.isAfter(lastFriday)) {
                        writeDateList = new ArrayList<>(0);
                        unWritedSet = new HashSet<>(0);
                    } else {
                        List<LocalDate> enDateList = new ArrayList<>();
                        while (enrollDate.isBefore(lastFriday.plusDays(1))) {
                            enDateList.add(enrollDate);
                            enrollDate = enrollDate.plusDays(1);
                        }
                        writeDateList = timesheetDAO.writedDate(user.getUserId(), lastMonday, lastFriday);
                        unWritedSet = new HashSet<>(enDateList);
                    }
                } else {
                    writeDateList = timesheetDAO.writedDate(user.getUserId(), lastMonday, lastFriday);
                    unWritedSet = new HashSet<>(dateList);
                }
                writedSet = new HashSet<>(writeDateList);
                unWritedSet.removeAll(writedSet);
                if (unWritedSet.size() > 0) {
                    String userContent = user.getEmployeeName();
                    Long buLeaderId = userBuLeaderMap.get(user.getUserId());
                    if (buLeaderMap.containsKey(buLeaderId)) {
                        String content = buLeaderMap.get(buLeaderId);
                        content = content + ',' + userContent;
                        buLeaderMap.put(buLeaderId, content);
                    } else {
                        buLeaderMap.put(buLeaderId, userContent);
                    }
                }
            }
        }
        for (Long buLeaderId : buLeaderMap.keySet()) {
            String content = "您的部门成员【" + buLeaderMap.get(buLeaderId) + "】上周有工时未填写，请帮忙跟催以免影响工时结算。";
            boolean sendFlag = qyWxCommunicationService.sendMessageToUserByWecomId(buLeaderWxMap.get(buLeaderId), content);
            String log = userBuLeaderNameMap.get(buLeaderId) + ":【" + buLeaderMap.get(buLeaderId) + "】" +
                    "\n";
            if (sendFlag) {
                sendLogList.add(log);
            } else {
                unSendLogList.add(log);
            }
        }
        return "成功:" + sendLogList + "失败:" + unSendLogList;
    }


    /**
     * 修复一到六月的工时，临时方法
     */
    @Override
    public void repairTimesheet() {
        List<Map<String, Object>> timesheetList = timesheetRepo.queryTimeSheetToRepair();
        for (Map<String, Object> timesheet : timesheetList) {
            BigInteger id = (BigInteger) timesheet.get("id");
            BigInteger projId = (BigInteger) timesheet.get("projId");
            BigInteger tsUserId = (BigInteger) timesheet.get("tsUserId");
            Map<String, Object> timesheetToCopy = timesheetRepo.queryTimeSheetToCopy(projId, tsUserId);
            if (!ObjectUtils.isEmpty(timesheetToCopy)) {
                //更新当前的工时
                timesheetRepo.updateTimesheetByCopy((BigInteger) timesheetToCopy.get("taskId"), (String) timesheetToCopy.get("taskNo"), (String) timesheetToCopy.get("taskName"), (BigInteger) timesheetToCopy.get("actId"), (String) timesheetToCopy.get("actNo"), (String) timesheetToCopy.get("actName"), id);
            }
        }
    }

    @Override
    public String timesheetApprovingAlert() {
        LocalDate firstDayMonth = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
        LocalDate today = LocalDate.now();
        List<String> sendLogList = new ArrayList<>();
        List<String> unSendLogList = new ArrayList<>();
        Map<Long, String> apprMap = new HashMap<>();
        List<TimesheetApproveQuery> timesheetApproverList = timesheetDAO.approvingDate(firstDayMonth, today);
        Map<Long, String> apprWxMap = timesheetApproverList.stream().collect(Collectors.toMap(TimesheetApproveQuery::getApprUserId, TimesheetApproveQuery::getApprWxId, (val1, val2) -> val2));
        Map<Long, String> apprNameMap = timesheetApproverList.stream().collect(Collectors.toMap(TimesheetApproveQuery::getApprUserId, TimesheetApproveQuery::getApprName, (val1, val2) -> val2));
        for (TimesheetApproveQuery timesheetApproveQuery : timesheetApproverList) {
            String userContent = timesheetApproveQuery.getEmployeeName();
            Long apprUserId = timesheetApproveQuery.getApprUserId();
            if (apprMap.containsKey(apprUserId)) {
                String content = apprMap.get(apprUserId);
                content = content + ',' + userContent;
                apprMap.put(apprUserId, content);
            } else {
                apprMap.put(apprUserId, userContent);
            }
        }
        for (Long apprUserId : apprMap.keySet()) {
            String content = "您有【" + apprMap.get(apprUserId) + "】 提交的工时未审批，请及时审批";
            boolean sendFlag = qyWxCommunicationService.sendMessageToUserByWecomId(apprWxMap.get(apprUserId), content);
            String log = apprNameMap.get(apprUserId) + ":【" + apprMap.get(apprUserId) + "】" + "\n";
            if (sendFlag) {
                sendLogList.add(log);
            } else {
                unSendLogList.add(log);
            }
        }
        return "成功:" + sendLogList + "失败:" + unSendLogList;
    }

    /**
     * 检查创建和拒绝中 工时数据
     *
     * @param startDate 开始日期
     * @param endDate   结束日期
     * @param userId    用户id
     * @return boolean 存在返回 true 不存在返回false
     */
    @Override
    public boolean checkTimeSheetStatueInCreateAndRejected(LocalDate startDate, LocalDate endDate, Long userId) {
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        if (null == endDate) {
            throw TwException.error("", "结束日期不能为空");
        }
        if (null == startDate) {
            timesheetQuery.setWorkDateLessThanQuery(endDate);
        } else {
            List<LocalDate> workDateList = new ArrayList<>();
            workDateList.add(startDate);
            workDateList.add(endDate);
            timesheetQuery.setWorkDateBetween(workDateList);
        }
        timesheetQuery.setTsUserId(userId);
        List<String> tsStatusList = new ArrayList<>();
        tsStatusList.add(TimesheetStatus.CREATE.getCode());
        tsStatusList.add(TimesheetStatus.REJECTED.getCode());
        timesheetQuery.setTsStatusList(tsStatusList);
        long count = count(timesheetQuery);
        if (count > 0) {
            return true;
        }
        return false;
    }

    @Override
    @Transactional
    public void taskApprovalTimesheet(String param) {
        // 获取前一月
        LocalDate nowLocalDate = LocalDate.now().minusMonths(1);

        LocalDate firstDayOfMonth = nowLocalDate.with(TemporalAdjusters.firstDayOfMonth());
        LocalDate lastDayOfMonth = nowLocalDate.with(TemporalAdjusters.lastDayOfMonth());
        // 查询当月假日的审批中的工时id
        List<Long> naturalDateList = timesheetDAO.getWeekNotWorkDate(firstDayOfMonth, lastDayOfMonth);
        if (!CollectionUtils.isEmpty(naturalDateList)) {
            // 修改审批状态
            Long res = timesheetDAO.updateStateByTask(naturalDateList);
            log.info("Task修改假期审批状态res:{}", res);
        }

    }


}
