package com.elitesland.tw.tw5.server.prd.org.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author Lemon
 */
@Entity
@Table(name = "prd_org_company_notice")
@org.hibernate.annotations.Table(appliesTo = "prd_org_company_notice", comment = "公司公告表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdOrgCompanyNoticeDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -2209270838523653917L;

    @Comment("公告标题")
    @Column()
    private String noticeTitle;

//    @Comment("公告作者")
//    @Column()
//    private String noticeAuthor;

    @Comment("公告作者")
    @Column()
    private Long noticeAuthorUserId;

    @Comment("排序")
    @Column()
    private Integer sort;

    @Comment("更新时间")
    @Column()
    private LocalDateTime changeTime;

    @Comment("阅览量")
    @Column()
    private Long readAmount;

    @Comment("置顶标志")
    @Column()
    private Integer topFlag;

    @Comment("公告内容")
    @Column()
    private String noticeContent;

    @Comment("公告摘要")
    @Column()
    private String noticeAbstract;


    @Comment("附件")
    @Column()
    private String fileCodes;

    @Comment("发布标志")
    @Column()
    private Integer publishFlag;

    @Comment("公告类型")
    @Column()
    private String noticeType;
    /**
     * 资源id
     */
    @Comment("资源id")
    @Column()
    private String sourceId;
    /**
     * 触发时间表达式
     */
    @Comment("触发时间表达式")
    @Column()
    private String triggerTimeExpression;
}
