package com.elitesland.tw.tw5.server.prd.partner.common.controller;

import com.elitesland.tw.tw5.api.prd.partner.common.payload.BookContactsPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookContactsQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookContactsService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookContactsVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 业务伙伴-联系信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Api(tags = "业务伙伴-联系信息")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/bookContacts")
@Slf4j
public class BookContactsController {

    private final BookContactsService bookContactsService;

    /**
     * 业务伙伴-联系信息-新增
     *

     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("业务伙伴-联系信息-新增")
    public TwOutputUtil insert(@RequestBody BookContactsPayload payload){
        return TwOutputUtil.ok(bookContactsService.insert(payload,true));
    }

    /**
     * 业务伙伴-联系信息-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("业务伙伴-联系信息-更新")
    public TwOutputUtil update(@RequestBody BookContactsPayload payload){
        return TwOutputUtil.ok(bookContactsService.update(payload,true));
    }

    /**
     * 业务伙伴-联系信息-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("业务伙伴-联系信息-主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(bookContactsService.queryByKey(key));
    }

    /**
     * 业务伙伴-联系信息-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("业务伙伴-联系信息-分页")
    public TwOutputUtil paging(BookContactsQuery query) {
        return TwOutputUtil.ok(bookContactsService.queryPaging(query));
    }

    /**
     * 业务伙伴-联系信息-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("业务伙伴-联系信息-查询列表")
    public TwOutputUtil<List<BookContactsVO>> queryList(BookContactsQuery query) {
        return TwOutputUtil.ok(bookContactsService.queryListDynamic(query));
    }

    /**
     * 业务伙伴-联系信息-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("业务伙伴-联系信息-删除")
    public TwOutputUtil deleteSoft(Long[] keys,Long bookId,Long partnerId) {
        bookContactsService.deleteSoft(Arrays.asList(keys),bookId,partnerId,true);
        return TwOutputUtil.ok();
    }
    /**
     * 业务伙伴-联系信息-查询列表
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/listSimple")
    //@UdcNameClass
    @ApiOperation("业务伙伴-联系信息-查询所有联系人")
    public TwOutputUtil listSimple() {
        return TwOutputUtil.ok(bookContactsService.listSimple());
    }


}
