package com.elitesland.tw.tw5.server.prd.partner.common.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 业务伙伴-发票信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Entity
@Table(name = "com_book_invoice", indexes = {
        @Index(name="index_book_id",columnList = "book_id")
})
@org.hibernate.annotations.Table(appliesTo = "com_book_invoice", comment = "业务伙伴-发票信息")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BookInvoiceDO extends BaseModel implements Serializable  {
    /** 地址薄id */
    @Comment("地址薄id")
    @Column(name = "book_id")
    private Long bookId;
    /** 发票信息 */
    @Comment("发票信息")
    @Column()
    @FieldCreateLog(fieldName = "发票信息")
    @FieldUpdateLog(fieldName = "发票信息")
    private String invoiceMessage;
    /** 发票抬头 */
    @Comment("发票抬头")
    @Column()
    @FieldCreateLog(fieldName = "发票抬头")
    @FieldUpdateLog(fieldName = "发票抬头")
    private String invoiceTitle;
    /** 税率 udc[prd:ab:tax_rate] */
    @Comment("税率 udc[prd:ab:tax_rate]")
    @Column()
    @FieldUpdateLog(fieldName = "税率", selectionKey = "prd:ab:tax_rate")
    @FieldCreateLog(fieldName = "税率", selectionKey = "prd:ab:tax_rate")
    private String taxRete;
    /** 税号 */
    @Comment("税号")
    @Column()
    @FieldCreateLog(fieldName = "税号")
    @FieldUpdateLog(fieldName = "税号")
    private String taxNo;
    /** 开票类型 udc[prd:ab:inv_type] */
    @Comment("开票类型 udc[prd:ab:inv_type]")
    @Column()
    @FieldUpdateLog(fieldName = "开票类型", selectionKey = "prd:ab:inv_type")
    @FieldCreateLog(fieldName = "开票类型", selectionKey = "prd:ab:inv_type")
    private String invoiceType;
    /** 开票地址 */
    @Comment("开票地址")
    @Column()
    @FieldCreateLog(fieldName = "开票地址")
    @FieldUpdateLog(fieldName = "开票地址")
    private String invoiceAddress;
    /** 电话 */
    @Comment("电话")
    @Column()
    @FieldCreateLog(fieldName = "电话")
    @FieldUpdateLog(fieldName = "电话")
    private String invoicePhone;
    /** 开户行 */
    @Comment("开户行")
    @Column()
    @FieldCreateLog(fieldName = "开户行")
    @FieldUpdateLog(fieldName = "开户行")
    private String depositBank;
    /** 账户 */
    @Comment("账户")
    @Column()
    @FieldCreateLog(fieldName = "账户")
    @FieldUpdateLog(fieldName = "账户")
    private String invoiceAccount;
    /** 币种 udc[SYSTEM_BASIC:CURRENCY] */
    @Comment("币种 udc[SYSTEM_BASIC:CURRENCY]")
    @Column()
    @FieldUpdateLog(fieldName = "币种", selectionKey = "SYSTEM_BASIC:CURRENCY")
    @FieldCreateLog(fieldName = "币种", selectionKey = "SYSTEM_BASIC:CURRENCY")
    private String currency;
    /** 是否为默认开票信息 */
    @Comment(value="是否为默认开票信息",defaultValue = "false")
    @Column()
    @FieldUpdateLog(fieldName = "默认开票信息", selectionKey = "CRM:BUSINESS_PARTNER:SWITCH")
    @FieldCreateLog(fieldName = "默认开票信息", selectionKey = "CRM:BUSINESS_PARTNER:SWITCH")
    private Boolean isDefault;

    public void copy(BookInvoiceDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
