package com.elitesland.tw.tw5.server.prd.partner.strategy.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 分级策略范围配置
 *
 * @author wangly
 * @date 2023-06-16
 */
@Entity
@Table(name = "business_strategy_range_setting", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "business_strategy_range_setting", comment = "分级策略范围配置")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessStrategyRangeSettingDO extends BaseModel implements Serializable  {
    /** 分级策略id business_strategy.id */
    @Comment("分级策略id business_strategy.id")
    @Column()
    private Long strategyId;
    /** 策略范围目标值 udc[CRM:BUSINESS_STRATEGY:RANGE:TARGET] */
    @Comment("策略范围目标值 udc[CRM:BUSINESS_STRATEGY:RANGE:TARGET]")
    @Column()
    private String examTarget;
    /** 筛选字段key */
    @Comment("筛选字段key")
    @Column()
    private String fieldKey;
    /** 筛选字段名称 */
    @Comment("筛选字段名称")
    @Column()
    private String fieldName;
    /** 搜索类型 */
    @Comment("搜索类型")
    @Column()
    private String searchType;
    /** 搜索范围 */
    @Comment("搜索范围")
    @Column()
    private String searchScope;
    /** 搜索条件,多个条件以英文逗号隔开 */
    @Comment("搜索条件,多个条件以英文逗号隔开")
    @Column()
    private String searchCondition;
    /** 设置项KEY */
    @Comment("设置项KEY")
    @Column()
    private String settingKey;
    /** 设置项名称 */
    @Comment("设置项名称")
    @Column()
    private String settingName;
    /** 设置项值 */
    @Comment("设置项值")
    @Column()
    private String settingValue;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;

    public void copy(BusinessStrategyRangeSettingDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
