package com.elitesland.tw.tw5.server.prd.personplan.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PersonPlanDtlPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PersonPlanDtlQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanDtlService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanDtlVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * @author : WWW
 * @date : 2024-2-21
 * @desc : 人员规划明细
 */
@RestController
@RequestMapping("/api/personPlanDtl")
@RequiredArgsConstructor
@Api(value = "人员规划明细", tags = {"人员规划明细"})
public class PersonPlanDtlController {

    private final PersonPlanDtlService personPlanDtlService;


    @GetMapping("get")
    @ApiOperation("详情-人员规划明细")
    public TwOutputUtil<PersonPlanDtlVO> get(Long id) {

        PersonPlanDtlVO res = personPlanDtlService.get(id);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("save")
    @ApiOperation("新增-人员规划明细")
    public TwOutputUtil<Long> save(@RequestBody PersonPlanDtlPayload personPlanDtlPayload) {

        PersonPlanDtlVO res = personPlanDtlService.save(personPlanDtlPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @PostMapping("update")
    @ApiOperation("修改-人员规划明细")
    public TwOutputUtil<Long> update(@RequestBody PersonPlanDtlPayload personPlanDtlPayload) {

        Long res = personPlanDtlService.update(personPlanDtlPayload);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("del")
    @ApiOperation("删除-人员规划明细")
    public TwOutputUtil<Long> del(@RequestBody List<Long> ids) {

        Long res = personPlanDtlService.del(ids);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("page")
    @UdcNameClass
    @ApiOperation("分页查询-人员规划明细")
    public TwOutputUtil<PagingVO<PersonPlanDtlVO>> page(@RequestBody PersonPlanDtlQuery personPlanDtlQuery) {

        PagingVO<PersonPlanDtlVO> res = personPlanDtlService.page(personPlanDtlQuery);
        return TwOutputUtil.ok(res);

    }


    @GetMapping("getList")
    @ApiOperation("列表查询-人员规划明细")
    public TwOutputUtil<List<PersonPlanDtlVO>> getList(PersonPlanDtlQuery personPlanDtlQuery) {

        List<PersonPlanDtlVO> res = personPlanDtlService.getList(personPlanDtlQuery);
        return TwOutputUtil.ok(res);

    }

    /**
     * 下载模板
     *
     * @return result
     */
    @ApiOperation("下载模板")
    @GetMapping("/tmpDownload")
    public void tmpDownload(HttpServletResponse response, Long planId) {
        personPlanDtlService.tmpDownload(response, planId);
    }

    /**
     * 批量导入excel
     *
     * @return result
     */
    @ApiOperation("批量导入excel")
    @PostMapping(value = "/batchImport", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    public TwOutputUtil batchImport(MultipartFile file, Long planId) {
        String info = personPlanDtlService.batchImport(file, planId);
        if (StringUtils.hasText(info)) {
            return TwOutputUtil.ok("", info, "");
        } else {
            return TwOutputUtil.ok();
        }
    }

    @GetMapping("getplanVo")
    @ApiOperation("人员规划明细对比")
    public TwOutputUtil getTmp() {

        personPlanDtlService.insertPlanTmp();
        return TwOutputUtil.ok();

    }
}

