package com.elitesland.tw.tw5.server.prd.personplan.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 人员规划版本
 *
 * @author wangly
 * @date 2024-04-07
 */
@Entity
@Table(name = "person_plan_version", indexes = {
        @Index(name = "plan_id_index", columnList = "plan_id")
})
@Accessors(chain = true)
@org.hibernate.annotations.Table(appliesTo = "person_plan_version", comment = "人员规划版本")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PersonPlanVersionDO extends BaseModel implements Serializable {
    /**
     * 资源规划主表id
     */
    @Comment("资源规划主表id")
    @Column(name="plan_id")
    private Long planId;
    /**
     * 类型
     */
    @Comment("类型")
    @Column()
    private String planType;
    /**
     * 版本名称
     */
    @Comment("版本名称")
    @Column()
    private String versionName;
    /**
     * 资源规划json
     */
    @Comment("版本信息")
    @Column(name = "change_content", columnDefinition = "text comment '资源规划json'")
    private String changeContent;
    /**
     * 变更单据id
     */
    @Comment("变更单据id")
    @Column()
    private Long objId;
    /**
     * 版本号
     */
    @Comment("版本号")
    @Column()
    private Integer versionNo;
    /**
     * 变更状态
     */
    @Comment("变更状态")
    @Column()
    private String status;
    /**
     * 流程状态
     */
    @Comment("流程状态")
    @Column()
    private String apprStatus;
    /**
     * 流程实例ID
     */
    @Comment("流程实例ID")
    @Column()
    private String apprProcInstId;
    /**
     * extString1
     */
    @Comment("extString1")
    @Column()
    private String extString1;
    /**
     * extString2
     */
    @Comment("extString2")
    @Column()
    private String extString2;
    /**
     * extString3
     */
    @Comment("extString3")
    @Column()
    private String extString3;
    /**
     * extString4
     */
    @Comment("extString4")
    @Column()
    private String extString4;
    /**
     * extString5
     */
    @Comment("extString5")
    @Column()
    private String extString5;

    public void copy(PersonPlanVersionDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
