package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectTemplateActPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectTemplateActQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectTemplateActService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectTemplateActVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectTemplateActConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectTemplateActDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectTemplateActDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectTemplateActRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 项目模板活动
 *
 * @author xxb
 * @date 2023-08-03
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsProjectTemplateActServiceImpl extends BaseServiceImpl implements PmsProjectTemplateActService {

    private final PmsProjectTemplateActRepo pmsProjectTemplateActRepo;
    private final PmsProjectTemplateActDAO pmsProjectTemplateActDAO;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<PmsProjectTemplateActVO> batchSave(List<PmsProjectTemplateActPayload> actList) {
        List<PmsProjectTemplateActDO> entityList = new ArrayList<>();
        Map<Integer, Boolean> seenSort = new HashMap<>();
        for (PmsProjectTemplateActPayload payload : actList) {
            if (ObjectUtils.isEmpty(payload.getActCode()) || ObjectUtils.isEmpty(payload.getActName())) {
                throw TwException.error("", "活动编号和名称不能为空 !");
            }
            Integer sortNo = payload.getSortNo();
            if (ObjectUtils.isEmpty(sortNo)) {
                throw TwException.error("", "序号不能为空 !");
            }
            if (seenSort.containsKey(sortNo)) {
                throw TwException.error("", "序号不允许重复 !");
            } else {
                seenSort.put(sortNo, true);
            }
            if (1 == sortNo && 1 != payload.getActStageFlag()) {
                throw TwException.error("", "项目的第一个活动 必须是阶段 !");
            }
            // 规划天数 保留整数
            if (!ObjectUtils.isEmpty(payload.getPlannedDays())) {
                payload.setPlannedDays(payload.getPlannedDays().setScale(0));
            }
            // 规划当量 保留两位小数
            if (!ObjectUtils.isEmpty(payload.getPlanningEquivalent())) {
                payload.setPlanningEquivalent(payload.getPlanningEquivalent().setScale(2, RoundingMode.HALF_UP));
            }
            PmsProjectTemplateActDO entityDo = PmsProjectTemplateActConvert.INSTANCE.toDo(payload);
            entityList.add(entityDo);
        }

        // 先进行删除操作 再操作 新增或修改操作
        PmsProjectTemplateActQuery pmsProjectTemplateActQuery = new PmsProjectTemplateActQuery();
        pmsProjectTemplateActQuery.setTemplateId(actList.get(0).getTemplateId());
        List<PmsProjectTemplateActVO> fromDbList = pmsProjectTemplateActDAO.queryListDynamic(pmsProjectTemplateActQuery);
        if (!ObjectUtils.isEmpty(fromDbList)) {
            List<Long> updateList = actList.stream().filter(v -> !ObjectUtils.isEmpty(v.getId())).map(v -> v.getId()).collect(Collectors.toList());
            List<Long> delList = fromDbList.stream().filter(item -> !updateList.contains(item.getId())).map(v -> v.getId()).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(delList)) {
                pmsProjectTemplateActDAO.deleteSoft(delList);
            }
        }
        return PmsProjectTemplateActConvert.INSTANCE.toVoList(pmsProjectTemplateActRepo.saveAll(entityList));
    }

    @Override
    public List<PmsProjectTemplateActVO> queryByTemplateId(Long templateId) {
        return pmsProjectTemplateActDAO.queryByTemplateId(templateId);
    }

    @Override
    public PagingVO<PmsProjectTemplateActVO> queryPaging(PmsProjectTemplateActQuery query) {
        return pmsProjectTemplateActDAO.queryPaging(query);
    }

    @Override
    public List<PmsProjectTemplateActVO> queryListDynamic(PmsProjectTemplateActQuery query) {
        return pmsProjectTemplateActDAO.queryListDynamic(query);
    }

    @Override
    public PmsProjectTemplateActVO queryByKey(Long key) {
        PmsProjectTemplateActDO entity = pmsProjectTemplateActRepo.findById(key).orElseGet(PmsProjectTemplateActDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsProjectTemplateActVO vo = PmsProjectTemplateActConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectTemplateActVO insert(PmsProjectTemplateActPayload payload) {
        PmsProjectTemplateActDO entityDo = PmsProjectTemplateActConvert.INSTANCE.toDo(payload);
        return PmsProjectTemplateActConvert.INSTANCE.toVo(pmsProjectTemplateActRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectTemplateActVO update(PmsProjectTemplateActPayload payload) {
        PmsProjectTemplateActDO entity = pmsProjectTemplateActRepo.findById(payload.getId()).orElseGet(PmsProjectTemplateActDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsProjectTemplateActDO entityDo = PmsProjectTemplateActConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsProjectTemplateActConvert.INSTANCE.toVo(pmsProjectTemplateActRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PmsProjectTemplateActPayload payload) {
        PmsProjectTemplateActDO entity = pmsProjectTemplateActRepo.findById(payload.getId()).orElseGet(PmsProjectTemplateActDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = pmsProjectTemplateActDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            pmsProjectTemplateActDAO.deleteSoft(keys);
        }
    }

}
