package com.elitesland.tw.tw5.server.prd.product.controller;

import com.elitesland.tw.tw5.api.prd.product.payload.PrdProductCasePayload;
import com.elitesland.tw.tw5.api.prd.product.query.PrdProductCaseQuery;
import com.elitesland.tw.tw5.api.prd.product.service.PrdProductCaseService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 产品成功案例
 *
 * @author likunpeng
 * @date 2023-05-22
 */
@Api(tags = "产品成功案例")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/prdProductCase")
@Slf4j
public class PrdProductCaseController {

    private final PrdProductCaseService prdProductCaseService;

    /**
     * 产品成功案例-新增
     *

     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("产品成功案例-新增")
    public TwOutputUtil insert(@RequestBody PrdProductCasePayload payload){
        return TwOutputUtil.ok(prdProductCaseService.insert(payload));
    }

    /**
     * 产品成功案例-新增多个
     *

     * @param list 集合
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/insertAll")
    @ApiOperation("产品成功案例-新增多个")
    public TwOutputUtil insertAll(@RequestBody List<PrdProductCasePayload> list){
        return TwOutputUtil.ok(prdProductCaseService.insertAll(list));
    }

    /**
     * 产品成功案例-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("产品成功案例-更新")
    public TwOutputUtil update(@RequestBody PrdProductCasePayload payload){
        return TwOutputUtil.ok(prdProductCaseService.update(payload));
    }

    /**
     * 产品成功案例-更新
     *
     * @param payloads 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("/updateALl")
    @ApiOperation("产品成功案例-更新")
    public TwOutputUtil updateAll(@RequestBody List<PrdProductCasePayload> payloads){
        return TwOutputUtil.ok(prdProductCaseService.updateAll(payloads));
    }

    /**
     * 产品成功案例-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("产品成功案例-主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(prdProductCaseService.queryByKey(key));
    }

    /**
     * 产品成功案例-产品id查询
     *
     * @param prodId 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryByProductKey/{prodId}")
    // @UdcNameClass
    @ApiOperation("产品成功案例-产品id查询")
    public TwOutputUtil queryByProductKey(@PathVariable Long prodId) {
        return TwOutputUtil.ok(prdProductCaseService.queryByProductKey(prodId));
    }

    /**
     * 产品成功案例-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("产品成功案例-分页")
    public TwOutputUtil paging(PrdProductCaseQuery query) {
        return TwOutputUtil.ok(prdProductCaseService.queryPaging(query));
    }

    /**
     * 产品成功案例-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("产品成功案例-查询列表")
    public TwOutputUtil queryList(PrdProductCaseQuery query) {
        return TwOutputUtil.ok(prdProductCaseService.queryListDynamic(query));
    }

    /**
     * 产品成功案例-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("产品成功案例-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        prdProductCaseService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
