package com.elitesland.tw.tw5.server.prd.purchase.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseContractQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseContractService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 旧采购合同
 *
 * @folder 采购合同列表
 * @author likunpeng
 * @date 2024-01-03
 */
@Api(tags = "旧采购合同")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/purchaseContract")
@Slf4j
public class PurchaseContractController {

private final PurchaseContractService purchaseContractService;


    /**
     * 旧采购合同-主键查询
     *
     * @folder 采购合同列表
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("旧采购合同-主键查询")
    public TwOutputUtil<PurchaseContractVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(purchaseContractService.queryByKey(key));
    }

    /**
     * 旧采购合同-分页
     *
         * @folder 采购合同列表
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("旧采购合同-分页")
    public TwOutputUtil<PagingVO<PurchaseContractVO>> paging(PurchaseContractQuery query) {
        return TwOutputUtil.ok(purchaseContractService.queryPaging(query));
    }


}

