package com.elitesland.tw.tw5.server.prd.purchase.controller;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.TPurchaseContractOverPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.TPurchaseContractOverQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.TPurchaseContractOverService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.TPurchaseContractOverVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 采购合同终止
 *
 * @author lemon
 * @date 2023-10-19
 */
@Api(tags = "采购合同终止")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/tPurchaseContractOver")
@Slf4j
public class TPurchaseContractOverController {

private final TPurchaseContractOverService tPurchaseContractOverService;

    /**
     * 采购合同终止-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("采购合同终止-新增")
    public TwOutputUtil<TPurchaseContractOverVO> insert(@RequestBody TPurchaseContractOverPayload payload){
         return TwOutputUtil.ok(tPurchaseContractOverService.insert(payload));
    }

    /**
     * 采购合同终止-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("insertWithWorkFlow")
    @ApiOperation("采购合同终止-新增")
    public TwOutputUtil<TPurchaseContractOverVO> insertWithWorkFlow(@RequestBody TPurchaseContractOverPayload payload){
        return TwOutputUtil.ok(tPurchaseContractOverService.insertWithWorkFlow(payload));
    }
    /**
     * 采购合同终止-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("采购合同终止-更新")
    public TwOutputUtil<TPurchaseContractOverVO> update(@RequestBody TPurchaseContractOverPayload payload){
        return TwOutputUtil.ok(tPurchaseContractOverService.update(payload));
    }

    /**
     * 采购合同终止-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("采购合同终止-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody TPurchaseContractOverPayload payload){
        return TwOutputUtil.ok(tPurchaseContractOverService.updateByKeyDynamic(payload));
    }

    /**
     * 采购合同终止-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("采购合同终止-主键查询")
    public TwOutputUtil<TPurchaseContractOverVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(tPurchaseContractOverService.queryByKey(key));
    }

    /**
     * 采购合同终止-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("采购合同终止-分页")
    public TwOutputUtil<PagingVO<TPurchaseContractOverVO>> paging(TPurchaseContractOverQuery query) {
        return TwOutputUtil.ok(tPurchaseContractOverService.queryPaging(query));
    }

    /**
     * 采购合同终止-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("采购合同终止-查询列表")
    public TwOutputUtil<List<TPurchaseContractOverVO>> queryList(TPurchaseContractOverQuery query) {
        return TwOutputUtil.ok(tPurchaseContractOverService.queryListDynamic(query));
    }

    /**
     * 采购合同终止-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("采购合同终止-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         tPurchaseContractOverService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

