package com.elitesland.tw.tw5.server.prd.purchase.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.time.LocalDate;
import java.math.BigDecimal;

/**
 * 采购协议明细
 *
 * @author Echo
 * @date 2023-06-08
 */
@Entity
@Table(name = "t_purchase_agreement_details", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_purchase_agreement_details", comment = "采购协议明细")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PurchaseAgreementDetailsDO extends BaseModel implements Serializable  {
    /** 采购协议id */
    @Comment("采购协议id")
    @Column
    private Long agreementId;
    /** 关联产品 */
    @Comment("关联产品")
    @Column()
    private Long relatedProductId;
    /** 采购产品 */
    @Comment("采购产品")
    @Column()
    private String productName;
    /** 产品大类 */
    @Comment("产品大类")
    @Column()
    private String classId;
    /** 产品小类 */
    @Comment("产品小类")
    @Column()
    private String subClassId;
    /** 数量 */
    @Comment("数量")
    @Column()
    private BigDecimal quantity;
    /** 含税单价 */
    @Comment("含税单价")
    @Column()
    private BigDecimal taxPrice;
    /** 税率 */
    @Comment("税率")
    @Column()
    private String taxRate;
    /** 含税总额 */
    @Comment("含税总额")
    @Column()
    private BigDecimal taxAmt;
    /** 不含税总额 */
    @Comment("不含税总额")
    @Column()
    private BigDecimal taxNotAmt;
    /** 交期 */
    @Comment("交期")
    @Column()
    private LocalDate deliveryDate;
    /** 说明 */
    @Comment("说明")
    @Column()
    private String note;

    public void copy(PurchaseAgreementDetailsDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
