package com.elitesland.tw.tw5.server.prd.salecon.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.SaleConExecConditionPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.SaleConExecConditionQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConExecConditionService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConExecConditionVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;


/**
 * 销售合同执行情况管理
 *
 * @author sunxw
 * @date 2023-11-24
 */
@Api(tags = "销售合同执行情况管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/saleConExecCondition")
@Slf4j
public class SaleConExecConditionController {

    private final SaleConExecConditionService saleConExecConditionService;
    private final SaleConContractService saleConContractService;

    /**
     * 销售合同执行情况管理-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil<SaleConExecConditionVO> insertOrUpdate(@RequestBody SaleConExecConditionPayload payload) {
        return TwOutputUtil.ok(saleConExecConditionService.insertOrUpdate(payload));
    }

    @GetMapping("/getCalcEffectAmt")
    @ApiOperation("获取核算后有效金额")
    public TwOutputUtil<BigDecimal> calcEffectAmt(@RequestBody SaleConExecConditionPayload payload) {
        return TwOutputUtil.ok(saleConExecConditionService.calcEffectAmt(payload));
    }

    /**
     * 销售合同执行情况管理-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("销售合同执行情况管理-更新")
    public TwOutputUtil<SaleConExecConditionVO> update(@RequestBody SaleConExecConditionPayload payload) {
        return TwOutputUtil.ok(saleConExecConditionService.update(payload));
    }

    /**
     * 销售合同执行情况管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("销售合同执行情况管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody SaleConExecConditionPayload payload) {
        return TwOutputUtil.ok(saleConExecConditionService.updateByKeyDynamic(payload));
    }

    /**
     * 销售合同执行情况管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("销售合同执行情况管理-主键查询")
    public TwOutputUtil<SaleConExecConditionVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(saleConExecConditionService.queryByKey(key));
    }

    /**
     * 销售合同执行情况管理-根据合同编号查询
     *
     * @param contractId 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/dtl/{contractId}")
    @UdcNameClass
    @ApiOperation("销售合同执行情况管理-根据合同编号查询")
    public TwOutputUtil<SaleConExecConditionVO> queryOneByContractId(@PathVariable Long contractId) {
        if (ObjectUtils.isEmpty(contractId)) {
            return TwOutputUtil.error();
        }
        return TwOutputUtil.ok(saleConExecConditionService.queryByContractId(contractId));
    }

    /**
     * 销售合同执行情况管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("销售合同执行情况管理-分页")
    public TwOutputUtil<PagingVO<SaleConExecConditionVO>> paging(SaleConExecConditionQuery query) {
        return TwOutputUtil.ok(saleConExecConditionService.queryPaging(query));
    }

    /**
     * 销售合同执行情况管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("销售合同执行情况管理-查询列表")
    public TwOutputUtil<List<SaleConExecConditionVO>> queryList(SaleConExecConditionQuery query) {
        return TwOutputUtil.ok(saleConExecConditionService.queryListDynamic(query));
    }

    /**
     * 销售合同执行情况管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("销售合同执行情况管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        saleConExecConditionService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


    /**
     * 销售合同执行情况管理-查询分页待办数据
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryWorkAgentFlagList")
    @ApiOperation("销售合同执行情况管理-工作待办数据")
    @UdcNameClass
    public TwOutputUtil<List<SaleConExecConditionVO>> queryWorkAgentFlagPaging(SaleConExecConditionQuery query) {
        return TwOutputUtil.ok(saleConExecConditionService.queryWorkAgentFlagPaging(query));
    }
    @GetMapping("/saleConExecConditionApply")
    @ApiOperation("销售合同执行情况管理-发起流程")
    public void saleConExecConditionApply( Long contractId){
        SaleConContractVO saleConContractVO = saleConContractService.queryByKey(contractId);
        saleConExecConditionService.saleConExecConditionApply(null,saleConContractVO);
    }
}

