package com.elitesland.tw.tw5.server.prd.salecon.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 业绩统计
 *
 * @author likunpeng
 * @date 2023-04-24
 */
@Entity
@Table(name = "con_achieve", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "con_achieve", comment = "业绩统计")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ConAchieveDO extends BaseModel implements Serializable  {
    /** 合同ID */
    @Comment("合同ID")
    @Column()
    private Long contractId;
    /** 折算后有效销售额 */
    @Comment("折算后有效销售额")
    @Column()
    private BigDecimal obversionEffectiveAmt;
    /** 业绩统计状态 */
    @Comment("业绩统计状态")
    @Column()
    private String achieveStatus;

    @Comment("tw4.0业绩统计ID")
    @Column(name = "achieve_id_v4")
    private Long achieveIdV4;

    /** 平台提成比例 */
    @Comment("平台提成比例")
    @Column()
    private BigDecimal percentage;



    public void copy(ConAchieveDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
