package com.elitesland.tw.tw5.server.prd.salecon.repo;

import com.elitesland.tw.tw5.server.prd.salecon.entity.ConEpibolyCostConDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 外包费用确认单
 *
 * @author likunpeng
 * @date 2023-04-17
 */
public interface ConEpibolyCostConRepo extends JpaRepository<ConEpibolyCostConDO, Long>, JpaSpecificationExecutor<ConEpibolyCostConDO> {

    @Query(value = " select * from con_epiboly_cost_con e where e.modify_time >= ?1  ", nativeQuery = true)
    List<ConEpibolyCostConDO> findByModifyTimeStart(String format);

    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update con_epiboly_cost_con set modify_time=now() where id=?1",nativeQuery = true)
    @Modifying
    void updateRemark(Long id);
}
