package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemMenuPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemMenuQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemMenuService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemMenuVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 菜单管理
 *
 * @author wangding
 */
@Api("菜单管理")
@RestController
@RequiredArgsConstructor
//@RequestMapping(API_SYSTEM)
@RequestMapping("/api/system")
@Slf4j
public class PrdSystemMenuController {

    private final PrdSystemMenuService service;

    /**
     * 新建
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("新增")
    @PostMapping("/menu/insert")
    public TwOutputUtil insert(PrdSystemMenuPayload entity) {
        PrdSystemMenuVO vo = service.insert(entity);
        return TwOutputUtil.ok(vo);
    }


    /**
     * 状态修改
     *
     * @param id 主键 menuStatus 状态
     * @return result
     */
    @ApiOperation("状态修改")
    @PutMapping("/menu/updateStatus")
    public TwOutputUtil updateStatus(Long id, Integer menuStatus) {
        service.updateStatus(id, menuStatus);
        return TwOutputUtil.ok();
    }

    /**
     * 修改
     *
     * @param entity po类
     * @return result
     */
    @ApiOperation("修改")
    @PutMapping("/menu/update")
    public TwOutputUtil update(PrdSystemMenuPayload entity) {
        service.update(entity);
        return TwOutputUtil.ok();
    }

    /**
     * 物理删除
     *
     * @param key 主键
     * @return result
     */
    @ApiOperation("物理删除")
    @DeleteMapping("/menu/delete/{key}")
    public TwOutputUtil delete(@PathVariable Long key) {
        service.delete(key);
        return TwOutputUtil.ok();
    }

    /**
     * 逻辑删除
     *
     * @param key 主键
     * @return result
     */
    @DeleteMapping("/menu/deleteSoft/{key}")
    public TwOutputUtil deleteSoft(@PathVariable Long key) {
        service.deleteSoft(key);
        return TwOutputUtil.ok();
    }

    /**
     * 根据主键查询
     *
     * @param key 主键
     * @return result
     */
    @ApiOperation("主键查询")
    @GetMapping("/menu/{key}")
    public TwOutputUtil findByKey(@PathVariable Long key) {
        PrdSystemMenuVO vo = service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 列表查询
     *
     * @return result
     */
    @ApiOperation("列表查询")
    @GetMapping("/menu/list")
    public TwOutputUtil queryList() {
        List<PrdSystemMenuVO> paging = service.queryList();
        return TwOutputUtil.ok(paging);
    }

    /**
     * 可用菜单查询
     *
     * @return result
     */
    @GetMapping("/menu/usableList")
    public TwOutputUtil usableList(PrdSystemMenuQuery query) {
        List<PrdSystemMenuVO> paging = service.usableList(query);
        return TwOutputUtil.ok(paging);
    }

}
