package com.elitesland.tw.tw5.server.prd.system.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.time.LocalDate;

/**
 * 财务期间
 *
 * @author likunpeng
 * @date 2023-04-12
 */
@Entity
@Table(name = "prd_system_fin_period", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "prd_system_fin_period", comment = "财务期间")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdSystemFinPeriodDO extends BaseModel implements Serializable  {
    /** 财务年度ID */
    @Comment("财务年度ID")
    @Column()
    private Long finYearId;
    /** 财务期间 */
    @Comment("财务期间")
    @Column()
    private Integer finPeriod;
    /** 期间名称 */
    @Comment("期间名称")
    @Column()
    private String periodName;
    /** 期间状态 */
    @Comment("期间状态")
    @Column()
    private String periodStatus;
    /** 开始日期 */
    @Comment("开始日期")
    @Column()
    private LocalDate beginDate;
    /** 结束日期 */
    @Comment("结束日期")
    @Column()
    private LocalDate endDate;
    /** 4.0财务期间id */
    @Comment("4.0财务期间id")
    @Column()
    private Long finPeriodIdV4;

    public void copy(PrdSystemFinPeriodDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
