package com.elitesland.tw.tw5.server.prd.work.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RestStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.my.entity.OvertimeApplicationDO;
import com.elitesland.tw.tw5.server.prd.my.entity.QOvertimeApplicationDO;
import com.elitesland.tw.tw5.server.prd.my.query.OvertimeApplicationQuery;
import com.elitesland.tw.tw5.server.prd.my.vo.ApproveLeaderDTO;
import com.elitesland.tw.tw5.server.prd.my.vo.OvertimeApplicationVO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectMembersDO;
import com.elitesland.tw.tw5.server.prd.task.entity.QTaskInfoDO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @BelongsProject: tw-svr5
 * @BelongsPackage: com.elitesland.tw.tw5.server.prd.work.dao
 * @Author: dragonHuang
 * @CreateTime: 2023-08-30  14:40
 * @Description: TODO
 * @Version: 1.0
 */

@Repository
@RequiredArgsConstructor
public class OvertimeApplicationDAO {

    private final JPAQueryFactory jpaQueryFactory;

    private final QPrdOrgEmployeeDO prdOrgEmployeeDo = QPrdOrgEmployeeDO.prdOrgEmployeeDO;
    private final QPrdOrgEmployeeRefDO prdOrgEmployeeRefDo = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;
    private final QPrdOrgOrganizationDO prdOrgOrganizationDo = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    // private final QTaskDO taskDO = QTaskDO.taskDO;
    private final QTaskInfoDO taskDO = QTaskInfoDO.taskInfoDO;
    // private final QProjShDO projShDo = QProjShDO.projShDO;
    // private final QProjectDO projectDo = QProjectDO.projectDO;
    private final QPmsProjectDO projectDo = QPmsProjectDO.pmsProjectDO;
    private final QPmsProjectMembersDO qPmsProjectMembersDO = QPmsProjectMembersDO.pmsProjectMembersDO;

    private final QOvertimeApplicationDO overtimeApplicationDo = QOvertimeApplicationDO.overtimeApplicationDO;


    public ApproveLeaderDTO getApproveLeader(OvertimeApplicationVO overtimeApplicationVO) {

        JPAQuery<ApproveLeaderDTO> jpaQuery = jpaQueryFactory.select(Projections.bean(ApproveLeaderDTO .class,
                prdOrgEmployeeDo.userId,
                prdOrgEmployeeRefDo.parentId.as("parentUserId"),
                prdOrgOrganizationDo.manageId.as("manageUserId"),
                taskDO.disterResId.as("disterUserId"),
                projectDo.pmResId.as("pmUserId")
        )).from(prdOrgEmployeeDo).leftJoin(prdOrgEmployeeRefDo).on(prdOrgEmployeeDo.userId.eq(prdOrgEmployeeRefDo.userId).and(prdOrgEmployeeRefDo.isDefault.eq(0)).and(prdOrgEmployeeRefDo.deleteFlag.eq(0)))
                .leftJoin(prdOrgOrganizationDo).on(prdOrgEmployeeRefDo.orgId.eq(prdOrgOrganizationDo.id))
                .leftJoin(qPmsProjectMembersDO).on(qPmsProjectMembersDO.resId.eq(prdOrgEmployeeDo.userId))
                .leftJoin(taskDO).on(taskDO.taskResId.eq(prdOrgEmployeeDo.userId))
                .leftJoin(projectDo).on(projectDo.id.eq(qPmsProjectMembersDO.projId).and(projectDo.projStatus.eq("ACTIVE")));

                if(overtimeApplicationVO.getProjectId()!=0){
                    jpaQuery.where(projectDo.id.eq(overtimeApplicationVO.getProjectId()));
                }
                if(overtimeApplicationVO.getTaskId() != null){
                    jpaQuery.where(taskDO.id.eq(overtimeApplicationVO.getTaskId()));
                }
                jpaQuery.where(prdOrgEmployeeDo.userId.eq(overtimeApplicationVO.getUserId()));
        return jpaQuery.fetchFirst();
    }

    @Transactional
    public void updateById(OvertimeApplicationDO overtimeApplicationDO) {
        jpaQueryFactory.update(overtimeApplicationDo)
                .set(overtimeApplicationDo.processInstanceId, overtimeApplicationDO.getProcessInstanceId())
                .where(overtimeApplicationDo.id.eq(overtimeApplicationDO.getId()))
                .execute();
    }

    @Transactional
    public void updateStatusById(String approveStatus, Long id) {
        jpaQueryFactory.update(overtimeApplicationDo)
                .set(overtimeApplicationDo.approveStatus, approveStatus)
                .where(overtimeApplicationDo.id.eq(id))
                .execute();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<OvertimeApplicationVO> queryPaging(OvertimeApplicationQuery query) {
        JPAQuery<OvertimeApplicationVO> jpaQuery = getJpaQueryWhere();
        QueryResults<OvertimeApplicationVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<OvertimeApplicationVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    private JPAQuery<OvertimeApplicationVO> getJpaQueryWhere() {
        return jpaQueryFactory.select(Projections.bean(OvertimeApplicationVO.class,
                overtimeApplicationDo.id,
                overtimeApplicationDo.projectId,
                projectDo.projName.as("projectName"),
                overtimeApplicationDo.userId,
                prdOrgEmployeeDo.employeeName.as("userName"),
                overtimeApplicationDo.overtimeWorkDate,
                overtimeApplicationDo.overtimeWorkHour,
                overtimeApplicationDo.overtimeWorkDesc,
                overtimeApplicationDo.approveStatus,
                overtimeApplicationDo.restDate,
                overtimeApplicationDo.restStatus)).
                from(overtimeApplicationDo).
                leftJoin(projectDo).on(projectDo.id.eq(overtimeApplicationDo.projectId).and(projectDo.projStatus.eq("ACTIVE"))).
                leftJoin(prdOrgEmployeeDo).on(prdOrgEmployeeDo.userId.eq(overtimeApplicationDo.userId));
    }

    public List<OvertimeApplicationVO> findAvailableOvertimeApplications() {
        JPAQuery<OvertimeApplicationVO> jpaQuery = getJpaQueryWhere();
        jpaQuery.where(overtimeApplicationDo.userId.eq(GlobalUtil.getLoginUserId())).
                where(overtimeApplicationDo.approveStatus.eq(WorkFlowStatusEnum.APPROVED.getCode())).
                where(overtimeApplicationDo.restStatus.in(RestStatusEnum.CREATE.getCode(), RestStatusEnum.REJECTED.getCode()));
        return jpaQuery.fetch();
    }

    public void updateRestStatusById(OvertimeApplicationDO overtimeApplicationDO) {
        jpaQueryFactory.update(overtimeApplicationDo)
                .set(overtimeApplicationDo.restStatus, overtimeApplicationDO.getRestStatus())
                .set(overtimeApplicationDo.restDate, overtimeApplicationDO.getRestDate())
                .where(overtimeApplicationDo.id.eq(overtimeApplicationDO.getId()))
                .execute();
    }
}
