package com.elitesland.tw.tw5.server.prd.workflow;

import com.alibaba.fastjson.JSON;
import com.elitesland.tw.tw5.api.common.change.service.PrdSystemBusinessChangeService;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActActivityPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmActActivityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActActivityVO;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmActActivityConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmActActivityDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

/**
 * @author yangzhibin
 * @date 2022/12/16
 */
@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "MARKET_ACTIVITY_C" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class MarketActivityCWorkflowCallBackController implements WorkflowCallBack {

    private final CrmActActivityService actActivityService;
    private final CrmActActivityDAO actActivityDAO;
    private final PrdSystemBusinessChangeService changeService;

    /**
     * 动态指定任务负责人
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("动态指定任务负责人参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     *
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     *
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        log.info("流程状态变化回调参数:{}", payload);
        CrmActActivityPayload activityPayload = new CrmActActivityPayload();
        activityPayload.setId(Long.parseLong(businessKey));
        //根据业务key查询当前业务对象
        CrmActActivityVO crmActActivityVO = actActivityService.queryByKey(Long.valueOf(businessKey));
        if (crmActActivityVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"新建",流程状态改为未提交
//                    activityPayload.setProjectStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    activityPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    //更新项目状态
                    actActivityService.updateWorkFlowStatus(crmActActivityVO.getProjectId(), WorkFlowStatusEnum.APPROVED_WORK.getCode(), "");
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                case INVALID://先删除流程再删除单据
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
//                    activityPayload.setProjectStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    activityPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    //删除当前版本草稿状态的changeLog
                    changeService.deleteCurrentVersionLog(ChangeTypeEnum.MARKET_ACTIVITY.getCode(), crmActActivityVO.getId().toString());
                    //更新项目状态
                    actActivityService.updateWorkFlowStatus(crmActActivityVO.getProjectId(), WorkFlowStatusEnum.APPROVED_WORK.getCode(), "");
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
//                    activityPayload.setProjectStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    activityPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    //更新项目状态
                    actActivityService.updateWorkFlowStatus(crmActActivityVO.getProjectId(), WorkFlowStatusEnum.APPROVED_WORK.getCode(), "");
                    break;
                case APPROVED:
                    //一般情况将单据状态变成"激活"
//                    activityPayload.setProjectStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    activityPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    activityPayload.setApprovedTime(LocalDateTime.now());
                    //更新项目状态
                    actActivityService.updateWorkFlowStatus(crmActActivityVO.getProjectId(), WorkFlowStatusEnum.APPROVED_WORK.getCode(), "");
                    //激活当前版本草稿状态的所有changeLog,合并当前及上一个版本
                    Map<String, Object> stringObjectMap = changeService.activeCurrentVersionLog(ChangeTypeEnum.MARKET_ACTIVITY.getCode(), crmActActivityVO.getId().toString());
                    CrmActActivityVO newActivity = JSON.parseObject(stringObjectMap.toString(), CrmActActivityVO.class);
                    CrmActActivityPayload newActivityPayload = CrmActActivityConvert.INSTANCE.toPayload(newActivity);
                    newActivityPayload.setDoSave(true);
                    //更新关联的市场活动操作
                    actActivityService.update(newActivityPayload);
                    break;
                case APPROVING:
                    activityPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    activityPayload.setProjectStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
            }
            actActivityDAO.updateActivityByKeyDynamic(activityPayload);
        }
        return WorkflowResult.success(null);
    }

}
