package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessCustomerInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectPayload;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.salecon.payload.SaleConContractPayload;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConExecConditionService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConExecConditionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConWorkTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerStageEnum;
import com.elitesland.tw.tw5.server.prd.salecon.dao.SaleConContractDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;

/**
 * 销售子合同激活流程
 *
 * @author likunpeng
 * @date 2023/5/5
 */
@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "SALE_CON_ACTIVE" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class SaleConActiveWorkflowCallBackController implements WorkflowCallBack {

    private final SaleConContractService saleConContractService;
    private final SaleConContractDAO saleConContractDAO;
    private final BusinessCustomerInfoService businessCustomerInfoService;
    private final BusinessPartnerService businessPartnerService;

    private final PmsProjectService pmsProjectService;
    private final SaleConExecConditionService saleConExecConditionService;
    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        return WorkflowResult.success(null);
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }


    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        Long id = Long.parseLong(payload.getBusinessKey());
        // 节点 商务负责人校验盖章
        final String bizManagerKey = "Activity_0mg79e2";
        // 节点 商务负责人预审
        final String bizManagerPreApproveKey = "Activity_0bde39j";

        // 节点 财务核定 迪博不需要合同预算
//        final String finCheck = "Activity_1l293u9";
//        if (finCheck.equals(payload.getTaskKey()) && !ObjectUtils.isEmpty(payload.getBusinessKey())) {
//            SaleConContractVO saleConContractVO = saleConContractService.queryByKey(Long.valueOf(payload.getBusinessKey()));
//            // }
//            // 合同预算流程发起时机调整：修改为财务核定后自动发起（目前为商务负责人预审后）需求来源：#8693
//            // if (finCheck.equals(payload.getTaskKey()) && !ObjectUtils.isEmpty(payload.getBusinessKey())) {
//            //  SaleConContractVO saleConContractVO = saleConContractService.queryByKey(Long.valueOf(payload.getBusinessKey()));
//            // 判断合同类型：子合同的工作类型=交付项目、运维项目、咨询业务项目、T&M项目发起预算流程，否则不发起
//            SaleConWorkTypeEnum saleConWorkTypeEnum = null;
//            if (SaleConWorkTypeEnum.TM.getCode().equals(saleConContractVO.getWorkType())) {
//                saleConWorkTypeEnum = SaleConWorkTypeEnum.TM;
//            } else {
//                saleConWorkTypeEnum = SaleConWorkTypeEnum.valueOf(saleConContractVO.getWorkType());
//            }
//            switch (saleConWorkTypeEnum) {
//                case DELIVERY:
//                case OPERATION:
//                case CONSULT:
//                case TM:
//                    log.info("开启合同预算流程.........");
//                    //开启合同预算流程
//                    SaleConExecConditionVO saleConExecConditionVO = saleConExecConditionService.queryByContractId(id);
//                    saleConExecConditionService.saleConExecConditionApply(saleConExecConditionVO, saleConContractVO);
//                    log.info("合同预算流程创建成功.........");
//                    break;
//                default:
//            }
//
//        }
        //当商务负责人审批通过的时候 就直接会激活 不需要等到行政归档
        if (bizManagerKey.equals(payload.getTaskKey()) && !ObjectUtils.isEmpty(payload.getBusinessKey())) {
            SaleConContractPayload saleConContractPayload = new SaleConContractPayload();
            //一般情况将单据状态变成"激活"

            saleConContractPayload.setId(id);
            saleConContractPayload.setStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
            saleConContractPayload.setProcInstStatus(ProcInstStatus.APPROVED);
            saleConContractPayload.setAcitveDate(LocalDate.now());
            saleConContractPayload.setApprovedTime(LocalDateTime.now());
            saleConContractDAO.updateByKeyDynamic(saleConContractPayload);

            // 平台合同类型 为 无合同入场虚拟合同（NO_CONTRACT_VIRTUAL_CONTRACT）	 合同状态【待激活】 ，激活流程走完，
            // 平台合同类型自动改为【平台内合同（INTERNAL）】，
            // 同步更新对应主合同的平台合同类型为【平台内合同（INTERNAL）】
            saleConContractService.activeVirtualContractCompleted(id);

            //子合同激活的时候将客户阶段从潜在客户置为成交客户
            SaleConContractVO saleConContractVO = saleConContractService.queryByKey(Long.valueOf(payload.getBusinessKey()));
            Long custId = saleConContractVO.getCustId();
            if (custId != null) {
                BusinessPartnerVO businessPartnerVO = businessPartnerService.queryCustomerByBookId(custId);
                if (businessPartnerVO != null) {
                    BusinessCustomerInfoPayload businessCustomerInfoPayload = new BusinessCustomerInfoPayload();
                    businessCustomerInfoPayload.setId(businessPartnerVO.getBusinessCustomerInfoId());
                    businessCustomerInfoPayload.setCustomerStage(BusinessPartnerStageEnum.OFFICIAL.getCode());
                    businessCustomerInfoService.update(businessCustomerInfoPayload);
                }
            }
            // 判断合同类型：工作类型=纯贸易项目、自主研发（软件）时自动创建项目
            SaleConWorkTypeEnum saleConWorkTypeEnum = null;
            if (SaleConWorkTypeEnum.TM.getCode().equals(saleConContractVO.getWorkType())) {
                saleConWorkTypeEnum = SaleConWorkTypeEnum.TM;
            } else {
                saleConWorkTypeEnum = SaleConWorkTypeEnum.valueOf(saleConContractVO.getWorkType());
            }
            switch (saleConWorkTypeEnum) {
                case PURETRADE:
                case INDEPENDENT:
                    // 自动创建项目Pm
                    PmsProjectPayload pmsProjectPayload = pmsProjectService.autoCreateProject(saleConContractVO);
                    log.info("项目组装完成----------------");
                    log.info("pmsProjectPayload:::::::" + pmsProjectPayload.toString());
                    pmsProjectService.insertOrUpdate(pmsProjectPayload);
                    log.info("项目插入成功-----------------");
                    break;
                default:
            }
        }
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        SaleConContractPayload saleConContractPayload = new SaleConContractPayload();
        saleConContractPayload.setId(Long.parseLong(businessKey));
        //根据业务key查询当前业务对象
        SaleConContractVO saleConContractVO = saleConContractService.queryByKey(Long.valueOf(businessKey));
        WorkFlowStatusEnum initStatus = saleConContractVO.getPlatType().equals(SaleConEnum.NO_CONTRACT_VIRTUAL_CONTRACT.getCode()) ? WorkFlowStatusEnum.ACTIVE_WAITING : WorkFlowStatusEnum.CREATE_WORK;
        if (saleConContractVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //将单据状态改为“新建”，无合同入场虚拟合同改为待激活
                    saleConContractPayload.setStatus(initStatus.getCode());
                    saleConContractPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    //将单据状态改为“新建”，无合同入场虚拟合同改为待激活
                    saleConContractPayload.setStatus(initStatus.getCode());
                    saleConContractPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                case INVALID://先删除流程再删除单据
                    //将单据状态改为“新建”，无合同入场虚拟合同改为待激活
                    saleConContractPayload.setStatus(initStatus.getCode());
                    //saleConContractPayload.setDeleteFlag(1);
                    saleConContractPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    initStatus = saleConContractVO.getPlatType().equals(SaleConEnum.NO_CONTRACT_VIRTUAL_CONTRACT.getCode()) ? WorkFlowStatusEnum.ACTIVE_WAITING : WorkFlowStatusEnum.REJECTED_WORK;
                    //将单据状态变为新建状态
                    saleConContractPayload.setStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
                    saleConContractPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                case APPROVED:
                    //一般情况将单据状态变成"激活"
                    //将单据状态变成“作废”
                    /*saleConContractPayload.setStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    saleConContractPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    saleConContractPayload.setAcitveDate(LocalDate.now());
                    saleConContractPayload.setApprovedTime(LocalDateTime.now());*/
//                    pmsProjectService.noContractActivity(Long.valueOf(businessKey));
                    break;
                case APPROVING:
                    saleConContractPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    saleConContractPayload.setStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
            }
            saleConContractDAO.updateByKeyDynamic(saleConContractPayload);
        }
        return WorkflowResult.success(null);
    }
}
