package com.elitesland.tw.tw5.server.provider.event;

import org.springframework.context.ApplicationEvent;
import org.springframework.util.Assert;

import java.io.Serial;

/**
 * 事件的父类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/14
 */
public abstract class BaseEvent extends ApplicationEvent {
    @Serial
    private static final long serialVersionUID = -144637924187899067L;

    /**
     * 事件类型
     */
    private final Event event;

    protected BaseEvent(Object source, Event event) {
        super(source);

        Assert.notNull(event, "事件类型不能为空");
        this.event = event;
    }

    public Event getEvent() {
        return event;
    }
}
