package com.elitesland.tw.tw5.server.common.crontask.payload;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 费用确认单明细
 */
@Data
public class TwChannelCostConDEntity {

    /**
     * id
     */
    private Long id;

    /**
     * 渠道费用确认单ID
     */
    private Long channelCostConId;

    /**
     * 序号
     */
    private String sortNo;

    /**
     * 工作类型
     */
    private String workType;


    /**
     * 具体理由
     */
    private String reason;

    /**
     * 伙伴类型
     */
    private String coopType;


    /**
     * 合作方
     */
    private String channelCostRem;


    /**
     * 基于
     */
    private String base;
    /**
     * 比例
     */
    private Long proportion;

    /**
     * 金额
     */
    private BigDecimal amt;

    /**
     * 税费率
     */
    private Long taxRate;

    /**
     * 税费
     */
    private BigDecimal taxCost;

    /**
     * 费用承担方
     */
    private String reimExp;


    /**
     * 净支付额
     */
    private  BigDecimal netPay;

    /**
     * 具体支付方式
     */
    private String salaryMethod;


    /**
     * 线下合同&沟通签署状态
     */
    private String contractStatus;

    /**
     * 联系人姓名
     */
    private String contactName;

    /**
     * 联系电话
     */
    private String contactPhone;

    /**
     * 关联单据类型
     */
    private String docType;

    /**
     * 关联单据号
     */
    private String documentNumber;

    /**
     * 明细状态
     */
    private String channelCostConDStatus;


    /**
     * 父明细ID
     */
    private Long minChannelCostConId;

    /**
     * children 子数据
     */
    private List<TwChannelCostConDEntity> children;
    /**
     * 收款节点
     */
    private Long receivingNode;

    /**
     * 申请状态 - T_BUSITRIP_APPLY.APPLY_STATUS
     */
    private String applyStatus;

    /**
     * 审批状态
     */
    private String apprStatus;


    /**
     * 费用确认单明细ID_v5
     */
    private Long costConDIdV5;

    /**
     * 删除标志
     */
    private Boolean delFlag;

    /**
     * 外包费用明细4.0id
     */
    private Long costCondIdv4;

}
