package com.elitesland.tw.tw5.server.common.funConfig.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 易稻壳yeedoc通用文档类型配置规则表
 *
 * @author duwh
 * @date 2023-12-07
 */
@Entity
@Table(name = "prd_business_doc_type_config_rule", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "prd_business_doc_type_config_rule", comment = "易稻壳yeedoc通用文档类型配置规则表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessDocTypeConfigRuleDO extends BaseModel implements Serializable  {
    /** 文档类型配置主键 prd_business_doc_type_config.id */
    @Comment("文档类型配置主键 prd_business_doc_type_config.id")
    @Column()
    private Long configId;
    /** 条件 =、 in、not in、..... */
    @Comment("条件 =、 in、not in、.....")
    @Column()
    private String conditions;
    /** 条件值 */
    @Comment("条件值")
    @Column(columnDefinition = "varchar(1000)")
    private String conditionsValue;
    /** 易道壳itemId */
    @Comment("易道壳itemId")
    @Column()
    private String itemId;
    /** 易稻壳libraryId */
    @Comment("易稻壳libraryId")
    @Column()
    private String libraryId;
    /** 易稻壳libraryId翻译 */
    @Comment("易稻壳libraryId翻译")
    @Column()
    private String libraryName;
    /** 易稻壳库下的文件路径 /A/B/C */
    @Comment("易稻壳库下的文件路径 /A/B/C")
    @Column(columnDefinition = "varchar(1000)")
    private String path;
    /** 文档类型名称（冗余）prd_business_doc_type_config.name */
    @Comment("文档类型名称（冗余）prd_business_doc_type_config.name")
    @Column()
    private String configName;
    /** 文档类型编码（冗余）prd_business_doc_type_config.code */
    @Comment("文档类型编码（冗余）prd_business_doc_type_config.code")
    @Column()
    private String configCode;
    /** 功能主键(冗余) prd_system_function.id */
    @Comment("功能主键(冗余) prd_system_function.id")
    @Column()
    private Long functionId;
    /** 业务对象主键(冗余) prd_business_table.id */
    @Comment("业务对象主键(冗余) prd_business_table.id")
    @Column()
    private Long tableId;
    /** 数据库表名(冗余) prd_business_table.table_name */
    @Comment("数据库表名(冗余) prd_business_table.table_name")
    @Column()
    private String tableName;
    /** 业务对象字段明细主键(冗余) prd_business_table_fields.id */
    @Comment("业务对象字段明细主键(冗余) prd_business_table_fields.id")
    @Column()
    private Long fieldId;
    /** 字段展示名称(冗余) prd_business_table_fields.show_name */
    @Comment("字段展示名称(冗余) prd_business_table_fields.show_name")
    @Column()
    private String fieldShowName;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;

    public void copy(BusinessDocTypeConfigRuleDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
