package com.elitesland.tw.tw5.server.common.util;

import com.alibaba.fastjson.JSON;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.server.common.TwException;
import org.springframework.util.ObjectUtils;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataUtil {

    public static final int[] constellationEdgeDay = {20, 19, 21, 20, 21, 22, 23, 23, 23, 24, 23, 22};

    public static final String[] CONSTELLATION_ARR = {"摩羯座", "水瓶座 ", "双鱼座 ", "白羊座 ", "金牛座 ", "双子座 ", "巨蟹座 ", " 狮子座 ", "处女座 ",
            " 天秤座 ", "天蝎座", "射手座", "魔羯座"};

    /**
     * 根据出生日期计算星座，年龄，月日
     *
     * @param date
     * @return
     */
    public static Map<String, String> getConstellation(LocalDate date) {
        Map<String, String> map = new HashMap<>();
        if (ObjectUtils.isEmpty(date)) {
            return map;
        }
        int month = date.getMonthValue();
        int day = date.getDayOfMonth();
        String csonstel = day < constellationEdgeDay[month - 1] ? CONSTELLATION_ARR[month - 1] : CONSTELLATION_ARR[month];
        String dayOfMonth = month + "月" + day + "日";
        String age = (LocalDate.now().getYear() - date.getYear()) + "岁";
        map.put("csonstel", csonstel);
        map.put("dayOfMonth", dayOfMonth);
        map.put("age", age);
        return map;

    }

    /**
     * 校验数据长度
     *
     * @param data
     * @param length
     */
    public static void checkDataLength(Object data, Integer length) {
        if (length == null) {
            length = 255;
        }
        if (data != null) {
            if (isPrimitiveType(data)) {
                //是基础类型或字符串
                if (data.toString().length() > length) {
                    throw TwException.error("", "字段长度超过[" + length + "],请核验！");
                }
            } else if (data instanceof com.elitescloud.boot.model.entity.BaseModel || data instanceof TwCommonPayload) {
                //判断DO或Payload
                Map<String, Object> dataMap = JSON.parseObject(JSON.toJSONString(data), Map.class);
                for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                    checkDataLength(entry.getValue(), length);
                }
            } else if (data instanceof Map) {
                Map<String, Object> dataMap = (Map<String, Object>) data;
                for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                    checkDataLength(entry.getValue(), length);
                }
            } else if (data instanceof List) {
                List<Object> dataList = (List<Object>) data;
                Integer finalLength = length;
                dataList.forEach(dataValue -> {
                    checkDataLength(dataValue, finalLength);
                });
            }

        }
    }

    public static boolean isPrimitiveType(Object obj) {
        return obj instanceof Byte ||
                obj instanceof Short ||
                obj instanceof Integer ||
                obj instanceof Long ||
                obj instanceof Float ||
                obj instanceof Double ||
                obj instanceof Boolean ||
                obj instanceof String ||
                obj instanceof Character;
    }

}
