package com.elitesland.tw.tw5.server.common.workFlow;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@RestController
@RequestMapping("/api/workflow")
public class WorkflowController {

    @Autowired
    private Map<String, CommonWorkflowEvent> workflowEventMap;
    @Autowired
    private Map<String, CommonWorkflowCheck> workflowCheckMap;

    private final List<EventInfo> eventList = new ArrayList<>();
    private final List<CheckInfo> checkList = new ArrayList<>();

    @PostConstruct
    private void initList() {
        workflowEventMap.forEach((key, value) -> {
            TwWorkflowEventAnnotation annotation = value.getClass().getAnnotation(TwWorkflowEventAnnotation.class);
            eventList.add(new EventInfo(
                    annotation.name(),
                    annotation.code(),
                    annotation.scope(),
                    annotation.tableName(),
                    annotation.params(),
                    annotation.description(),
                    annotation.enabled()
            ));
        });

        workflowCheckMap.forEach((key, value) -> {
            TwWorkflowCheckAnnotation annotation = value.getClass().getAnnotation(TwWorkflowCheckAnnotation.class);
            checkList.add(new CheckInfo(
                    annotation.name(),
                    annotation.code(),
                    annotation.scope(),
                    annotation.tableName(),
                    annotation.params(),
                    annotation.description(),
                    annotation.enabled()
            ));
        });
    }

    @GetMapping("/event/list")
    public TwOutputUtil eventList(String scope, String  tableName, boolean  allFlag) {
        List<EventInfo> result = eventList.stream().filter(eventInfo -> {
            boolean bool = true;
            if (scope != null && !scope.equals(eventInfo.getScope())) {
                bool = false;
            }
            if (tableName != null && !tableName.equals(eventInfo.getTableName())) {
                bool = false;
            }
            if(!allFlag && !eventInfo.enabled){
                bool = false;
            }
            return bool;
        }).collect(Collectors.toList());

        return TwOutputUtil.ok(result);
    }

    @GetMapping("/check/list")
    public TwOutputUtil checkList(String scope, String  tableName, boolean  allFlag) {
        List<CheckInfo> result = checkList.stream().filter(eventInfo -> {
            boolean bool = true;
            if (scope != null && !scope.equals(eventInfo.getScope())) {
                bool = false;
            }
            if (tableName != null && !tableName.equals(eventInfo.getTableName())) {
                bool = false;
            }
            if(!eventInfo.enabled){
                bool = false;
            }
            return bool;
        }).collect(Collectors.toList());

        return TwOutputUtil.ok(result);
    }

    @Getter
    // 辅助类，用于存储事件信息
    public static class EventInfo {
        private final String name;
        private final String code;
        private final String scope;
        private final String tableName;
        private final String params;
        private final String description;
        private final boolean enabled;

        public EventInfo(String name, String code, String scope, String tableName, String params, String description, boolean enabled) {
            this.name = name;
            this.code = code;
            this.scope = scope;
            this.tableName = tableName;
            this.params = params;
            this.description = description;
            this.enabled = enabled;
        }

    }

    @Getter
    // 辅助类，用于存储事件信息
    public static class CheckInfo {
        private final String name;
        private final String code;
        private final String scope;
        private final String tableName;
        private final String params;
        private final String description;
        private final boolean enabled;

        public CheckInfo(String name, String code, String scope, String tableName, String params, String description, boolean enabled) {
            this.name = name;
            this.code = code;
            this.scope = scope;
            this.tableName = tableName;
            this.params = params;
            this.description = description;
            this.enabled = enabled;
        }

    }

}
