package com.elitesland.tw.tw5.server.prd.ab.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.ab.query.PrdUserAbQuery;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdUserAbVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.ab.entity.QPrdAbContactsDO;
import com.elitesland.tw.tw5.server.prd.org.entity.*;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zoey
 * @Description:通讯录
 * @date 2023/8/7 - 23:30
 */
@Repository
@RequiredArgsConstructor
public class PrdUserAbDAO {
    private final JPAQueryFactory jpaQueryFactory;
//    private final QPrdAbDO qdo = QPrdAbDO.prdAbDO;
    private final QPrdOrgEmployeeDO qdo = QPrdOrgEmployeeDO.prdOrgEmployeeDO;
    private final QPrdOrgEmployeeRefDO qdoEmployeeRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;
    private final QPrdAbContactsDO qdoAbContact = QPrdAbContactsDO.prdAbContactsDO;
    private final QPrdOrgPersonDO qdoPersonDO = QPrdOrgPersonDO.prdOrgPersonDO;
    private final QPrdOrgOrganizationDO qdoOrgainzation = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QPrdOrgEmployeeEqvaRatioDO qdoEmployeeEqvaRatio = QPrdOrgEmployeeEqvaRatioDO.prdOrgEmployeeEqvaRatioDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdUserAbVO> getJpaQuerySelect() {
        JPAQuery<PrdUserAbVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdUserAbVO.class,
                qdo.id,
                qdo.sortIndex,
                qdo.userId,
                qdo.employeeName,
                qdo.employeeNo,
                qdoEmployeeRef.orgId.as("baseOrgId"),
                qdo.extString5.as("baseCity"),
                qdoPersonDO.mobile,
                qdoPersonDO.email,
//                qdoEmployeeEqvaRatio.eqvaRatio,
                qdoPersonDO.id.as("personId"),
                qdoPersonDO.personName,
                qdoPersonDO.sex.as("gender")
//                qdoAbContact.contactsType.as("contactType")
        )).from(qdo).leftJoin(qdoPersonDO).on(qdo.personId.longValue().eq(qdoPersonDO.id.longValue()).and(qdoPersonDO.deleteFlag.eq(0)))
                .leftJoin(qdoEmployeeRef).on(qdo.userId.eq(qdoEmployeeRef.userId).and(qdoEmployeeRef.deleteFlag.eq(0)).and(qdoEmployeeRef.isDefault.eq(0)));
//                .leftJoin(qdoOrgainzation).on(qdoEmployeeRef.orgId.eq(qdoOrgainzation.id).and(qdoOrgainzation.deleteFlag.eq(0)))
//                .leftJoin(qdo).on(qdo.userId.eq(qdoEmployee.userId).and(qdo.deleteFlag.eq(0)));
//                .leftJoin(qdoEmployeeEqvaRatio).on(qdoEmployeeEqvaRatio.userId.eq(qdoEmployee.userId).and(qdoEmployeeEqvaRatio.deleteFlag.eq(0)).and(qdoEmployeeEqvaRatio.startDate.before(LocalDate.now()))).limit(1)
//                .leftJoin(qdoAbContact).on(qdo.id.eq(qdoAbContact.bookId).and(qdoAbContact.deleteFlag.eq(0)));
        return jpaQuery;
    }


    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PrdUserAbVO> queryPaging(PrdUserAbQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<PrdUserAbVO> jpaQuery = getJpaQueryWhere(query);
        List<PrdUserAbVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PrdUserAbVO>builder().records(result).total(total).build();
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PrdUserAbVO> getJpaQueryWhere(PrdUserAbQuery query) {
        JPAQuery<PrdUserAbVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        List<OrderItem> orderse = new ArrayList<>();
        orderse.add(OrderItem.asc("sortIndex"));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, orderse));
        // group
        jpaQuery.groupBy(qdo.id);
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(PrdUserAbQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.id.count())
                .from(qdo).leftJoin(qdoPersonDO).on(qdo.personId.longValue().eq(qdoPersonDO.id.longValue()).and(qdoPersonDO.deleteFlag.eq(0)))
                .leftJoin(qdoEmployeeRef).on(qdo.userId.eq(qdoEmployeeRef.userId).and(qdoEmployeeRef.deleteFlag.eq(0)).and(qdoEmployeeRef.isDefault.eq(0))).limit(1);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }


    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(PrdUserAbQuery query){
        List<Predicate> list = new ArrayList<>();

        list.add(qdo.resourceStatus.ne("6"));
        list.add(qdo.hrStatus.eq("ACTIVE"));

        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /**
         * 姓名 模糊
         */
        if (!ObjectUtils.isEmpty(query.getEmployeeName())) {
            list.add(qdo.employeeName.like(SqlUtil.toSqlLikeString(query.getEmployeeName())));
        }
        /**
         * 工号
         */
        if (!ObjectUtils.isEmpty(query.getEmployeeNo())) {
            list.add(qdo.employeeNo.like(SqlUtil.toSqlLikeString(query.getEmployeeNo())));
        }
        /**
         * 所属组织
         */
        if (!ObjectUtils.isEmpty(query.getBaseOrgId())) {
            list.add(qdoEmployeeRef.orgId.eq(query.getBaseOrgId()));
        }
        /**
         * 主服务地
         */
        if (!ObjectUtils.isEmpty(query.getBaseCity())) {
            list.add(qdo.extString5.eq(query.getBaseCity()));
        }
        /**
         * 手机号码
         */
        if (!ObjectUtils.isEmpty(query.getMobile())) {
            list.add(qdoPersonDO.mobile.like(SqlUtil.toSqlLikeString(query.getMobile())));
        }
        /**
         * 公司邮箱
         */
        if (!ObjectUtils.isEmpty(query.getEmail())) {
            list.add(qdoPersonDO.email.like(SqlUtil.toSqlLikeString(query.getEmail())));
        }
        return ExpressionUtils.allOf(list);
    }
}
