package com.elitesland.tw.tw5.server.prd.ab.service;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbOrCompanyPayload;
import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbPayload;
import com.elitesland.tw.tw5.api.prd.ab.query.PrdUserAbQuery;
import com.elitesland.tw.tw5.api.prd.ab.service.PrdAbService;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.ab.convert.PrdAbConvert;
import com.elitesland.tw.tw5.server.prd.ab.dao.PrdAbDAO;
import com.elitesland.tw.tw5.server.prd.ab.entity.PrdAbAddressDO;
import com.elitesland.tw.tw5.server.prd.ab.entity.PrdAbDO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgCompanyDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * @Author carl.wang
 * @Description 地址簿管理
 * @Date 20220527
 **/
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdAbServiceImpl implements PrdAbService {
    private final CacheUtil cacheUtil;
    private final PrdAbDAO dao;

    //    // @DubboReference(version = "${provider.service.version}")
    //private SysNumberRuleService numberRuleService;

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public PrdAbVO saveAbOrCompany(PrdAbOrCompanyPayload payload) {
        PrdAbVO abVO = null;
        if (payload.getTaxNo() != null) {
            abVO = dao.queryCompanyByTaxNo(payload.getTaxNo());
        }
        boolean isNew = false;
        PrdAbDO abDO = null;
        //获取编号
        if (abVO == null) {
            abDO = PrdAbConvert.INSTANCE.toDo(payload);
            // abDO.setBookNo(code);
            abDO.setBookName(payload.getCompanyName());
            abDO = dao.save(abDO);
            isNew = true;
        }
        if (isNew) {
            PrdOrgCompanyDO companyDO = PrdAbConvert.INSTANCE.toCompanyDo(payload);
            companyDO.setCompanyNo(payload.getBookNo());
            companyDO.setBookId(abDO.getId());
            dao.saveCompany(companyDO);

            PrdAbAddressDO abAddressDO = new PrdAbAddressDO();
            abAddressDO.setBookId(abDO.getId());
            abAddressDO.setAddressEmail(payload.getCompanyEmail());
            abAddressDO.setAddressType(SystemDefaultEnum.DefaultAddressType.getCode());
            abAddressDO.setCity(payload.getCity());
            abAddressDO.setCityName(payload.getCityName());
            abAddressDO.setCountry("");
            abAddressDO.setDetailAddress(payload.getCompanyAddress());

            abAddressDO.setDistrict(payload.getDistrict());
            abAddressDO.setDistrictName(payload.getDistrictName());
            abAddressDO.setProvince(payload.getProvince());
            abAddressDO.setProvinceName(payload.getProvinceName());
            dao.saveAddress(abAddressDO);
        } else {
            if (!abVO.getRelateType().contains(payload.getRelateType())) {
                PrdAbPayload ab = new PrdAbPayload();
                ab.setId(abVO.getId());
                if ("".equals(abVO.getRelateType())) {
                    ab.setRelateType(payload.getRelateType());
                } else {
                    ab.setRelateType(abVO.getRelateType() + "," + payload.getRelateType());
                }
                dao.updateByKeyDynamic(ab);

            } else {
                throw TwException.error("", "该税号档案库已存在");
            }
        }
        return PrdAbConvert.INSTANCE.toVo(abDO);
    }

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public boolean updateAbOrCompany(PrdAbOrCompanyPayload payload) {
        PrdAbVO abVO = null;
        if (StringUtils.hasText(payload.getTaxNo())) {
            abVO = dao.queryCompanyByTaxNo(payload.getTaxNo());
        }
        if (abVO == null || abVO.getId().longValue() == payload.getId().longValue()) {
            if (StringUtils.hasText(payload.getCompanyName())) {
                PrdAbPayload ab = new PrdAbPayload();
                ab.setId(payload.getId());
                ab.setBookName(payload.getCompanyName());
                dao.updateByKeyDynamic(ab);
            }
            dao.updateCompanyByKey(payload);
            //dao.saveCompany(companyDO);
        } else {
            throw TwException.error("", "该税号档案库已存在");
        }
        return true;
    }

    @Override
    public Long update(PrdAbPayload payload) {
        return null;
    }

    @Override
    public List<PrdAbVO> queryList() {
        return null;
    }

    @Override
    public PrdAbVO queryByKey(Long key) {
        PrdAbVO vo = dao.queryByKey(key);
//        if (ObjectUtils.isEmpty(vo)) {
//            throw new BusinessException(ApiCode.NOT_FOUND, "数据不存在！");
//        }
//        Assert.notNull(vo.getId(), "不存在");
        return vo;
    }

    @Override
    public boolean deleteSoft(List<Long> keys) {
        return false;
    }
}
