package com.elitesland.tw.tw5.server.prd.acc.controller;


import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingLimitPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingLimitQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingLimitService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingLimitVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingOverdueVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

/**
 * 报销额度配置
 *
 * @author zoey
 * @date 2024-05-14
 */
@Api(tags = "报销额度配置")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/accReimSettingLimit")
@Slf4j
public class AccReimSettingLimitController {

private final AccReimSettingLimitService accReimSettingLimitService;

    /**
     * 报销额度配置-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("报销额度配置-新增")
    public TwOutputUtil<AccReimSettingLimitVO> insert(@RequestBody AccReimSettingLimitPayload payload){
         return TwOutputUtil.ok(accReimSettingLimitService.insert(payload));
    }

    /**
     * 报销额度配置-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("报销额度配置-更新")
    public TwOutputUtil<AccReimSettingLimitVO> update(@RequestBody AccReimSettingLimitPayload payload){
        return TwOutputUtil.ok(accReimSettingLimitService.update(payload));
    }

    /**
     * 报销额度配置-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("报销额度配置-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody AccReimSettingLimitPayload payload){
        return TwOutputUtil.ok(accReimSettingLimitService.updateByKeyDynamic(payload));
    }

    /**
     * 报销额度配置-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("报销额度配置-主键查询")
    public TwOutputUtil<AccReimSettingLimitVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(accReimSettingLimitService.queryByKey(key));
    }

    /**
     * 报销额度配置-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("报销额度配置-分页")
    public TwOutputUtil<PagingVO<AccReimSettingLimitVO>> paging(AccReimSettingLimitQuery query) {
        return TwOutputUtil.ok(accReimSettingLimitService.queryPaging(query));
    }

    /**
     * 报销额度配置-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("报销额度配置-查询列表")
    public TwOutputUtil<List<AccReimSettingLimitVO>> queryList(AccReimSettingLimitQuery query) {
        return TwOutputUtil.ok(accReimSettingLimitService.queryListDynamic(query));
    }

    /**
     * 报销额度配置-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("报销额度配置-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         accReimSettingLimitService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 报销额度配置-规则检查
     *
     * @param key 有效载荷
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/ruleCheck/{key}")
    @ApiOperation("报销额度配置-规则检查")
    public TwOutputUtil<AccReimSettingOverdueVO> ruleCheck(@PathVariable Long key, Long reimUserId, BigDecimal reimAmt,String expensePlaceGrade){
        return TwOutputUtil.ok(accReimSettingLimitService.ruleCheck(key,reimUserId,reimAmt,expensePlaceGrade));
    }

}

