package com.elitesland.tw.tw5.server.prd.acc.service;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.bank.feign.payload.PayListPayload;
import com.elitesland.tw.tw5.api.bank.feign.payload.PayPayload;
import com.elitesland.tw.tw5.api.bank.feign.service.TwBankPayService;
import com.elitesland.tw.tw5.api.bank.vo.BkPayDetailVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.*;
import com.elitesland.tw.tw5.api.prd.acc.query.*;
import com.elitesland.tw.tw5.api.prd.acc.service.*;
import com.elitesland.tw.tw5.api.prd.acc.vo.*;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmBusitripApplyPayload;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmFeeApplyPayload;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmTripTicketPayload;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmTripTicketQuery;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmBusitripApplyService;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmFeeApplyService;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmTripTicketService;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmBusitripApplyVO;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmFeeApplyVO;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmTripTicketVO;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetCommonService;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetService;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetVO;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.api.prd.inv.payload.InvInvoicePayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgOrganizationQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookAccountService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAccountVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.pay.payload.BkPayDetailRecordPayload;
import com.elitesland.tw.tw5.api.prd.pay.payload.TDocHistPayload;
import com.elitesland.tw.tw5.api.prd.pay.service.BkPayDetailRecordService;
import com.elitesland.tw.tw5.api.prd.pay.service.TDocHistService;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConEpibolyCostConDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConEpibolyCostConDQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConEpibolyCostConDService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConEpibolyCostConDVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFinPeriodQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemFinPeriodService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFinPeriodVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.GenerateSeqNumConstants;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.scheduling.TimeUtil;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.*;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimConvert;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimDetailConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimDAO;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimDetailDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimDetailDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.*;
import com.elitesland.tw.tw5.server.prd.inv.common.InvoiceReimStatusEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessInsideOrOutSideEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchasePaymentEnum;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.TaskInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.google.common.collect.Lists;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 费用报销挂你
 *
 * @author sunxw
 * @date 2023-11-22
 */
@Service
@RequiredArgsConstructor
@Slf4j
@RefreshScope
public class AccReimServiceImpl extends BaseServiceImpl implements AccReimService {
    private static String ACCOUNT_SUBJECT_NAME = "费用";
    private static String BANK_SUBJECT_NAME = "银行存款-招行";

//    //流程节点信息
//    enum FlowTaskKey {
//        //差旅/非差旅报销流程
//        Activity_0tuowqd("ACC_TRIP", "Activity_0tuowqd", "项目经理审批"),
//        Activity_0v6bxzy("ACC_TRIP", "Activity_0v6bxzy", "直属上级审批"),
//        ACC_TRIP_Activity_0s28lb1("ACC_TRIP", "Activity_0s28lb1", "费用承担BU负责人"),
//
//        //特殊费用报销流程
//        ACC_OTHERS_Activity_1luosio("ACC_OTHERS", "Activity_00usjsc", "直属上级审批"),
//        ;
//        /**
//         * 报销类型
//         */
//        private String type;
//        /**
//         * 节点code
//         */
//        private String code;
//        /**
//         * 节点描述
//         */
//        private String desc;
//
//        FlowTaskKey(String type, String code, String desc) {
//            this.type = type;
//            this.code = code;
//            this.desc = desc;
//        }
//    }

    @Value("${tw5.reim.limitAmt:1000}")
    private BigDecimal reimLimitAmt;
    @Value("${tw5.reim.businessLimitAmt:1000}")
    private BigDecimal businessLimitAmt;
    @Value("${tw5.reim.trip.breakfastScale:0.2}")
    private BigDecimal breakfastScale;
    @Value("${tw5.reim.trip.lunchScale:0.4}")
    private BigDecimal lunchScale;
    @Value("${tw5.reim.trip.dinnerScale:0.4}")
    private BigDecimal dinnerScale;
    @Value("${tw5.payment.platform:TW5}")
    private String platform;
    @Value("${tw5.payment.bank:CMB}")
    private String bank;
    @Value("${tw5.payment.secretKey:123456}")
    private String secretKey;
    @Value("${tw5.reim.taxAccCode:222100101}")
    private String taxAccCode;
    @Value("${tw5.workflow.saleOrgId}")
    private Long saleOrgId;

    private final AccReimRepo repo;
    private final AccReimDAO dao;
    private final AccReimDetailDAO detailDAO;
    private final BudgetService budgetService;
    private final CacheUtil cacheUtil;
    private final WorkflowUtil workflowUtil;
    private final PmsProjectService projectService;
    private final BuProjectService buProjectService;
    private final CrmOpportunityService opportunityService;
    private final AccReimPayBatchService reimPayBatchService;
    private final AccReimSourceConfigService reimSourceConfigService;
    private final PrdOrgEmployeeService employeeService;
    private final AccReimTripStdService accReimTripStdService;
    private final AccReimTaxService accReimTaxService;
    private final InvInvoiceService invInvoiceService;
    private final TransactionUtilService transactionUtilService;
    private final ExcelUtil excelUtil;
    private final AdmBusitripApplyService busitripApplyService;
    private final AdmFeeApplyService feeApplyService;
    private final AccReimSourceRecordService reimSourceRecordService;
    private final BudgetCommonService budgetCommonService;
    private final AdmTripTicketService admTripTicketService;
    private final ConEpibolyCostConDService conEpibolyCostConDService;
    private final TDocHistService tDocHistService;
    private final PrdSystemRoleService roleService;
    @Resource
    private TwBankPayService payService;
    private final BookAccountService bookAccountService;
    private final BusinessPartnerService businessPartnerService;
    private final BkPayDetailRecordService bkPayDetailRecordService;
    private final PrdOrgOrganizationService orgOrganizationService;
    private final PrdSystemFinPeriodService finPeriodService;
    private final AccReimRuleService reimRuleService;
    private final AccFinancialSubjectService accFinancialSubjectService;
    private final FileUtil fileUtil;
    private final AccReimSettingOverdueService accReimSettingOverdueService;
    private final AccReimSettingContinuousService accReimSettingContinuousService;
    private final AccReimSettingTitleService accReimSettingTitleService;
    private final AccReimSettingLimitService accReimSettingLimitService;
    private final AccReimDetailMealService accReimDetailMealService;

    @UdcNameClass
    @Override
    public PagingVO<AccReimVO> queryPaging(AccReimQuery query) {
        PagingVO<AccReimVO> paging = dao.queryPaging(query);
        if (!ObjectUtils.isEmpty(paging.getRecords())) {
            List<Long> masIds = paging.getRecords().stream().map(AccReimVO::getId).collect(Collectors.toList());
            List<AccReimDetailVO> detailVOList = detailDAO.queryByMasIds(masIds);
            Map<Long, List<AccReimDetailVO>> detailVosGroup = detailVOList.stream().collect(Collectors.groupingBy(AccReimDetailVO::getMasId));
            for (AccReimVO vo : paging.getRecords()) {
                String companyName = cacheUtil.getCompanyNameByBookId(vo.getExpenseCompany());
                vo.setExpenseCompanyName(companyName);
                List<AccReimDetailVO> detailVOS = detailVosGroup.get(vo.getId());
                if (ObjectUtils.isEmpty(detailVOS)) {
                    vo.setInvFlag(false);
                    continue;
                }
                //明细里只要有一个没票，即视为否
                for (AccReimDetailVO dtlVo : detailVOS) {
                    if (ObjectUtils.isEmpty(dtlVo.getInvoiceNum()) || dtlVo.getInvoiceNum() <= 0) {
                        vo.setInvFlag(false);
                        break;
                    }
                }
            }
        }
        return paging;
    }

    @Override
    public List<AccReimVO> queryListDynamic(AccReimQuery query) {
        List<AccReimVO> voList = dao.queryListDynamic(query);
        if (ObjectUtils.isEmpty(voList)) {
            log.warn("当前入参获取数据为空，入参信息 is {}", JSON.toJSONString(query));
            return new ArrayList<>();
        }
        List<Long> masIds = voList.stream().map(AccReimVO::getId).collect(Collectors.toList());
        List<AccReimDetailVO> detailVOList = detailDAO.queryByMasIds(masIds);
        Map<Long, List<AccReimDetailVO>> detailVosGroup = detailVOList.stream().collect(Collectors.groupingBy(AccReimDetailVO::getMasId));
        for (AccReimVO vo : voList) {
            String companyName = cacheUtil.getCompanyNameByBookId(vo.getExpenseCompany());
            vo.setExpenseCompanyName(companyName);
            List<AccReimDetailVO> detailVOS = detailVosGroup.get(vo.getId());
            if (ObjectUtils.isEmpty(detailVOS)) {
                vo.setInvFlag(false);
                continue;
            }
            vo.setDetails(detailVOS);
            //明细里只要有一个没票，即视为否
            for (AccReimDetailVO dtlVo : detailVOS) {
                if (ObjectUtils.isEmpty(dtlVo.getInvoiceNum()) || dtlVo.getInvoiceNum() <= 0) {
                    vo.setInvFlag(false);
                    break;
                }
            }
        }
        return voList;
    }

    @UdcNameClass
    @Override
    public AccReimVO queryByKey(Long key) {
        AccReimVO accReimVO = dao.queryByKey(key);
        PrdOrgEmployeeVO employeeVO = cacheUtil.getEmployee(accReimVO.getReimUserId());
        if (!ObjectUtils.isEmpty(employeeVO)) {
            if (!ObjectUtils.isEmpty(employeeVO.getExtString5())) {
                String baseCityName = cacheUtil.transferSystemSelection("org:employee:serviceaddr", employeeVO.getExtString5());
                accReimVO.setBaseCityName(baseCityName);
            }
            if (!ObjectUtils.isEmpty(employeeVO.getBookId())) {
                accReimVO.setBaseOuName(cacheUtil.getCompanyNameByBookId(employeeVO.getBookId()));
            }
            accReimVO.setResNo(employeeVO.getResNo());
        }
        String companyName = cacheUtil.getCompanyNameByBookId(accReimVO.getExpenseCompany());
        accReimVO.setExpenseCompanyName(companyName);
        if (!ObjectUtils.isEmpty(accReimVO.getRelatedBudgetId())) {
            BudgetVO budgetVO = budgetService.queryByKey(accReimVO.getRelatedBudgetId());
            if (!ObjectUtils.isEmpty(budgetVO)) {
                accReimVO.setSubjectTemplId(budgetVO.getSubjectTempId());
            }
        }
        List<AccReimDetailVO> accReimDetailVOS = detailDAO.queryByMasId(key);
        for (AccReimDetailVO accReimDetailVO : accReimDetailVOS) {
            // 翻译费用承担人
            if (StringUtils.hasText(accReimDetailVO.getCostPayers())) {
                List<String> userNames = new ArrayList<>();
                for (String sourceId : accReimDetailVO.getCostPayers().split(",")) {
                    String userName = cacheUtil.getUserName(Long.parseLong(sourceId));
                    userNames.add(userName);
                }
                String userName = String.join(",", userNames);
                accReimDetailVO.setCostPayersName(userName);
            }
            // 读取误餐费明细
            if (accReimDetailVO.getBusAccItemCode().equals("1005")) {
                AccReimDetailMealQuery accReimDetailMealQuery = new AccReimDetailMealQuery();
                accReimDetailMealQuery.setReimDetailId(accReimDetailVO.getId());
                List<AccReimDetailMealVO> reimDetailMealVOS = accReimDetailMealService.queryListDynamic(accReimDetailMealQuery);
                accReimDetailVO.setReimDetailMealVOS(reimDetailMealVOS);
            }
            //读取唯一配置
            if (accReimDetailVO.getReimSettingOverdueId() != null) {
                AccReimSettingOverdueVO accReimSettingOverdueVO = accReimSettingOverdueService.queryByKey(accReimDetailVO.getReimSettingOverdueId());
                accReimDetailVO.setAccReimSettingOverdueVO(accReimSettingOverdueVO);
            }
            if (accReimDetailVO.getReimSettingContinousId() != null) {
                AccReimSettingContinuousVO accReimSettingContinuousVO = accReimSettingContinuousService.queryByKey(accReimDetailVO.getReimSettingContinousId());
                accReimDetailVO.setAccReimSettingContinuousVO(accReimSettingContinuousVO);
            }
            if (accReimDetailVO.getReimSettingLimitId() != null) {
                AccReimSettingLimitVO accReimSettingLimitVO = accReimSettingLimitService.queryByKey(accReimDetailVO.getReimSettingLimitId());
                accReimDetailVO.setAccReimSettingLimitVO(accReimSettingLimitVO);
            }
            if (accReimDetailVO.getReimSettingTitleId() != null) {
                AccReimSettingTitleVO accReimSettingTitleVO = accReimSettingTitleService.queryByKey(accReimDetailVO.getReimSettingTitleId());
                accReimDetailVO.setAccReimSettingTitleVO(accReimSettingTitleVO);
            }
        }
        //获取发票
        InvInvoiceQuery invoiceQuery = new InvInvoiceQuery();
        invoiceQuery.setReimId(key);
        List<InvInvoiceVO> invInvoiceVOS = invInvoiceService.queryListDynamic(invoiceQuery);
        Map<Long, List<InvInvoiceVO>> invInvoiceGroup = invInvoiceVOS.stream().collect(Collectors.groupingBy(InvInvoiceVO::getReimDId));

        //获取对应的费用记录
        AccReimSourceRecordQuery sourceRecordQuery = new AccReimSourceRecordQuery();
        sourceRecordQuery.setReimId(key);
        List<AccReimSourceRecordVO> accReimSourceRecordVOS = reimSourceRecordService.queryListDynamic(sourceRecordQuery);
        Map<Long, List<AccReimSourceRecordVO>> sourceRecordGroup = accReimSourceRecordVOS.stream().collect(Collectors.groupingBy(AccReimSourceRecordVO::getReimDtlId));
        if (!ObjectUtils.isEmpty(accReimDetailVOS)) {
            accReimDetailVOS.forEach(
                    detailVO -> {
                        //获取关联发票
                        List<InvInvoiceVO> invDetails = invInvoiceGroup.get(detailVO.getId());
                        if (!ObjectUtils.isEmpty(invDetails)) {
                            detailVO.setInvInvoiceList(invDetails);
                        }
                        //获取关联的费用明细
                        List<AccReimSourceRecordVO> sourceRecords = sourceRecordGroup.get(detailVO.getId());
                        if (!ObjectUtils.isEmpty(sourceRecords)) {
                            detailVO.setSourcePayload(sourceRecords.get(0).getSource());
                        }
                        BigDecimal taxAmt = ObjectUtils.isEmpty(detailVO.getTaxAmt()) ? BigDecimal.ZERO : detailVO.getTaxAmt();
                        BigDecimal noTaxReimAmt = detailVO.getReimAmt().subtract(taxAmt);
                        detailVO.setNoTaxReimAmt(noTaxReimAmt);
                    }
            );
        }
        accReimVO.setDetails(accReimDetailVOS);
        //明细查询额外处理
        this.queyDetailExtraHandle(accReimVO);
        return accReimVO;
    }

    @Override
    public AccReimVO queryOneByKey(Long key) {
        return dao.queryByKey(key);
    }

    @Override
//    @Transactional
    public AccReimVO insert(AccReimPayload payload) {
        // 检查报销金额明细之和是否等于报销总额
        this.reimTotalAmtCheck(payload);
        //单据重复性校验
        this.reimDocRepeatCheck(payload);
        //规则校验
        reimRuleService.reimRuleCheck(payload);
        //校验预算是否充足，不够则报错不允许提交
        this.expenseClaimBudgetCheckHandle(payload);

        payload.setReimNo(generateSeqNum(GenerateSeqNumConstants.ACC_REIM_NO));
        if (AccReimDocTypeEnum.ACC_TRIP_TICKET.getCode().equals(payload.getReimDocType())) {
            payload.setReimStatus(AccReimDocStatusEnum.PENDING_CHARGE.getCode());
            payload.setApprStatus(ProcInstStatus.APPROVED.name());
            payload.setApplyDate(LocalDate.now());
        } else {
            payload.setReimStatus(AccReimDocStatusEnum.CREATE.getCode());
        }

        AccReimVO vo = null;
        Long reimId = null;
        try {
            transactionUtilService.begin();
            AccReimDO entityDo = AccReimConvert.INSTANCE.payload2Do(payload);
            vo = AccReimConvert.INSTANCE.do2Vo(repo.save(entityDo));
            List<InvInvoicePayload> invInvoicePayloads = new ArrayList<>();
            reimId = vo.getId();
            payload.setId(reimId);
            //若关联了申请单，进行绑定处理
            this.relateDocHandle(payload);
            //保存明细
            if (!ObjectUtils.isEmpty(payload.getDetails())) {
                List<AccReimTaxPayload> taxPayloadList = new ArrayList<>();
                for (AccReimDetailPayload dtl : payload.getDetails()) {
                    dtl.setMasId(reimId);
                    AccReimDetailDO newDetail = detailDAO.save(AccReimDetailConvert.INSTANCE.payload2Do(dtl));

                    dtl.setId(newDetail.getId());
                    List<AccReimDetailMealPayload> reimDetailMealPayloads = dtl.getReimDetailMealPayloads();
                    // 保存餐补明细
                    if (!CollectionUtils.isEmpty(reimDetailMealPayloads)) {
                        for (AccReimDetailMealPayload reimDetailMealPayload : reimDetailMealPayloads) {
                            reimDetailMealPayload.setReimDetailId(dtl.getId());
                        }
                        accReimDetailMealService.insertList(dtl.getReimDetailMealPayloads());
                    }
                    //生成税额
                    if (dtl.getTaxRate() != null && dtl.getTaxRate().compareTo(BigDecimal.ZERO) > 0) {
                        this.buildReimTaxList(reimId, dtl, taxPayloadList);
                    }
                    //关联发票
                    if (!ObjectUtils.isEmpty(dtl.getInvIdList())) {
                        this.buildInvDocRef(reimId, newDetail.getId(), dtl.getInvIdList(), invInvoicePayloads);
                    }
                    if (!ObjectUtils.isEmpty(dtl.getSourcePayload())) {
                        //保存金额计算来源详情(目前仅为餐费)
                        AccReimSourceRecordPayload sourceRecordPayload = this.buildSourceRecord(newDetail.getMasId(), newDetail.getId(), dtl.getSourcePayload());
                        reimSourceRecordService.insert(sourceRecordPayload);
                    }
                }
                if (!ObjectUtils.isEmpty(taxPayloadList)) {
                    accReimTaxService.batchInsert(taxPayloadList);
                }
                if (!ObjectUtils.isEmpty(invInvoicePayloads)) {
                    invInvoiceService.addRelateReimByIds(invInvoicePayloads);
                }
            }
            transactionUtilService.commit();
        } catch (Exception e) {
            transactionUtilService.rollback();
            throw e;
        }
        //行政订票特殊处理，且无发票，直接结束
        if (AccReimDocTypeEnum.ACC_TRIP_TICKET.getCode().equals(payload.getReimDocType())) {
            return vo;
        }
        //提交审批流
        if (Boolean.TRUE.equals(payload.getSubmitFlag())) {
            submitFlow(payload);
            //更新发票报销状态为报销中
            invInvoiceService.updateReimStatusByReimId(reimId, InvoiceReimStatusEnum.APPROVING.getCode());
        }
        return vo;
    }

    @Override
    @Transactional
    public long partialUpdate(AccReimPayload payload) {
        return dao.updateByKeyDynamic(payload);
    }

    @Override
    @Transactional
    public void updatePayStatus(AccReimPayload payload) {
        dao.updatePayStatus(payload);
    }

    @Override
    @Transactional
    public long updateByKeyDynamic(AccReimPayload payload) {
        AccReimVO oriVo = dao.queryByKey(payload.getId());
        if (ObjectUtils.isEmpty(oriVo)) {
            log.warn("当前报销单不存在，id is {}", payload.getId());
            throw TwException.error("", "当前报销单不存在！");
        }
        //行政订票不允许修改 2023-12-18需求逻辑
        if (AccReimDocTypeEnum.ACC_TRIP_TICKET.getCode().equals(payload.getReimDocType())) {
            log.warn("当前报销单为行政订票类型，不允许做修改操作！");
            throw TwException.error("", "行政订票报销单不允许做修改操作！");
        }
        //不是高级修改且非新建状态，不允许做修改
        if (Boolean.FALSE.equals(payload.getAdvanceModifyFlag()) && !AccReimDocStatusEnum.CREATE.getCode().equals(oriVo.getReimStatus())) {
            throw TwException.error("", "当前报销单不是新建状态，不允许做修改！");
        }
        // 检查报销金额明细之和是否等于报销总额
        this.reimTotalAmtCheck(payload);

        //单据重复性校验
        this.reimDocRepeatCheck(payload);

        //规则校验
        reimRuleService.reimRuleCheck(payload);

        //校验预算是否充足，不够则报错不允许提交
        this.expenseClaimBudgetCheckHandle(payload);
        //校验预算是否充足，不够则报错不允许提交 因为修改的时候查询的报销单没有将本人本次的单子去除 所以最后一笔钱的时候会预算不足 所以将这个注释掉
        //  this.expenseClaimBudgetCheckHandle(payload);
        try {
            transactionUtilService.begin();

            repo.save(AccReimConvert.INSTANCE.payload2Do(payload));
            //long result = dao.updateByKeyDynamic(payload);
            //原申请单释放
            this.relateDocRelease(oriVo);

            payload.setUpdateFlag(true);
            //若新关联了申请单，进行绑定处理
            this.relateDocHandle(payload);

            //删除之前关联的发票
            invInvoiceService.updateReimStatusByReimId(payload.getId(), InvoiceReimStatusEnum.NEW.getCode());

            Long reimId = payload.getId();
            //删除之前增加的税额
            accReimTaxService.delByReimId(reimId);

            //删除 需要删除的明细
            if (!ObjectUtils.isEmpty(payload.getDeleteKeys())) {
                detailDAO.deleteSoft(payload.getDeleteKeys());
            }
            //删除之前的费用来源明细
            reimSourceRecordService.delByReimId(reimId);
            //更新明细
            List<InvInvoicePayload> invInvoicePayloads = new ArrayList<>();
            if (!ObjectUtils.isEmpty(payload.getDetails())) {
                List<AccReimTaxPayload> taxPayloadList = new ArrayList<>();
                for (AccReimDetailPayload dtl : payload.getDetails()) {
                    //更新时进行了新增动作
                    if (dtl.getId() <= 0L) {
                        dtl.setMasId(reimId);
                        AccReimDetailDO newDetail = detailDAO.save(AccReimDetailConvert.INSTANCE.payload2Do(dtl));
                        dtl.setId(newDetail.getId());
                    } else {
                        detailDAO.updateByKeyDynamic(dtl);
                    }
                    //删除 需要删除的明细
                    if (!ObjectUtils.isEmpty(dtl.getDeleteKeys())) {
                        accReimDetailMealService.deleteSoft(dtl.getDeleteKeys());
                    }
                    List<AccReimDetailMealPayload> reimDetailMealPayloads = dtl.getReimDetailMealPayloads();
                    // 保存餐补明细
                    if (!CollectionUtils.isEmpty(reimDetailMealPayloads)) {
                        for (AccReimDetailMealPayload reimDetailMealPayload : reimDetailMealPayloads) {
                            //更新时进行了新增动作
                            if (reimDetailMealPayload.getId() <= 0L) {
                                reimDetailMealPayload.setReimDetailId(dtl.getId());
                                AccReimDetailMealVO accReimDetailMealVO = accReimDetailMealService.insert(reimDetailMealPayload);
                                reimDetailMealPayload.setId(accReimDetailMealVO.getId());
                            } else {
                                accReimDetailMealService.updateByKeyDynamic(reimDetailMealPayload);
                            }
                        }
                    }
                    //生成税额
                    if (dtl.getTaxRate() != null && dtl.getTaxRate().compareTo(BigDecimal.ZERO) > 0) {
                        this.buildReimTaxList(reimId, dtl, taxPayloadList);
                    }
                    if (!ObjectUtils.isEmpty(dtl.getInvIdList())) {
                        //重新关联发票
                        this.buildInvDocRef(reimId, dtl.getId(), dtl.getInvIdList(), invInvoicePayloads);
                    }
                    if (!ObjectUtils.isEmpty(dtl.getSourcePayload())) {
                        AccReimSourceRecordPayload sourceRecordPayload = this.buildSourceRecord(dtl.getMasId(), dtl.getId(), dtl.getSourcePayload());
                        reimSourceRecordService.insert(sourceRecordPayload);
                    }
                }
                if (!ObjectUtils.isEmpty(taxPayloadList)) {
                    accReimTaxService.batchInsert(taxPayloadList);
                }
                if (!ObjectUtils.isEmpty(invInvoicePayloads)) {
                    invInvoiceService.addRelateReimByIds(invInvoicePayloads);
                }
            }
            transactionUtilService.commit();
        } catch (Exception e) {
            transactionUtilService.rollback();
            throw e;
        }
        //行政订票特殊处理，且无发票，直接结束
        if (AccReimDocTypeEnum.ACC_TRIP_TICKET.getCode().equals(payload.getReimDocType())) {
            return 1L;
        }
        //提交审批流
        if (Boolean.TRUE.equals(payload.getSubmitFlag())) {
            submitFlow(payload);
            //更新发票报销状态为报销中
            invInvoiceService.updateReimStatusByReimId(payload.getId(), InvoiceReimStatusEnum.APPROVING.getCode());
        }
        return 1L;
    }

    @Override
    @Transactional
    public void deleteSoft(List<Long> keys) {
        if (!ObjectUtils.isEmpty(keys)) {
            AccReimQuery query = new AccReimQuery();
            query.setIdList(keys);
            List<AccReimVO> voList = dao.queryListDynamic(query);
            if (ObjectUtils.isEmpty(voList)) {
                return;
            }
            List<AccReimDetailVO> detailVOS = detailDAO.queryByMasIds(keys);
            Map<Long, List<AccReimDetailVO>> masIdMap = detailVOS.stream().collect(Collectors.groupingBy(AccReimDetailVO::getMasId));
            for (AccReimVO accReimVO : voList) {
                if (!AccReimDocStatusEnum.CREATE.getCode().equalsIgnoreCase(accReimVO.getReimStatus())) {
                    throw TwException.error("", "当前报销单非新建状态，不允许删除");
                }
                Long key = accReimVO.getId();
                //释放申请单
                accReimVO.setDelFlag(true);
                this.relateDocRelease(accReimVO);

                List<AccReimDetailVO> detailList = masIdMap.get(key);
                if (ObjectUtils.isEmpty(detailList)) {
                    continue;
                }
                //删除关联发票
                invInvoiceService.updateReimStatusByReimId(key, InvoiceReimStatusEnum.NEW.getCode());
                detailDAO.deleteSoftByMasId(key);

                //删除税额
                accReimTaxService.delByReimId(key);
            }
            dao.deleteSoft(keys);
        }
    }

    @Override
    public AccReimVO queryOneByReimNo(String reimNo) {
        AccReimVO reimVO = dao.queryOneByReimNo(reimNo);
        if (ObjectUtils.isEmpty(reimVO)) {
            throw TwException.error("", "当前报销单不存在！");
        }
        TaskInfo taskInfo = workflowUtil.currentTaskInfo(reimVO.getProcInstId());
        //流程走完后，状态未true，但是节点信息是空的
        if (ObjectUtils.isEmpty(taskInfo)) {
            throw TwException.error("", "没有正在走流程的报销！");
        }
        reimVO.setCurrentTaskKey(taskInfo.getTaskDefKey());
        return reimVO;
    }

    @Transactional
    @Override
    public void updatePayMode(Long[] keys, String payMode) {
        if (ObjectUtils.isEmpty(keys)) {
            log.info("待处理支付方式数据为空");
            return;
        }
        AccReimQuery query = new AccReimQuery();
        query.setIdList(List.of(keys));
        List<AccReimVO> voList = dao.queryListDynamic(query);
        final String hisType = PurchasePaymentEnum.PayHistType.HISTTYPE6.getDesc();
        String hisDtl;
        if (AccReimPayModeEnum.PAY_MODE_2.getCode().equals(payMode)) {
            hisDtl = PurchasePaymentEnum.PayHistDtl.DTL6.getDesc();
        } else {
            hisDtl = PurchasePaymentEnum.PayHistDtl.DTL7.getDesc();
        }
        List<TDocHistPayload> tDocHistPayloads = new ArrayList<>();
        for (AccReimVO reimVO : voList) {
            if (PurchasePaymentEnum.PayStatusEnum.SUCCESS.getCode().equals(reimVO.getPayStatus())) {
                log.warn("当前报销单已经成功支付，不允许修改支付方式重新支付！报销单号 is {} ", reimVO.getReimNo());
                throw TwException.error("", "当前报销单已经支付成功不允许修改支付方式重新支付！");
            }
            if (PurchasePaymentEnum.PayStatusEnum.PAYIN.getCode().equals(reimVO.getPayStatus())) {
                log.warn("支付中的报销单不允许修改支付方式！报销单号 is {} ", reimVO.getReimNo());
                throw TwException.error("", "支付中的报销单不允许修改支付方式！");
            }
            if (!AccReimDocStatusEnum.PENDING_PAYMENT.getCode().equals(reimVO.getReimStatus())) {
                log.warn("报销单不是已通过待付款状态，不允许修改支付方式！报销单号 is {} ", reimVO.getReimNo());
                throw TwException.error("", "报销单不是已通过待付款状态，不允许修改支付方式！");
            }
            //构建支付履历
            TDocHistPayload tDocHistPayload = this.buildDocHistory(reimVO, hisType, hisDtl);
            tDocHistPayloads.add(tDocHistPayload);
        }
        dao.updatePayMode(keys, payMode);
        //添加支付履历
        if (!ObjectUtils.isEmpty(tDocHistPayloads)) {
            tDocHistService.batchInsert(tDocHistPayloads);
        }
    }

    @Transactional
    @Override
    public AccReimVO finChargeUp(String reimNo) {
        AccReimVO vo = dao.queryOneByReimNo(reimNo);
        if (ObjectUtils.isEmpty(vo)) {
            throw TwException.error("", "当前报销单不存在");
        }
        if (!AccReimDocStatusEnum.PENDING_RECEIVE.getCode().equals(vo.getReimStatus())) {
            throw TwException.error("", "当前报销单非待收单状态，无法进行财务收单！");
        }
        dao.updateFinChargeUp(vo.getId());
        return dao.queryByKey(vo.getId());
    }

    @Transactional
    @Override
    public AccReimJdePayload batchChargeOrPay(List<Long> keys, String batchType, String expenseProofDigest, LocalDate expenseAccountDate, String payMode) {
        if (ObjectUtils.isEmpty(keys)) {
            log.error("待处理记账/付款数据为空");
            throw TwException.error("", "待处理记账/付款数据为空");
        }
        AccReimJdePayload accReimJdePayload = new AccReimJdePayload();
        AccReimQuery query = new AccReimQuery();
        query.setIdList(keys);
        List<AccReimVO> accReimVOS = dao.queryListDynamic(query);

        if (!ObjectUtils.isEmpty(accReimVOS)) {
            //获取财务期间信息
            Long finPeriodId = this.getFinPeriod();
            //报销单均是流程通过状态，才运行进行记账/付款操作
            accReimVOS.forEach(
                    vo -> {
                        if (!ProcInstStatus.APPROVED.name().equals(vo.getApprStatus())) {
                            throw TwException.error("", "当前报销单审批流程未完成，无法进行记账/付款处理，报销单号为:" + vo.getReimNo());
                        }
                        if (AccPayBatchTypeEnum.CASHIER.getCode().equals(batchType) && !AccReimDocStatusEnum.PENDING_PAYMENT.getCode().equals(vo.getReimStatus())) {
                            throw TwException.error("", "当前报销单不是已通过待付款状态，无法进行付款处理，报销单号为:" + vo.getReimNo());
                        }
                        //单据处理
                        this.tripTicketRelease(vo, batchType);
                    }
            );
            List<Long> idList = accReimVOS.stream().map(AccReimVO::getId).collect(Collectors.toList());
            BigDecimal batchTotalAmt = accReimVOS.stream()
                    .map(reimVO -> Optional.ofNullable(reimVO.getReimTotalAmt()).orElse(BigDecimal.ZERO))
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            StringBuilder sb = new StringBuilder()
                    .append(accReimVOS.size()).append("条报销单，报销总金额：").append(batchTotalAmt).append("元，批量处理时间：").append(LocalDateTime.now());
            AccReimPayBatchPayload payload = new AccReimPayBatchPayload();
            String batchNo;
            if (AccPayBatchTypeEnum.ACCOUNT.getCode().equals(batchType)) {
                batchNo = generateSeqNum(GenerateSeqNumConstants.ACC_PAY_BATCH_CODE);
            } else {
                //在付款处理时，已经生成过批次号，所以需要进行批次号分组
                int count = accReimVOS.stream().collect(Collectors.groupingBy(AccReimVO::getBatchNo)).size();
                if (count > 1) {
                    throw TwException.error("", "请选择同一批次号报销单进行付款处理！（批次号不可为空");
                }
                batchNo = accReimVOS.get(0).getBatchNo();
            }
            payload.setBatchNo(batchNo);
            payload.setBatchName(sb.toString());
            payload.setBatchAmt(batchTotalAmt);
            payload.setExportCount(0);
            payload.setBatchQty(accReimVOS.size());
            payload.setBatchType(batchType);
            payload.setBatchTime(LocalDateTime.now());
            payload.setBatchStatus("0");
            AccReimPayBatchVO insert = reimPayBatchService.insert(payload);
            dao.updateBatchNo(idList, batchNo, batchType, finPeriodId, expenseAccountDate, payMode);
        }
        return accReimJdePayload;
    }

    @Transactional
    @Override
    public AccReimSourcePayload calcAmt(String busItemCode, AccReimSourcePayload calcSource) {
        AccReimSourceConfigQuery query = new AccReimSourceConfigQuery();
        query.setBusAccItemCodes(busItemCode);
        List<AccReimSourceConfigVO> accReimSourceConfigVOS = reimSourceConfigService.queryListDynamic(query);
        if (ObjectUtils.isEmpty(accReimSourceConfigVOS)) {
            log.warn("当前核算项目无报销金额来源配置，核算项目code is {}", busItemCode);
        }
        AccReimSourceConfigVO vo = accReimSourceConfigVOS.get(0);
        if (0 == vo.getEnableFlag()) {
            log.warn("该核算项目[{}]报销金额来源配置 {} 未开启", busItemCode, vo.getConfigName());
            throw TwException.error("", "该核算项目报销金额来源配置未开启");
        }
        Long userId = GlobalUtil.getLoginUserId();
        PrdOrgEmployeeVO prdOrgEmployeeVO = employeeService.queryByUserId(userId);
        String jobGrade = prdOrgEmployeeVO.getExtString1();
        AccReimTripStdQuery stdQuery = new AccReimTripStdQuery();
        stdQuery.setJobGrade(jobGrade);
        stdQuery.setFeeType("MEAL");
        List<AccReimTripStdVO> accReimTripStdVOS = accReimTripStdService.queryListDynamic(stdQuery);
        if (ObjectUtils.isEmpty(accReimTripStdVOS)) {
            throw TwException.error("", "当前职级下的餐费额度未设置，职级 is :" + jobGrade);
        }
        BigDecimal feeAmt = accReimTripStdVOS.get(0).getFeeAmt();
        final int selectedFlag = 1;
        //根据职级、出差时长、城市计算出金额
        for (AccReimSourceDetailPayload detailPayload : calcSource.getDetails()) {
            if (selectedFlag == detailPayload.getBreakfastFlag()) {
                detailPayload.setBreakfastFee(feeAmt.multiply(breakfastScale));
            }
            if (selectedFlag == detailPayload.getLunchFeeFlag()) {
                detailPayload.setLunchFee(feeAmt.multiply(lunchScale));
            }
            if (selectedFlag == detailPayload.getDinnerFeeFlag()) {
                detailPayload.setDinnerFee(feeAmt.multiply(dinnerScale));
            }
        }
        return calcSource;
    }

    @Override
    public void exportChargeDtl(HttpServletResponse response, Long batchId) {
        AccReimPayBatchVO accReimPayBatchVO = reimPayBatchService.queryByKey(batchId);
        String userName = cacheUtil.getUserName(accReimPayBatchVO.getCreateUserId());
        if (ObjectUtils.isEmpty(accReimPayBatchVO)) {
            throw TwException.error("", "当前记账批次不存在" + batchId);
        }
        //主数据
        List<AccReimExportVO> mainData = dao.getExportChargeData(accReimPayBatchVO.getBatchNo());
        //税额数据
        Set<Long> idList = mainData.stream().map(AccReimExportVO::getId).collect(Collectors.toSet());
        List<AccReimExportVO> taxData = accReimTaxService.getExportTaxData(idList);
        if (!ObjectUtils.isEmpty(taxData)) {
            taxData.forEach(tax -> tax.setTaxFlag(1));
            mainData.addAll(taxData);
        }
        final String childAccountPrefix = "80";

        //导出模版
        ClassPathResource classPathResource = new ClassPathResource("template/accReimCharge.xlsx");
        try (InputStream inputStream = classPathResource.getInputStream()) {
            Workbook workbook = WorkbookFactory.create(inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet) workbook.getSheet("财务记账明细");
            if (!ObjectUtils.isEmpty(mainData)) {

                Map<Long, List<BusinessPartnerVO>> bookIdMap = new HashMap<>();
                Map<Long, List<PrdOrgOrganizationVO>> orgIdMap = new HashMap<>();
                Map<Long, List<PrdOrgEmployeeVO>> userIdMap = new HashMap<>();
                Map<Long, List<PmsProjectVO>> reasonIdMap = new HashMap<>();
                //获取公司、部门及员工信息
                this.chargeExportDataHandle(mainData, bookIdMap, orgIdMap, userIdMap, reasonIdMap, accReimPayBatchVO.getBatchNo());

                final String accountType = "A";
                int nextRow = 1;
                for (AccReimExportVO vo : mainData) {
                    List<PrdOrgOrganizationVO> orgList = orgIdMap.get(vo.getExpenseOrgId());
                    if (ObjectUtils.isEmpty(orgList)) {
                        log.warn("当前组织不存在，id is {}", vo.getExpenseOrgId());
                        continue;
                    }
                    PrdOrgOrganizationVO orgVo = orgList.get(0);
                    List<PrdOrgEmployeeVO> prdOrgEmployeeVOS = userIdMap.get(vo.getReimUserId());
                    if (ObjectUtils.isEmpty(prdOrgEmployeeVOS)) {
                        log.warn("当前用户不存在，id is {}", vo.getReimUserId());
                        continue;
                    }
                    PrdOrgEmployeeVO employeeVO = prdOrgEmployeeVOS.get(0);
                    List<BusinessPartnerVO> businessPartnerVOS4Id = bookIdMap.get(vo.getExpenseCompany());
                    if (ObjectUtils.isEmpty(businessPartnerVOS4Id)) {
                        log.warn("当前业务伙伴不存在，bookId is {}", vo.getExpenseCompany());
                        continue;
                    }
                    BusinessPartnerVO businessPartnerVO = businessPartnerVOS4Id.get(0);
                    Row row = batchProjectSheet.createRow(nextRow);
                    excelUtil.setCellValue(row, 0, accReimPayBatchVO.getBatchNo()); // 批次号
                    excelUtil.setCellValue(row, 1, vo.getAccName()); // 费用科目

                    //账号规则 分无项目+有项目(禅道号31899) 公司编号+部门编号+科目编号
                    StringBuilder accountNo = new StringBuilder();
                    if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(vo.getReasonType()) && vo.getTaxFlag() == 0) {
                        List<PmsProjectVO> pmsProjectVOS = reasonIdMap.get(vo.getReasonId());
                        vo.setTaxFlag(1);
                        if (!ObjectUtils.isEmpty(pmsProjectVOS)) {
                            PmsProjectVO pmsProjectVO = pmsProjectVOS.get(0);
                            excelUtil.setCellValue(row, 13, cacheUtil.getCompanyNameByBookId(pmsProjectVO.getSignBuId())); // 项目所属公司
                            excelUtil.setCellValue(row, 22, pmsProjectVO.getContractNo()); // 费用承担项目 -> 子合同号
                            if (SaleConWorkTypeEnum.DEVELOP.getCode().equals(pmsProjectVO.getWorkType())) {
                                accountNo.append(pmsProjectVO.getProductNo());
                            } else {
                                accountNo.append(pmsProjectVO.getContractNo());
                            }
                        }
                    } else {
                        accountNo.append(businessPartnerVO.getJdeCompanyNo());
                    }
                    if (1 == vo.getTaxFlag()) {
                        accountNo.append(".");
                    } else {
                        accountNo.append(orgVo.getJdeOrgCode()).append(".");
                    }
                    if (!ObjectUtils.isEmpty(vo.getFinAccSubjCode()) && vo.getFinAccSubjCode().length() >= 4) {
                        String parentCode = vo.getFinAccSubjCode().substring(0, 4);
                        accountNo.append(parentCode);
                        String selfCode = vo.getFinAccSubjCode().substring(4);
                        if (!ObjectUtils.isEmpty(selfCode)) {
                            accountNo.append(".").append(selfCode);
                        }
                    } else {
                        accountNo.append(vo.getFinAccSubjCode());
                    }
                    excelUtil.setCellValue(row, 2, accountNo.toString()); // 账号
                    BigDecimal reimAmt = vo.getReimAmt();
                    BigDecimal adjustAmt = vo.getAdjustAmt() == null ? reimAmt : vo.getAdjustAmt();
                    if (!ObjectUtils.isEmpty(vo.getTaxAmt())) {
                        adjustAmt = adjustAmt.subtract(vo.getTaxAmt());
                    }
                    excelUtil.setCellValue(row, 6, adjustAmt); // 明细报销金额
                    excelUtil.setCellValue(row, 8, accountType); // 子账类型
                    String resNo = employeeVO.getResNo();
                    if (ObjectUtils.isEmpty(resNo)) {
                        log.error("当前报销人的资源编号为空，请联系管理员进行维护！员工姓名为:{}", employeeVO.getEmployeeName());
                        throw TwException.error("", "当前报销人的资源编号为空，请联系管理员进行维护！员工姓名为：" + employeeVO.getEmployeeName());
                    }
                    StringBuilder childAccount = new StringBuilder(childAccountPrefix);
                    childAccount.append(resNo, 1, 4).append(resNo.substring(resNo.length() - 3));
                    excelUtil.setCellValue(row, 9, childAccount.toString()); // 子账-即工号拼接资源编号
                    //描述 报销说明+费用发生日期
                    String reimRemark = ObjectUtils.isEmpty(vo.getDtlReimRemark()) ? "" : vo.getDtlReimRemark();
                    StringBuilder desc = new StringBuilder(reimRemark).append(vo.getExpenseDate());
                    excelUtil.setCellValue(row, 12, desc.toString()); // 描述
                    excelUtil.setCellValue(row, 14, vo.getReasonName()); // 相关项目
                    excelUtil.setCellValue(row, 15, vo.getReimNo()); // 报销单号
                    excelUtil.setCellValue(row, 16, employeeVO.getEmployeeName()); // 姓名
                    String docTypeDesc = cacheUtil.transferSystemSelection(FunctionSelectionEnum.ACC_REIM_PROC_KEY.getCode(), vo.getReimDocType());
                    excelUtil.setCellValue(row, 17, docTypeDesc); // 报销类型
                    excelUtil.setCellValue(row, 18, businessPartnerVO.getPartnerName()); // 报销人所属公司
                    String invFlag = vo.getInvoiceNum() > 0 ? "是" : "否";
                    excelUtil.setCellValue(row, 19, invFlag); // 是否有票
                    excelUtil.setCellValue(row, 20, employeeVO.getOrgName()); // bu名称
                    excelUtil.setCellValue(row, 21, orgVo.getOrgName()); // 费用承担部门
                    excelUtil.setCellValue(row, 23, userName); // 导出人
                    excelUtil.setCellValue(row, 24, TimeUtil.datetime2String((accReimPayBatchVO.getBatchTime()))); // 导出时间
                    nextRow++;
                }
            }
            LocalDateTime now = LocalDateTime.now();
            //更新导出次数
            AccReimPayBatchPayload payload = new AccReimPayBatchPayload();
            payload.setId(batchId);
            int exportCount = accReimPayBatchVO.getExportCount() + 1;
            payload.setExportCount(exportCount);
            payload.setLastExportTime(now);
            reimPayBatchService.updateByKeyDynamic(payload);
            String fileName = "财务记账明细-" + TimeUtil.datetime2String(now);
            ExcelUtil.writeResponse(response, fileName, workbook);
        } catch (Exception e) {
            log.error("记账导出失败，错误信息 is {}", e.getMessage());
            e.printStackTrace();
        }
    }

    @UdcNameClass
    @Override
    public void exportPayData(HttpServletResponse response, Long batchId) {
        AccReimPayBatchVO accReimPayBatchVO = reimPayBatchService.queryByKey(batchId);
        String userName = cacheUtil.getUserName(accReimPayBatchVO.getCreateUserId());
        if (ObjectUtils.isEmpty(accReimPayBatchVO)) {
            throw TwException.error("", "当前记账批次不存在" + batchId);
        }
        AccReimQuery query = new AccReimQuery();
        query.setBatchNo(accReimPayBatchVO.getBatchNo());
        List<AccReimVO> accReimVOS = dao.queryListDynamic(query);
        //导出模版
        ClassPathResource classPathResource = new ClassPathResource("template/accReimPay.xlsx");
        try (InputStream inputStream = classPathResource.getInputStream()) {
            Workbook workbook = WorkbookFactory.create(inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet) workbook.getSheet("财务付款明细");
            if (!ObjectUtils.isEmpty(accReimVOS)) {
                int nextRow = 1;
                for (AccReimVO vo : accReimVOS) {
                    Row row = batchProjectSheet.createRow(nextRow);
                    excelUtil.setCellValue(row, 0, vo.getBatchNo()); // 批次号
                    excelUtil.setCellValue(row, 1, vo.getReimNo()); // 报销单号
                    excelUtil.setCellValue(row, 2, cacheUtil.getUserName(vo.getReimUserId())); // 报销人姓名
                    excelUtil.setCellValue(row, 3, vo.getReimTotalAmt()); // 报销金额
                    excelUtil.setCellValue(row, 4, vo.getAccountNo()); // 银行账号
                    excelUtil.setCellValue(row, 5, userName); // 导出人
                    excelUtil.setCellValue(row, 6, TimeUtil.datetime2String(accReimPayBatchVO.getBatchTime())); // 报销时间
                    nextRow++;
                }
            }
            LocalDateTime now = LocalDateTime.now();
            //更新导出次数
            AccReimPayBatchPayload payload = new AccReimPayBatchPayload();
            payload.setId(batchId);
            int exportCount = accReimPayBatchVO.getExportCount() + 1;
            payload.setExportCount(exportCount);
            payload.setLastExportTime(now);
            reimPayBatchService.updateByKeyDynamic(payload);
            String fileName = "财务付款明细-" + TimeUtil.datetime2String(now);
            ExcelUtil.writeResponse(response, fileName, workbook);
        } catch (Exception e) {
            log.error("记账导出失败，错误信息 is {}", e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    @Transactional
    public void payBankSubmit(Long[] ids) {
        if (ObjectUtils.isEmpty(ids)) {
            log.warn("网银提交数据为空");
            return;
        }
        //检查是否存在相同的报销单数据
        this.checkDuplicateData(ids);

        AccReimQuery query = new AccReimQuery();
        query.setIdList(List.of(ids));
        List<AccReimVO> reimData = dao.queryListDynamic(query);
        if (ObjectUtils.isEmpty(reimData)) {
            return;
        }
        //bookId不一致，则付款账户信息肯定不一致
        Set<Long> expenseCompanyIds = reimData.stream().map(AccReimVO::getExpenseCompany).collect(Collectors.toSet());
        if (expenseCompanyIds.size() > 1) {
            throw TwException.error("", "不允许不同付款账号的报销单同时提交！");
        }
        BookAccountVO bookAccountVO = bookAccountService.queryDefaultByBookId(reimData.get(0).getExpenseCompany());
        if (ObjectUtils.isEmpty(bookAccountVO)) {
            throw TwException.error("", "当前公司收款信息不存在或未维护，请联系管理员进行处理！！！" + reimData.get(0).getExpenseCompany());
        }
        PayListPayload payListPayload = new PayListPayload();
        List<PayPayload> payloadList = new ArrayList<>();
        List<TDocHistPayload> tDocHistPayloads = new ArrayList<>();
        payListPayload.setBank(bank);
        payListPayload.setPlatform(platform);
        payListPayload.setSecretKey(secretKey);
        String bthnbr = generateSeqNum(GenerateSeqNumConstants.BTHNBR);
        LocalDateTime now = LocalDateTime.now();
        final String hisType = PurchasePaymentEnum.PayHistType.HISTTYPE4.getDesc();
        final String hisDtl = PurchasePaymentEnum.PayHistDtl.DTL4.getDesc();

        //当前这笔交易总金额
        BigDecimal currentTotalAmt = reimData.stream()
                .map(reimVO -> Optional.ofNullable(reimVO.getAdjustAmt() == null ? reimVO.getReimTotalAmt() : reimVO.getAdjustAmt()).orElse(BigDecimal.ZERO))
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        //总笔数
        int currentTotal = reimData.size();
        //支付数据的校验
        for (int i = 0; i < reimData.size(); i++) {
            AccReimVO reimVO = reimData.get(i);
            //支付前校验
            this.payBackCheck(reimVO);

            PayPayload payload = new PayPayload();
            //payload.setBatchFlag(2);  报销 批量标识不需要传值 batchFlag 2023-12-23定
            payload.setBthnbr(bthnbr);//批次编号
            payload.setTrxseq(String.valueOf(i + 1));
            //构建银企直连数据
            this.buildPaymentDetail(reimVO, bookAccountVO, payload, currentTotalAmt, currentTotal);
            payloadList.add(payload);

            //构建支付履历数据
            TDocHistPayload tDocHistPayload = this.buildDocHistory(reimVO, hisType, hisDtl);
            tDocHistPayloads.add(tDocHistPayload);

            //更新报销单状态
            AccReimPayload reimPayload = new AccReimPayload();
            reimPayload.setId(reimVO.getId());
            reimPayload.setBankTime(now);
            reimPayload.setBankFlag(1);
            reimPayload.setPayStatus(PurchasePaymentEnum.PayStatusEnum.PAYIN.getCode());
            dao.updateByKeyDynamic(reimPayload);
        }
        //支付履历插入数据
        tDocHistService.batchInsert(tDocHistPayloads);
        payListPayload.setPayPayloadList(payloadList);
        log.info("报销单批次号为[{}]请求数据为:{}", bthnbr, JSONUtil.toJsonStr(payListPayload));

        // 调用银企直连
        ApiResult<List<BkPayDetailVO>> bkApiResult = payService.payList(payListPayload);
        log.info("报销单批次号为[{}]返回数据为:{}", bthnbr, JSONUtil.toJsonStr(bkApiResult));
        if (bkApiResult.getCode() != 200) {
            log.error("报销单批次号为[{}]调用银企直连异常，错误信息is:{}", bthnbr, bkApiResult.getErrorMsg());
            throw TwException.error("", "报销单批次号为批次号为:" + bthnbr + "调用银企直联失败");
        }
        //生成付款导出信息
        this.batchChargeOrPay(Arrays.asList(ids), AccPayBatchTypeEnum.CASHIER.getCode(), null, null, AccReimPayModeEnum.PAY_MODE_1.getCode());

        if (!ObjectUtils.isEmpty(bkApiResult.getData())) {
            List<BkPayDetailRecordPayload> payloads = new ArrayList<>();
            bkApiResult.getData().forEach(
                    payDetail -> {
                        BkPayDetailRecordPayload recordPayload = this.buildPayDetailRecord(payDetail);
                        payloads.add(recordPayload);
                    }
            );
            bkPayDetailRecordService.batchInsert(payloads);
        }

    }

    @Override
    public void updateBankAccount(AccReimPayload payload) {
        AccReimVO reimVO = dao.queryByKey(payload.getId());
        if (ObjectUtils.isEmpty(reimVO)) {
            throw TwException.error("", "当前报销单不存在！");
        }
        if (PurchasePaymentEnum.PayStatusEnum.SUCCESS.getCode().equals(reimVO.getPayStatus())) {
            log.warn("当前报销单已经成功支付，不允许修改账号重新支付！报销单号 is {} ", reimVO.getReimNo());
            throw TwException.error("", "当前报销单已经支付成功不允许修改账号重新支付！");
        }
        if (PurchasePaymentEnum.PayStatusEnum.PAYIN.getCode().equals(reimVO.getPayStatus())) {
            log.warn("支付中的报销单不允许修改账号！报销单号 is {} ", reimVO.getReimNo());
            throw TwException.error("", "支付中的报销单不允许修改账号！");
        }
        dao.updateByKeyDynamic(payload);
        //添加支付履历
        String hisType = PurchasePaymentEnum.PayHistType.HISTTYPE2.getDesc();
        String hisDtl = PurchasePaymentEnum.PayHistDtl.DTL2.getDesc();
        TDocHistPayload tDocHistPayload = this.buildDocHistory(reimVO, hisType, hisDtl);
        tDocHistService.insert(tDocHistPayload);
    }

    @Override
    public boolean myReimCheck(Long reimUserId) {
        AccReimQuery query = new AccReimQuery();
        query.setReimUserId(reimUserId);
        List<String> notReimStatusList = new ArrayList<>();
        notReimStatusList.add(AccReimDocStatusEnum.CREATE.getCode());
        notReimStatusList.add(AccReimDocStatusEnum.APPLYING.getCode());
        notReimStatusList.add(AccReimDocStatusEnum.FINANCIAL_AUDIT.getCode());
        query.setNotReimStatusList(notReimStatusList);
        return dao.count(query) > 0;
    }

    @Override
    public PagingVO<AccReimVO> paging2Budget(AccReimQuery query) {
        return dao.paging2Budget(query);
    }

    /**
     * 检查报销明细金额之和是否等于报销总金额
     *
     * @param payload
     * @return
     */
    private void reimTotalAmtCheck(AccReimPayload payload) {
        BigDecimal totalClaimAmt = BigDecimal.ZERO;
        for (AccReimDetailPayload detail : payload.getDetails()) {
            totalClaimAmt = totalClaimAmt.add(detail.getReimAmt());
        }
        boolean totalAmtCheck = (totalClaimAmt.compareTo(payload.getReimTotalAmt()) == 0);
        if (!totalAmtCheck) {
            log.warn("报销明细金额之和与报销总额不等,入参 is {}", payload);
            throw TwException.error("", "报销明细金额之和与报销总额不等");
        }
    }

    /**
     * 检查相关单据不能被重复报销多次
     *
     * @param payload
     * @return
     */
    private void reimDocRepeatCheck(AccReimPayload payload) {
        if (!ObjectUtils.isEmpty(payload.getRelatedDocId())) {
            Long relateDocId = payload.getRelatedDocId();
            //差旅
            if (AccReimDocTypeEnum.ACC_TRIP.getCode().equals(payload.getReimDocType())) {
                AdmBusitripApplyVO admBusitripApplyVO = busitripApplyService.queryOneByKey(relateDocId);
                if (ObjectUtils.isEmpty(admBusitripApplyVO)) {
                    log.warn("当前出差申请单不存在,单据号 is {}", payload.getRelatedDocId());
                    throw TwException.error("", "当前出差申请单不存在！");
                }
                if (admBusitripApplyVO.getReimId() != null && !Objects.equals(admBusitripApplyVO.getReimId(), payload.getId())) {
                    log.warn("当前出差申请单已被其他报销单占用,单据号 is {}", payload.getRelatedDocId());
                    throw TwException.error("", "当前出差申请单已被其他报销单占用，无法再次发起！");
                }
            }
            //特殊费用
            if (AccReimDocTypeEnum.ACC_OTHERS.getCode().equals(payload.getReimDocType())) {
                AdmFeeApplyVO admFeeApplyVO = feeApplyService.queryOneByKey(relateDocId);
                if (ObjectUtils.isEmpty(admFeeApplyVO)) {
                    log.warn("当前特殊费用申请单不存在,单据号 is {}", payload.getRelatedDocId());
                    throw TwException.error("", "当前特殊费用申请单不存在！");
                }
                if (!Objects.equals(admFeeApplyVO.getReimId(), payload.getId())) {
                    log.warn("当前特殊费用申请单已被其他报销单占用,单据号 is {}", payload.getRelatedDocId());
                    throw TwException.error("", "当前特殊费用申请单已被其他报销单占用，无法再次发起！");
                }
            }
        }
    }

    /**
     * 预算检查
     *
     * @param payload
     * @return
     */
    private void expenseClaimBudgetCheckHandle(AccReimPayload payload) {
        //非提交状态，无需进行预算校验
        PrdSystemSelectionVO systemSelection = cacheUtil.getSystemSelection(FunctionSelectionEnum.BUDGET_MODULE_ENABLED.getCode());
        List<PrdSystemSelectionVO> children = systemSelection.getChildren();
        //提交状态且预算开启，需进行预算校验，预算不足会直接抛出异常，目前无需进行额外处理
        if (Boolean.TRUE.equals(payload.getSubmitFlag() && !ObjectUtils.isEmpty(children)
                && AccBudgetEnableStatusEnum.OPEN.getCode().equalsIgnoreCase(children.get(0).getSelectionValue()))) {
            //提交前正式进行预算检查 不传明细预算id，则不进行明细控制 -> 目前只对总预算进行控制
            budgetCommonService.checkBudgetReimAmt(payload.getReasonId(), payload.getReasonType(), null, payload.getReimTotalAmt(), payload.getId());
        }
    }

    /**
     * 提交审批流
     *
     * @param payload
     */
    private void submitFlow(AccReimPayload payload) {
        AccReimDocTypeEnum docTypeEnum = AccReimDocTypeEnum.find(payload.getReimDocType());
        if (ObjectUtils.isEmpty(docTypeEnum)) {
            throw TwException.error("", "单据类型有误，根据此单据类型未获取到流程的key；单据类型 is " + payload.getReimDocType());
        }
        //首次提交
        AccReimPayload updatePayload = new AccReimPayload();
        updatePayload.setApprStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
        //获取流程参数
        HashMap<String, Object> variables = this.getVariables(payload, docTypeEnum.getCode());
        if (ObjectUtils.isEmpty(payload.getProcInstId())) {
            variables.put("finRejectFlag", false);
            String procKey = docTypeEnum.getCode();
            //差旅、非差旅用的流程是一个，所以需要提换下非差旅的流程key
            if (AccReimDocTypeEnum.ACC_NOT_TRIP.getCode().equals(payload.getReimDocType())) {
                procKey = AccReimDocTypeEnum.ACC_TRIP.getCode();
            }
            String userName = cacheUtil.getUserName(payload.getReimUserId());
            //流程名称
            StringBuilder procName = new StringBuilder(docTypeEnum.getFlowCode());
            procName.append(".").append(docTypeEnum.getDesc()).append("-").append(userName).append("-").append(LocalDate.now().toString());
            //新建审批流
            ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    procKey,
                    procName.toString(),
                    payload.getId() + "",
                    variables)
            );
            updatePayload.setProcInstId(processInfo.getProcInstId());
            updatePayload.setProcInstName(procName.toString());
            if (AccReimDocTypeEnum.ACC_SPECIAL.getCode().equals(payload.getReimDocType())) {
                updatePayload.setReimStatus(AccReimDocStatusEnum.PENDING_RECEIVE.getCode());
            } else {
                updatePayload.setReimStatus(AccReimDocStatusEnum.APPLYING.getCode());
            }
            if (ObjectUtils.isEmpty(payload.getApplyDate())) {
                updatePayload.setApplyDate(LocalDate.now());
            }
        } else {
            updatePayload.setReimStatus(AccReimDocStatusEnum.APPLYING.getCode());
            //流程驳回后修改 -> 目前差旅/非差旅与特殊费用报销需要做此操作
            if (AccReimDocTypeEnum.ACC_TRIP.getCode().equals(payload.getReimDocType()) || AccReimDocTypeEnum.ACC_NOT_TRIP.getCode().equals(payload.getReimDocType())
                    || AccReimDocTypeEnum.ACC_OTHERS.getCode().equals(payload.getReimDocType())) {
                boolean result = !ObjectUtils.isEmpty(payload.getFinRejectFlag()) && 1 == payload.getFinRejectFlag();
                variables.put("finRejectFlag", result);
                //修改流程实例节点审批人
                workflowUtil.setVariables(SetVariablesPayload.of(payload.getProcInstId(), variables));
                if (result) {
                    updatePayload.setReimStatus(AccReimDocStatusEnum.FINANCIAL_AUDIT.getCode());
                }
            }
            if (AccReimDocTypeEnum.ACC_SPECIAL.getCode().equals(payload.getReimDocType())) {
                updatePayload.setReimStatus(AccReimDocStatusEnum.PENDING_RECEIVE.getCode());
            }
        }
        updatePayload.setId(payload.getId());
        //更新代收单节点
        updatePayload.setProcTaskKey(payload.getProcTaskKey());
        //异步事务更新状态
        transactionUtilService.executeWithRunnable(() -> {
            dao.updateByKeyDynamic(updatePayload);
        });
    }

    /**
     * 获取流程参数
     *
     * @param payload
     * @return
     */
    private HashMap<String, Object> getVariables(AccReimPayload payload, String procCode) {
        HashMap<String, Object> variables = new HashMap<>();
        //根据流程类型对不同的流程做各自操作
        if (AccReimDocTypeEnum.ACC_TRIP.getCode().equals(procCode) || AccReimDocTypeEnum.ACC_NOT_TRIP.getCode().equals(procCode)) {
            //默认应该是费用承担事业部审批完就应该是“待收单”
            payload.setProcTaskKey(AccReimTaskKey.Activity_0s28lb1.getCode());
            //处理事否是内部资源，M级，直属上级
            this.setFlowResParent(payload.getReimUserId(), variables, AccReimTaskKey.Activity_0v6bxzy.getCode());
            //流程事由类型相关数据赋值
            this.flowReasonTypeCheck(payload, variables);
            //销售人员逻辑处理
            judgeIsSalePerson(payload, variables);
            //1.报销科目是否有KTV
            //2.招待费单笔>=1000
            //3.礼品
            specialCostCheck(payload, variables);
            //报销总金额处理
            this.flowAmtLimitCheck(payload.getReimTotalAmt(), variables);
        }
        if (AccReimDocTypeEnum.ACC_OTHERS.getCode().equals(procCode)) {
            //处理事否是内部资源，M级，直属上级
            this.setFlowResParent(payload.getReimUserId(), variables, AccReimTaskKey.ACC_OTHERS_Activity_1luosio.getCode());
            //获取费用承担BU事业部负责人
            //费用承担事业部负责人
            PrdOrgOrganizationRefVO orgRef = cacheUtil.getBULevel1ByOrgId(payload.getExpenseOrgId());
            if (orgRef == null) {
                throw TwException.error("", "费用承担事业部不存在，请联系管理员，buId is  " + payload.getExpenseOrgId());
            }
            //   Long manageId = getBULevel1ManageId(payload.getReasonType(), payload.getReasonId());
            variables.put(AccReimTaskKey.ACC_OTHERS_Activity_0yd0oo0.getCode(), Lists.newArrayList(orgRef.getManageId()));
            //报销总金额处理
            this.flowAmtLimitCheck(payload.getReimTotalAmt(), variables);
        }
        return variables;
    }

    /**
     * 特殊费用处理
     *
     * @param payload
     * @param variables
     */
    void specialCostCheck(AccReimPayload payload, HashMap<String, Object> variables) {
//        1.报销科目是否有KTV
//        2.招待费单笔>=1000
//        3.礼品

        //是否更新待收单节点
        Boolean isUp = true;
        variables.put("specialCost", true);//是否包含特殊场景
        List<AccReimDetailPayload> details = payload.getDetails();
        List<String> codes = Arrays.asList("1047", "1046");
        Optional<AccReimDetailPayload> first = details.stream().filter(detail -> codes.contains(detail.getBusAccItemCode())).findFirst();
        if (!first.isPresent()) {
            Optional<AccReimDetailPayload> first0 = details.stream().filter(detail -> "1010".equals(detail.getBusAccItemCode()) && detail.getAdjustAmt().compareTo(businessLimitAmt) >= 0).findFirst();
            if (!first0.isPresent()) {
                variables.put("specialCost", false);//是否包含特殊场景
                isUp = false;
            }
        }
        if (isUp) {
            // 平台总体负责人审批完就应该是“待收单”
            payload.setProcTaskKey(AccReimTaskKey.Activity_0lef6bf.getCode());
        }
        //平台总体负责人 PLAT_ALL_PIC
        variables.put(AccReimTaskKey.Activity_0lef6bf.getCode(), roleService.queryUserIdByRoleCode(RoleEnum.PLAT_ALL_PIC.getCode()));
    }

    /**
     * 销售人员逻辑处理
     *
     * @param payload
     * @param variables
     */
    void judgeIsSalePerson(AccReimPayload payload, HashMap<String, Object> variables) {
        variables.put(AccReimTaskKey.Activity_13m9opq.getCode(), 0L);
//        variables.put(AccReimTaskKey.Activity_1uie2q6.getCode(), 0L);

        PrdOrgEmployeeRefVO userDefaultOrg = cacheUtil.getUserDefaultOrg(payload.getReimUserId());
        variables.put("isSalePerson", false);//是否是销售
        if (StringUtils.hasText(userDefaultOrg.getOrganizationType()) && OrgEnum.OrgType.BS.getCode().equals(userDefaultOrg.getOrganizationType())) {
            //如果是销售 销售中心负责人审批完就应该是“待收单”
            payload.setProcTaskKey(AccReimTaskKey.Activity_1uie2q6.getCode());
            variables.put("isSalePerson", true);//是否是销售
            variables.put("isSaleManageRes", false);//是否是销售BU负责任人
            variables.put(AccReimTaskKey.Activity_13m9opq.getCode(), Lists.newArrayList(userDefaultOrg.getManageId()));
            if (userDefaultOrg.getManageId().equals(payload.getReimUserId())) {
                variables.put("isSaleManageRes", true);//是否是销售BU负责任人
            }

        }

    }


    /**
     * 流程事由类型校验
     *
     * @param variables
     */
    private void flowReasonTypeCheck(AccReimPayload payload, HashMap<String, Object> variables) {
        String reasonType = payload.getReasonType();
        Long reasonId = payload.getReasonId();

        variables.put(AccReimTaskKey.Activity_0tuowqd.getCode(), 0L);
        variables.put(AccReimTaskKey.Activity_1a4l4or.getCode(), 0L);
        variables.put(AccReimTaskKey.Activity_11xytgw.getCode(), 0L);
        variables.put(AccReimTaskKey.Activity_1bdkuyf.getCode(), 0L);
        variables.put(AccReimTaskKey.Activity_0s28lb1.getCode(), 0L);

        variables.put("reasonType", reasonType);
        //费用承担BU
        //Long orgId = null;
        //判断事由类型是否为合同项目，决定是否跳过节点
        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(reasonType)) {
            PmsProjectVO pmsProjectVO = projectService.queryByKey(reasonId);
            if (ObjectUtils.isEmpty(pmsProjectVO)) {
                throw TwException.error("", "当前项目数据不存在,id is " + reasonId);
            }
            //项目经理审批
            variables.put(AccReimTaskKey.Activity_0tuowqd.getCode(), Lists.newArrayList(pmsProjectVO.getPmResId()));
            //交付负责人
            variables.put(AccReimTaskKey.Activity_1a4l4or.getCode(), Lists.newArrayList(pmsProjectVO.getDeliUserId()));
            // orgId = pmsProjectVO.getDeliBuId();
        }
//        if (PmsReasonTypeEnum.PROJ_BU.getCode().equals(reasonType)) {
//            BuProjectVO buProjectVO = buProjectService.queryByKey(reasonId);
//            if (ObjectUtils.isEmpty(buProjectVO)) {
//                throw TwException.error("", "当前BU数据不存在,id is " + reasonId);
//            }
//            orgId = buProjectVO.getDeliBuId();
//        }
        if (PmsReasonTypeEnum.PROJ_OPPO.getCode().equals(reasonType)) {
            CrmOpportunityVO crmOpportunityVO = opportunityService.queryByOppoProjId(reasonId);
            if (ObjectUtils.isEmpty(crmOpportunityVO)) {
                throw TwException.error("", "当前售前数据不存在,id is " + reasonId);
            }
            //售前负责人
            variables.put(AccReimTaskKey.Activity_11xytgw.getCode(), Lists.newArrayList(crmOpportunityVO.getPreSaleUserId()));
            //费用承担BU负责人审批
            PrdOrgOrganizationVO org = cacheUtil.getOrg(payload.getExpenseOrgId());
            variables.put(AccReimTaskKey.Activity_1bdkuyf.getCode(), Lists.newArrayList(org.getManageId()));
//            //费用承担bu负责人
//            PrdOrgOrganizationVO org = cacheUtil.getOrg(crmOpportunityVO.getPreSaleOrgId());
//            variables.put(AccReimTaskKey.Activity_1bdkuyf.getCode(), Lists.newArrayList(org.getManageId()));

            // orgId = crmOpportunityVO.getPreSaleOrgId();

        }
        //费用承担事业部负责人
        PrdOrgOrganizationRefVO orgRef = cacheUtil.getBULevel1ByOrgId(payload.getExpenseOrgId());
        if (orgRef == null) {
            throw TwException.error("", "费用承担事业部不存在，请联系管理员，buId is  " + payload.getExpenseOrgId());
        }
        variables.put(AccReimTaskKey.Activity_0s28lb1.getCode(), Lists.newArrayList(orgRef.getManageId()));

//        PrdOrgOrganizationVO org = cacheUtil.getOrg(payload.getExpenseOrgId());
//        //费用承担BU负责人审批
//        variables.put(AccReimTaskKey.ACC_TRIP_Activity_0s28lb1.code, Lists.newArrayList(org.getManageId()));

    }

    /**
     * 直属上级
     *
     * @param userId
     * @param variables
     */
    private void setFlowResParent(Long userId, HashMap<String, Object> variables, String flowTaskKey) {
        //去掉直属上级2024-04-12版本 #16508
        //再次加上直属上级2024-05-15版本 #17096
        //0521 流程改造 #17161
        PrdOrgEmployeeRefVO userDefaultOrg = cacheUtil.getUserDefaultOrg(userId);
        variables.put("innerResFlag", true);//内部员工
        if (StringUtils.hasText(userDefaultOrg.getExtString6()) && userDefaultOrg.getExtString6().equals("EXTERNAL_RES")) {
            variables.put("innerResFlag", false);
        }
        variables.put("manageResFlag", false);//是否M级
        if (StringUtils.hasText(userDefaultOrg.getExtString2()) && userDefaultOrg.getExtString2().toLowerCase().contains("m")) {
            variables.put("manageResFlag", true);
        }
        //直属上级
        variables.put(flowTaskKey, Lists.newArrayList(userDefaultOrg.getParentId()));
    }


    /**
     * 流程金额额度校验
     *
     * @param reimTotalAmt
     * @param variables
     */
    private void flowAmtLimitCheck(BigDecimal reimTotalAmt, HashMap<String, Object> variables) {
        if (reimTotalAmt.compareTo(reimLimitAmt) > 0) {
            variables.put("limitAmtCheck", true);
        } else {
            variables.put("limitAmtCheck", false);
        }
    }

//
//    /**
//     * 获取费用承担BU事业部负责人
//     *
//     * @param reasonType
//     * @param reasonId
//     * @return
//     */
//    Long getBULevel1ManageId(String reasonType, Long reasonId) {
//        Long orgId = null;
//        //判断事由类型是否为合同项目，决定是否跳过节点
//        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(reasonType)) {
//            PmsProjectVO pmsProjectVO = projectService.queryByKey(reasonId);
//            if (ObjectUtils.isEmpty(pmsProjectVO)) {
//                throw TwException.error("", "当前项目数据不存在,id is " + reasonId);
//            }
//            orgId = pmsProjectVO.getDeliBuId();
//        }
//        if (PmsReasonTypeEnum.PROJ_BU.getCode().equals(reasonType)) {
//            BuProjectVO buProjectVO = buProjectService.queryByKey(reasonId);
//            if (ObjectUtils.isEmpty(buProjectVO)) {
//                throw TwException.error("", "当前BU数据不存在,id is " + reasonId);
//            }
//            orgId = buProjectVO.getDeliBuId();
//        }
//        if (PmsReasonTypeEnum.PROJ_OPPO.getCode().equals(reasonType)) {
//            CrmOpportunityVO crmOpportunityVO = opportunityService.queryByKeySimple(reasonId);
//            if (ObjectUtils.isEmpty(crmOpportunityVO)) {
//                throw TwException.error("", "当前售前数据不存在,id is " + reasonId);
//            }
//            orgId = crmOpportunityVO.getPreSaleOrgId();
//        }
//        //费用承担事业部负责人
//        PrdOrgOrganizationRefVO orgRef = cacheUtil.getBULevel1ByOrgId(orgId);
//        if (orgRef == null) {
//            throw TwException.error("", "费用承担事业部不存在，请联系管理员，buId is  " + orgId);
//        }
//        return orgRef.getManageId();
//    }

    /**
     * 构造报销税额参数
     *
     * @param reimId
     * @param dtl
     * @param taxPayloadList
     */
    private void buildReimTaxList(Long reimId, AccReimDetailPayload dtl, List<AccReimTaxPayload> taxPayloadList) {
        AccReimTaxPayload taxPayload = new AccReimTaxPayload();
        taxPayload.setReimId(reimId);
        taxPayload.setReimDtlId(dtl.getId());
        //固定：应交税金-应交增值税-进项税
        AccFinancialSubjectQuery query = new AccFinancialSubjectQuery();
        query.setAccCode(taxAccCode);
        List<AccFinancialSubjectVO> accFinancialSubjectVOS = accFinancialSubjectService.queryListDynamic(query);
        if (ObjectUtils.isEmpty(accFinancialSubjectVOS)) {
            log.warn("应交税金-应交增值税-进项税编码未在系统维护，请联系管理员进行进项税编码信息的维护！code is {}", taxAccCode);
            throw TwException.error("", "应交税金-应交增值税-进项税编码未在系统维护，请联系管理员进行进项税编码信息的维护！");
        }
        Long taxAccId = accFinancialSubjectVOS.get(0).getId();
        taxPayload.setFinAccSubjId(taxAccId);
        taxPayload.setTaxAmt(dtl.getTaxAmt());
        taxPayload.setTaxRate(dtl.getTaxRate());
        taxPayloadList.add(taxPayload);
    }

    /**
     * 构造报销明细与发票关联
     *
     * @param reimId
     * @param reimDtlId
     * @param invIdList
     * @param invInvoicePayloads
     */
    private void buildInvDocRef(Long reimId, Long reimDtlId, List<Long> invIdList, List<InvInvoicePayload> invInvoicePayloads) {
        invIdList.forEach(
                invId -> {
                    InvInvoicePayload payload = new InvInvoicePayload();
                    payload.setId(invId);
                    payload.setReimId(reimId);
                    payload.setReimDId(reimDtlId);
                    payload.setInvReimStatus(InvoiceReimStatusEnum.OCCUPY.getCode());
                    invInvoicePayloads.add(payload);
                }
        );
    }

    /**
     * 差旅、特殊费用、行政订票需进行申请单的关联
     *
     * @param payload
     */
    private void relateDocHandle(AccReimPayload payload) {
        if (!ObjectUtils.isEmpty(payload.getRelatedDocId())) {
            Long relateDocId = payload.getRelatedDocId();
            //差旅
            if (AccReimDocTypeEnum.ACC_TRIP.getCode().equals(payload.getReimDocType())) {
                AdmBusitripApplyPayload busitripApplyPayload = new AdmBusitripApplyPayload();
                busitripApplyPayload.setId(relateDocId);
                busitripApplyPayload.setReimId(payload.getId());
                busitripApplyService.updateByKeyDynamic(busitripApplyPayload);
            }
            //特殊费用
            if (AccReimDocTypeEnum.ACC_OTHERS.getCode().equals(payload.getReimDocType())) {
                AdmFeeApplyPayload feeApplyPayload = new AdmFeeApplyPayload();
                feeApplyPayload.setId(relateDocId);
                feeApplyPayload.setReimId(payload.getId());
                feeApplyService.updateByKeyDynamic(feeApplyPayload);
            }
        }
        //下述两种仅新增时需要
        //行政订票
        if (Boolean.FALSE.equals(payload.getUpdateFlag()) && !ObjectUtils.isEmpty(payload.getTripTicketIds())
                && AccReimDocTypeEnum.ACC_TRIP_TICKET.getCode().equals(payload.getReimDocType())) {
            payload.getTripTicketIds().forEach(
                    ticketId -> {
                        AdmTripTicketPayload tripTicketPayload = new AdmTripTicketPayload();
                        tripTicketPayload.setId(ticketId);
                        tripTicketPayload.setReimId(payload.getId());
                        tripTicketPayload.setReimbursementStatus(AccReimDocStatusEnum.APPLYING.getCode());
                        admTripTicketService.updateByKeyDynamic(tripTicketPayload);
                    }
            );
        }
        //特殊费用报销(外包)
        if (Boolean.FALSE.equals(payload.getUpdateFlag()) && !ObjectUtils.isEmpty(payload.getEpibolyCostDtlIds())
                && AccReimDocTypeEnum.ACC_OTHERS_SD.getCode().equals(payload.getReimDocType())) {
            ConEpibolyCostConDQuery costConDQuery = new ConEpibolyCostConDQuery();
            costConDQuery.setIdList(payload.getEpibolyCostDtlIds());
            costConDQuery.setAuthAll(true);
            costConDQuery.setQueryDtlFlag(true);
            List<ConEpibolyCostConDVO> conEpibolyCostConDVOS = conEpibolyCostConDService.queryListDynamic(costConDQuery);
            for (ConEpibolyCostConDVO conDVO : conEpibolyCostConDVOS) {
                //已被占用，直接报错
                if (!ObjectUtils.isEmpty(conDVO.getDocType()) || !ObjectUtils.isEmpty(conDVO.getDocumentNumber())) {
                    throw TwException.error("", "当期外包费用确认单明细已被使用，无法再次发起报销！id是：" + conDVO.getId());
                }
                ConEpibolyCostConDPayload costConDPayload = new ConEpibolyCostConDPayload();
                costConDPayload.setId(conDVO.getId());
                costConDPayload.setDocType(AccReimDocTypeEnum.ACC_OTHERS_SD.getDesc());
                costConDPayload.setDocumentNumber(payload.getReimNo());
                conEpibolyCostConDService.updateByKeyDynamic(costConDPayload);
            }
        }
    }

    /**
     * 差旅、特殊费用需进行申请单的释放
     *
     * @param vo
     */
    private void relateDocRelease(AccReimVO vo) {
        if (!ObjectUtils.isEmpty(vo.getRelatedDocId())) {
            Long relateDocId = vo.getRelatedDocId();
            //差旅
            if (AccReimDocTypeEnum.ACC_TRIP.getCode().equals(vo.getReimDocType())) {
                AdmBusitripApplyPayload busitripApplyPayload = new AdmBusitripApplyPayload();
                busitripApplyPayload.setId(relateDocId);
                busitripApplyPayload.setReimDefaultFlag(1);
                busitripApplyService.updateByKeyDynamic(busitripApplyPayload);
            }
            //特殊费用
            if (AccReimDocTypeEnum.ACC_OTHERS.getCode().equals(vo.getReimDocType())) {
                AdmFeeApplyPayload feeApplyPayload = new AdmFeeApplyPayload();
                feeApplyPayload.setId(relateDocId);
                feeApplyPayload.setReimDefaultFlag(1);
                feeApplyService.updateByKeyDynamic(feeApplyPayload);
            }
        }
        //行政订票
        if (Boolean.TRUE.equals(vo.getDelFlag()) && AccReimDocTypeEnum.ACC_TRIP_TICKET.getCode().equals(vo.getReimDocType())) {
            final String unreimStatus = "UNREIM";
            //先获取当前报销单关联的行政订票单据
            AdmTripTicketQuery query = new AdmTripTicketQuery();
            query.setReimId(vo.getId());
            List<AdmTripTicketVO> admTripTicketVOS = admTripTicketService.queryListDynamic(query);
            if (ObjectUtils.isEmpty(admTripTicketVOS)) {
                return;
            }
            List<Long> ticketIds = admTripTicketVOS.stream().map(AdmTripTicketVO::getId).collect(Collectors.toList());
            ticketIds.forEach(
                    ticketId -> {
                        AdmTripTicketPayload payload = new AdmTripTicketPayload();
                        payload.setId(ticketId);
                        payload.setReimbursementStatus(unreimStatus);
                        //置空报销单id
                        List<String> nullFields = new ArrayList<>();
                        nullFields.add("reimId");
                        payload.setNullFields(nullFields);
                        admTripTicketService.updateByKeyDynamic(payload);
                    }
            );
        }
        //特殊费用报销(外包)
        if (Boolean.TRUE.equals(vo.getDelFlag()) && AccReimDocTypeEnum.ACC_OTHERS_SD.getCode().equals(vo.getReimDocType())) {
            ConEpibolyCostConDQuery costConDQuery = new ConEpibolyCostConDQuery();
            costConDQuery.setDocumentNumber(vo.getReimNo());
            costConDQuery.setAuthAll(true);
            costConDQuery.setQueryDtlFlag(true);
            List<ConEpibolyCostConDVO> conEpibolyCostConDVOS = conEpibolyCostConDService.queryListDynamic(costConDQuery);
            if (ObjectUtils.isEmpty(conEpibolyCostConDVOS)) {
                return;
            }
            ConEpibolyCostConDVO conDVO = conEpibolyCostConDVOS.get(0);
            ConEpibolyCostConDPayload costConDPayload = new ConEpibolyCostConDPayload();
            costConDPayload.setId(conDVO.getId());
            List<String> nullFields = new ArrayList<>();
            nullFields.add("docType");
            nullFields.add("documentNumber");
            costConDPayload.setNullFields(nullFields);
            conEpibolyCostConDService.updateByKeyDynamic(costConDPayload);
        }
    }


    /**
     * 构建金额来源明细(目前仅餐费)
     *
     * @param masId
     * @param dtlId
     * @param sourcePayload
     * @return
     */
    private AccReimSourceRecordPayload buildSourceRecord(Long masId, Long dtlId, AccReimSourcePayload sourcePayload) {
        AccReimSourceRecordPayload payload = new AccReimSourceRecordPayload();
        payload.setReimId(masId);
        payload.setReimDtlId(dtlId);
        payload.setSource(sourcePayload);
        return payload;
    }

    /**
     * 检查是否存在重复报销单
     */
    private void checkDuplicateData(Long[] ids) {
        Set<Long> uniqueSet = new HashSet<>();
        boolean hasDuplicates = false;

        for (Long element : ids) {
            if (!uniqueSet.add(element)) {
                // Set的 add方法返回 false 表示元素已存在，说明有重复
                hasDuplicates = true;
                break;
            }
        }
        if (hasDuplicates) {
            throw TwException.error("", "存在重复的待付款报销单数据，请刷新页面重试！");
        }
    }

    /**
     * 银企支付支付前校验
     *
     * @param reimVO
     */
    private void payBackCheck(AccReimVO reimVO) {
        String reimNo = reimVO.getReimNo();
        //若包含行政订票类型直接结束
        if (AccReimDocTypeEnum.ACC_TRIP_TICKET.getCode().equals(reimVO.getReimDocType())) {
            throw TwException.error("", "报销单为行政订票类型，无须进行网银提交！报销单号是：" + reimNo);
        }
        //失败后可再次发起提交 2023-12-19需求定
        /*if (!ObjectUtils.isEmpty(reimVO.getBankFlag()) && 1 == reimVO.getBankFlag()) {
            throw TwException.error("", "报销单已经进行过网银提交，不允许重复提交，报销单号是：" + reimNo);
        }*/
        //已经成功支付
        if (PurchasePaymentEnum.PayStatusEnum.SUCCESS.getCode().equals(reimVO.getPayStatus())) {
            throw TwException.error("", "报销单已经支付成功不允许重复支付，报销单号是：" + reimNo);
        }
        //仅有网银支付的单据才可进行当前操作
        if (!AccReimPayModeEnum.PAY_MODE_1.getCode().equals(reimVO.getPayMode())) {
            throw TwException.error("", "当前报销单不是网银支付方式，无法提交，请重新操作！报销单号是：" + reimNo);
        }
        if (!AccReimDocStatusEnum.PENDING_PAYMENT.getCode().equals(reimVO.getReimStatus())) {
            throw TwException.error("", "当前报销单不是已通过待付款状态，无法进行当前操作！报销单号是：" + reimNo);
        }
        if (ObjectUtils.isEmpty(reimVO.getReimTotalAmt()) && reimVO.getReimTotalAmt().compareTo(BigDecimal.ZERO) <= 0) {
            throw TwException.error("", "当前报销单报销金额为0，不允许提交！报销单号是：" + reimNo);
        }
        if (ObjectUtils.isEmpty(reimVO.getAccountNo()) || ObjectUtils.isEmpty(reimVO.getHolderName())) {
            throw TwException.error("", "收款账户或户名为空");
        }
    }

    /**
     * 构建银企直连的数据
     *
     * @param accReimVO
     * @param bookAccountVO 付款账户信息
     * @param payload
     */
    private void buildPaymentDetail(AccReimVO accReimVO, BookAccountVO bookAccountVO, PayPayload payload,
                                    BigDecimal currentTotalAmt, int currentTotal) {
        payload.setDocId(accReimVO.getId().toString());
        //单据编号（付款申请单号）
        payload.setDocNo(accReimVO.getReimNo());
        //单据类型
        payload.setDocType(PurchasePaymentEnum.BankDocType.REIM.getCode());
        //业务号
        String reimNo = accReimVO.getReimNo();
        // payload.setYurref(accReimVO.getReimNo() + accReimVO.getId());
        payload.setYurref(accReimVO.getId().toString() + "RR" + reimNo.substring(reimNo.length() - 4));
        //收款户名
        payload.setAccnam(accReimVO.getHolderName());
        //收款银行名称
        payload.setAccnamBankName(accReimVO.getBankName());
        //收款账户
        payload.setAccnbr(accReimVO.getAccountNo());
        // 开户行网点
        payload.setCrtbnk(bookAccountVO.getDepositBankOutlet());
        //收方开户行地址
        payload.setCrtadr("");
        //付款户名
        payload.setPayaccnam(bookAccountVO.getAccountName());
        //付款账号
        payload.setPayaccnbr(bookAccountVO.getAccountNo());
        //付款金额
        payload.setTrsamt(accReimVO.getAdjustAmt() == null ? accReimVO.getReimTotalAmt() : accReimVO.getAdjustAmt());
        //网银用途（支付用途）
        payload.setNusage(PurchasePaymentEnum.PayNusage.NUSAGE1.getDesc());
        payload.setUsrId(accReimVO.getReimUserId().toString());
        payload.setUsrName(cacheUtil.getUserName(accReimVO.getReimUserId()));
        payload.setCcynbr(10);//币种人民币默认10
        //系统内标识 Y 收方为招商银行账号      N收方为他行账户
        payload.setBnkflg(PurchasePaymentEnum.PaySystemEnum.YES.getCode());
        if (StringUtils.hasText(accReimVO.getBankName()) && !accReimVO.getBankName().contains("招商")) {
            payload.setBnkflg(PurchasePaymentEnum.PaySystemEnum.NO.getCode());
        }
        payload.setOrderType(PurchasePaymentEnum.OrderTypeEnum.REIM.getCode());
        //总金额
        payload.setTtlamt((currentTotalAmt));
        //总笔数
        payload.setTtlcnt(currentTotal);
        //总次数
        payload.setTtlnum(currentTotal);
        //本次金额
        payload.setCuramt(currentTotalAmt);
        //本次次数
        payload.setCurcnt(currentTotal);
        //判断当前金额是否大于一百万如果大于调用大小额小于调用超网
        if (currentTotalAmt.compareTo(new BigDecimal(1000000)) > 0) {
            payload.setChlflg(PurchasePaymentEnum.PaySystemEnum.NO.getCode());
        } else {
            payload.setChlflg(PurchasePaymentEnum.PaySystemEnum.YES.getCode());
        }
    }

    /**
     * 支付管理-付款发送记录数据构建
     *
     * @param payDetailVO
     */
    private BkPayDetailRecordPayload buildPayDetailRecord(BkPayDetailVO payDetailVO) {
        //付款记录表插入数据
        BkPayDetailRecordPayload payload = new BkPayDetailRecordPayload();
        payload.setBatchFlag(payDetailVO.getBatchFlag());//批量标识
        payload.setBkPayDetailId(payDetailVO.getId());
        payload.setBthnbr(payDetailVO.getBthnbr());
        payload.setYurref(payDetailVO.getYurref());
        payload.setTrxseq(payDetailVO.getTrxseq());
        payload.setPayStatus(PurchasePaymentEnum.PayStatusDetailEnum.SEND.getCode());
        payload.setOrderType(payDetailVO.getOrderType());
        payload.setTrsamt(payDetailVO.getTrsamt());
        return payload;
    }

    /**
     * 构建支付履历信息
     *
     * @param reimVO
     * @return
     */
    private TDocHistPayload buildDocHistory(AccReimVO reimVO, String hisType, String hisDtl) {
        TDocHistPayload tDocHistPayload = new TDocHistPayload();
        tDocHistPayload.setDocId(reimVO.getId());
        tDocHistPayload.setDocNo(reimVO.getReimNo());
        tDocHistPayload.setHistTime(LocalDateTime.now());
        tDocHistPayload.setOwnerId(reimVO.getReimUserId());
        tDocHistPayload.setCreateUserId(reimVO.getCreateUserId());
        tDocHistPayload.setDocType(PurchasePaymentEnum.PayDocType.REIM.getCode());
        tDocHistPayload.setHistType(hisType);
        tDocHistPayload.setHistDtl(hisDtl);
        return tDocHistPayload;
    }

    /**
     * 行政订票报销特殊处理
     *
     * @param vo
     * @param batchType 操作类型
     */
    private void tripTicketRelease(AccReimVO vo, String batchType) {
        if (!AccReimDocTypeEnum.ACC_TRIP_TICKET.getCode().equals(vo.getReimDocType())) {
            return;
        }
        //行政订票无付款操作，直接结束
        if (AccPayBatchTypeEnum.CASHIER.getCode().equals(batchType)) {
            return;
        }
        final String reimedStatus = "REIMED";
        //先获取当前报销单关联的行政订票单据
        AdmTripTicketQuery query = new AdmTripTicketQuery();
        query.setReimId(vo.getId());
        List<AdmTripTicketVO> admTripTicketVOS = admTripTicketService.queryListDynamic(query);
        if (ObjectUtils.isEmpty(admTripTicketVOS)) {
            return;
        }
        List<Long> ticketIds = admTripTicketVOS.stream().map(AdmTripTicketVO::getId).collect(Collectors.toList());
        ticketIds.forEach(
                ticketId -> {
                    AdmTripTicketPayload payload = new AdmTripTicketPayload();
                    payload.setId(ticketId);
                    payload.setReimbursementStatus(reimedStatus);
                    admTripTicketService.updateByKeyDynamic(payload);
                }
        );
    }

    /**
     * 明细查询额外处理
     *
     * @param accReimVO
     */
    private void queyDetailExtraHandle(AccReimVO accReimVO) {
        //行政报销需要额外获取行政报销单信息
        if (AccReimDocTypeEnum.ACC_TRIP_TICKET.getCode().equals(accReimVO.getReimDocType())) {
            AdmTripTicketQuery tripTicketQuery = new AdmTripTicketQuery();
            tripTicketQuery.setReimId(accReimVO.getId());
            List<AdmTripTicketVO> admTripTicketVOS = admTripTicketService.queryListDynamic(tripTicketQuery);
            if (!ObjectUtils.isEmpty(admTripTicketVOS)) {
                List<Long> ticketIds = admTripTicketVOS.stream().map(AdmTripTicketVO::getId).collect(Collectors.toList());
                accReimVO.setTripTicketIds(ticketIds);
            }
        }
        //若为合同项目，获取相关项目及参考合同号
        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(accReimVO.getReasonType())) {
            PmsProjectVO pmsProjectVO = projectService.queryByKey(accReimVO.getReasonId());
            if (!ObjectUtils.isEmpty(pmsProjectVO)) {
                StringBuilder sb = new StringBuilder();
                sb.append(accReimVO.getReasonName()).append("/");
                sb.append(pmsProjectVO.getReferCode());
                accReimVO.setRelateProjAndConNO(sb.toString());
                accReimVO.setConSignOuName(pmsProjectVO.getOuName());
            }
        }
        //获取财务期间
        if (!ObjectUtils.isEmpty(accReimVO.getFinPeriodId())) {
            PrdSystemFinPeriodVO prdSystemFinPeriodVO = finPeriodService.queryByKey(accReimVO.getFinPeriodId());
            if (!ObjectUtils.isEmpty(prdSystemFinPeriodVO)) {
                accReimVO.setFinPeriodName(prdSystemFinPeriodVO.getPeriodName());
            }
        }
        //获取预算信息
        if (!ObjectUtils.isEmpty(accReimVO.getRelatedBudgetId())) {
            BudgetVO budgetVO = budgetService.queryByKey(accReimVO.getRelatedBudgetId());
            if (!ObjectUtils.isEmpty(budgetVO)) {
                accReimVO.setRelatedBudgetName(budgetVO.getBudgetName());
            }
        }
        //附件信息
        if (!ObjectUtils.isEmpty(accReimVO.getFileCode())) {
            Object fileData = fileUtil.getFileDatas(accReimVO.getFileCode());
            accReimVO.setFileData(fileData);
        }
    }

    /**
     * 记账导出数据处理
     */
    @Override
    public void chargeExportDataHandle(List<AccReimExportVO> mainData, Map<Long, List<BusinessPartnerVO>> bookIdMap,
                                       Map<Long, List<PrdOrgOrganizationVO>> orgIdMap, Map<Long, List<PrdOrgEmployeeVO>> userIdMap,
                                       Map<Long, List<PmsProjectVO>> reasonIdMap, String batchNo) {
        //业务伙伴信息
        List<Long> bookIds = mainData.stream().map(AccReimExportVO::getExpenseCompany).collect(Collectors.toList());
        List<BusinessPartnerVO> businessPartnerVOS = businessPartnerService.queryByBookIdsAndType(bookIds, BusinessInsideOrOutSideEnum.INSIDE.getCode());
        if (ObjectUtils.isEmpty(businessPartnerVOS)) {
            log.warn("当前批次对应的报销单费用承担公司信息未维护，请联系管理员进行处理！批次号是 {}", batchNo);
            throw TwException.error("", "当前批次对应的报销单费用承担公司信息未维护，请联系管理员进行处理！");
        }
        bookIdMap.clear();
        bookIdMap.putAll(businessPartnerVOS.stream().collect(Collectors.groupingBy(BusinessPartnerVO::getBookId)));

        //组织信息
        Set<Long> orgIdList = mainData.stream().map(AccReimExportVO::getExpenseOrgId).collect(Collectors.toSet());
        PrdOrgOrganizationQuery orgQuery = new PrdOrgOrganizationQuery();
        orgQuery.setOrgIdList(new ArrayList<>(orgIdList));
        List<PrdOrgOrganizationVO> prdOrgOrganizationVOS = orgOrganizationService.queryAllByQuery(orgQuery);
        if (ObjectUtils.isEmpty(prdOrgOrganizationVOS)) {
            log.warn("当前批次对应的报销单费用承担部门信息未维护，请联系管理员进行处理！批次号是 {}", batchNo);
            throw TwException.error("", "当前批次对应的报销单费用承担部门信息未维护，请联系管理员进行处理！");
        }
        orgIdMap.clear();
        orgIdMap.putAll(prdOrgOrganizationVOS.stream().collect(Collectors.groupingBy(PrdOrgOrganizationVO::getId)));

        //员工信息
        Set<Long> userIdList = mainData.stream().map(AccReimExportVO::getReimUserId).collect(Collectors.toSet());
        PrdOrgEmployeeQuery employeeQuery = new PrdOrgEmployeeQuery();
        employeeQuery.setUserIdList(userIdList);
        List<PrdOrgEmployeeVO> prdOrgEmployeeVOS = employeeService.queryList(employeeQuery);
        if (ObjectUtils.isEmpty(prdOrgEmployeeVOS)) {
            log.warn("当前批次对应的报销单员工信息未维护，请联系管理员进行处理！批次号是 {}", batchNo);
            throw TwException.error("", "当前批次对应的报销单员工信息未维护，请联系管理员进行处理！");
        }
        userIdMap.clear();
        userIdMap.putAll(prdOrgEmployeeVOS.stream().collect(Collectors.groupingBy(PrdOrgEmployeeVO::getUserId)));

        //项目信息
        Set<Long> reasonIdList = mainData.stream().map(AccReimExportVO::getReasonId).collect(Collectors.toSet());
        List<PmsProjectVO> pmsProjectVOS = projectService.queryListByReasonIdList(new ArrayList<>(reasonIdList));
        if (ObjectUtils.isEmpty(pmsProjectVOS)) {
            log.warn("当前批次对应的报销单项目信息未维护，请联系管理员进行处理！批次号是 {}", batchNo);
        }
        reasonIdMap.clear();
        reasonIdMap.putAll(pmsProjectVOS.stream().collect(Collectors.groupingBy(PmsProjectVO::getId)));
    }

    @Override
    public AccReimPrintVO queryPrintPayData(List<Long> batchIdList) {
        AccReimPayBatchQuery query = new AccReimPayBatchQuery();
        query.setIds(batchIdList);
        List<AccReimPayBatchVO> accReimPayBatchVOList = reimPayBatchService.queryListDynamic(query);
        if (CollectionUtils.isEmpty(accReimPayBatchVOList)) {
            throw TwException.error("", "当前记账批次不存在");
        }
        Long userId = GlobalUtil.getLoginUserId();
        String userName = cacheUtil.getUserName(userId);

        AccReimQuery accReimQuery = new AccReimQuery();

        Set<String> collect = accReimPayBatchVOList.stream().filter(accReimPayBatchVO -> !ObjectUtils.isEmpty(accReimPayBatchVO.getBatchNo())).map(p -> p.getBatchNo()).collect(Collectors.toSet());
        accReimQuery.setBatchNoList(new ArrayList<String>(collect));
        List<AccReimVO> accReimVOS = dao.queryListDynamic(accReimQuery);
        AccReimPrintVO accReimPrintVO = new AccReimPrintVO();
        if (!CollectionUtils.isEmpty(accReimVOS)) {
            //拼接批次号和金额
            StringBuilder stringBuilder = new StringBuilder();
            accReimPayBatchVOList.stream().forEach(p -> {
                stringBuilder.append("批次号:" + p.getBatchNo() + " 报销总金额:" + p.getBatchAmt() + "元 \n");
            });
            accReimPrintVO.setBatchNoAndAmt(stringBuilder.toString());
            Long loginUserId = GlobalUtil.getLoginUserId();
            PrdOrgEmployeeVO employee = cacheUtil.getEmployee(loginUserId);
            Long orgId = cacheUtil.getDefaultOrgIdByUserId(loginUserId);
            PrdOrgOrganizationVO org = cacheUtil.getOrg(orgId);
            accReimPrintVO.setEmployeeNo(employee.getEmployeeNo());
            // 部门名称
            accReimPrintVO.setBuName(org.getOrgName());
            if (org != null) {
                // 部门编号
                accReimPrintVO.setOrgCode(org.getOrgCode());
            }
            // 当前打印人
            accReimPrintVO.setApplyName(employee.getEmployeeName());
            // 会计科目-费用
            accReimPrintVO.setAccountSubjectName(ACCOUNT_SUBJECT_NAME);
            //会计科目-银行存款-招行
            accReimPrintVO.setBankSubjectName(BANK_SUBJECT_NAME);
            // 费用凭证摘要
            accReimPrintVO.setExpenseProofDigest(accReimVOS.get(0).getExpenseProofDigest());

            BigDecimal totalAmt = BigDecimal.ZERO;
            List<AccReimPrintDetailVO> accReimPrintDetailVOList = new ArrayList<>();
            //
            for (AccReimVO vo : accReimVOS) {
                AccReimPrintDetailVO accReimPrintDetailVO = new AccReimPrintDetailVO();
                // 批次号
                accReimPrintDetailVO.setBatchNo(vo.getBatchNo());
                // 报销单号
                accReimPrintDetailVO.setReimNo(vo.getReimNo());
                // 报销人
                accReimPrintDetailVO.setReimName(cacheUtil.getUserName(vo.getReimUserId()));
                // 报销金额
                accReimPrintDetailVO.setReimAmt(vo.getReimTotalAmt());
                // 报销人账号
                accReimPrintDetailVO.setAccountNo(vo.getAccountNo());
                // 导出人
                accReimPrintDetailVO.setExportName(userName);
                // 报销时间
                accReimPrintDetailVO.setReimTime(TimeUtil.datetime2String(accReimPayBatchVOList.get(0).getBatchTime()));
                accReimPrintDetailVOList.add(accReimPrintDetailVO);
                totalAmt = totalAmt.add(vo.getReimTotalAmt());
            }
            // 报销明细总金额
            accReimPrintVO.setTotalAmt(totalAmt);
            //金额1
            accReimPrintVO.setCredit(totalAmt);
            // 金额2
            accReimPrintVO.setDebit(totalAmt);
            accReimPrintVO.setAccReimPrintDetailVOList(accReimPrintDetailVOList);
        }
        return accReimPrintVO;
    }

    /**
     * 获取财务期间
     *
     * @return
     */
    private Long getFinPeriod() {
        PrdSystemFinPeriodQuery query = new PrdSystemFinPeriodQuery();
        //当月
        LocalDate now = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
        String periodName = now.format(formatter);
        query.setPeriodName(periodName);
        //query.setPeriodStatus();
        List<PrdSystemFinPeriodVO> prdSystemFinPeriodVOS = finPeriodService.queryListDynamic(query);
        if (ObjectUtils.isEmpty(prdSystemFinPeriodVOS)) {
            throw TwException.error("", "当前日期的财务期间未维护，请联系系统管理员!");
        }
        PrdSystemFinPeriodVO prdSystemFinPeriodVO = prdSystemFinPeriodVOS.get(0);
        return prdSystemFinPeriodVO.getId();
    }

    @Override
    public List<AccReimExportVO> getExportChargeData(String batchNo) {
        return dao.getExportChargeData(batchNo);
    }


    @Override
    public List<AccReimExportVO> getExportChargeDataByKeys(List<Long> keys) {
        return dao.getExportChargeDataByKeys(keys);
    }

    @Override
    @Transactional
    public void updateAccountDigestAndStatusByKeys(List<Long> keys, String expenseProofDigest, String expenseProofNo, String expenseProofStatus, String expenseProofFailReason) {
        dao.updateAccountDigestAndStatusByKeys(keys, expenseProofDigest, expenseProofNo, expenseProofStatus, expenseProofFailReason);
    }

    @Override
    @Transactional
    public void updatePayDigestAndStatusByKeys(List<Long> keys, String payProofDigest, String payProofNo, String payProofStatus, String payProofFailReason) {
        dao.updatePayDigestAndStatusByKeys(keys, payProofDigest, payProofNo, payProofStatus, payProofFailReason);
    }

    @Override
    @Transactional
    public void batchPayCharge(List<Long> keys, String payProofDigest) {
        AccReimQuery accReimQuery = new AccReimQuery();
        accReimQuery.setIdList(keys);
        List<AccReimVO> accReimVOS = dao.queryListDynamic(accReimQuery);
        dao.updatePayDigestAndStatusByKeys(keys, null, null, null, null);
    }
}
