package com.elitesland.tw.tw5.server.prd.acc.service;


import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSourceDetailPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSourcePayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSourceRecordPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSourceRecordQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSourceRecordService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSourceRecordVO;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimSourceRecordConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimSourceRecordDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSourceRecordDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSourceRecordRepo;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * 报销金额来源记录管理
 *
 * @author sunxw
 * @date 2023-12-04
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AccReimSourceRecordServiceImpl extends BaseServiceImpl implements AccReimSourceRecordService {

    private final AccReimSourceRecordRepo repo;
    private final AccReimSourceRecordDAO dao;
    private final FileUtil fileUtil;
    @Override
    public PagingVO<AccReimSourceRecordVO> queryPaging(AccReimSourceRecordQuery query) {
        return dao.queryPaging(query);
    }

    @Override
    public List<AccReimSourceRecordVO> queryListDynamic(AccReimSourceRecordQuery query) {
        List<AccReimSourceRecordVO> vos = dao.queryListDynamic(query);
        if (ObjectUtils.isEmpty(vos)) {
            log.warn("当前查询信息 {} 获取的报销金额来源记录为空", query);
            return vos;
        }
        vos.forEach(
                vo ->{
                    AccReimSourcePayload accReimSourcePayload = JSON.parseObject(vo.getContent(), AccReimSourcePayload.class);
                    // 处理非差旅报销的加班附件
                    List<AccReimSourceDetailPayload> details = accReimSourcePayload.getDetails();
                    if(!CollectionUtils.isEmpty(details)){
                        for (AccReimSourceDetailPayload detail : details) {
                            if(StringUtils.hasText(detail.getFileCodes())){
                                detail.setFileDates(fileUtil.getFileDatas(detail.getFileCodes()));
                            }
                        }
                    }
                    vo.setSource(accReimSourcePayload);
                }
        );
        return vos;
    }

    @Override
    public AccReimSourceRecordVO queryByKey(Long key) {
        return dao.queryByKey(key);
    }

    @Override
    @Transactional
    public AccReimSourceRecordVO insert(AccReimSourceRecordPayload payload) {
        String content = JSON.toJSONString(payload.getSource());
        payload.setContent(content);
        AccReimSourceRecordDO entityDo = AccReimSourceRecordConvert.INSTANCE.toDo(payload);
        return AccReimSourceRecordConvert.INSTANCE.toVo(repo.save(entityDo));
    }

    @Override
    @Transactional
    public AccReimSourceRecordVO update(AccReimSourceRecordPayload payload) {
        AccReimSourceRecordDO entity = repo.findById(payload.getId()).orElseGet(AccReimSourceRecordDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AccReimSourceRecordDO entityDo = AccReimSourceRecordConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AccReimSourceRecordConvert.INSTANCE.toVo(repo.save(entity));
    }

    @Override
    @Transactional
    public long updateByKeyDynamic(AccReimSourceRecordPayload payload) {
        AccReimSourceRecordDO entity = repo.findById(payload.getId()).orElseGet(AccReimSourceRecordDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = dao.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            dao.deleteSoft(keys);
        }
    }

    @Override
    @Transactional
    public void delByReimId(Long reimId) {
        dao.delByReimId(reimId);
    }

}
