package com.elitesland.tw.tw5.server.prd.budget.dao;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.budget.payload.BudgetPayload;
import com.elitesland.tw.tw5.api.prd.budget.query.BudgetQuery;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.budget.entity.BudgetDO;
import com.elitesland.tw.tw5.server.prd.budget.entity.QBudgetDO;
import com.elitesland.tw.tw5.server.prd.budget.repo.BudgetRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 预算基本信息
 *
 * @author xxb
 * @date 2023-11-01
 */
@Repository
@RequiredArgsConstructor
public class BudgetDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final BudgetRepo repo;
    private final QBudgetDO qdo = QBudgetDO.budgetDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<BudgetVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(BudgetVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                // 预算名称
                qdo.budgetName,
                // 预算状态：新建、审批中、激活（已审批）、关闭
                qdo.budgetStatus,
                // 版本号
                qdo.versionNo,
                // 流程名字
                qdo.procInstName,
                // 流程实例ID
                qdo.procInstId,
                // 流程审批状态
                qdo.procInstStatus,
                // 审批时间
                qdo.approvedTime,
                // 是否可选择 0 false 不可选择 1 true 可选择
                qdo.selectFlag,
                // 预算编码
                qdo.budgetCode,
                // 费用归属：合同项目、BU项目、商机
                qdo.sourceType,
                // 费用归属ID
                qdo.sourceId,
                // 控制类型：刚性、 柔性 、不控制
                qdo.controlType,
                // 开始日期
                qdo.budgetStartDate,
                // 结束日期
                qdo.budgetEndDate,
                // 申请人
                qdo.applyResId,
                // 申请日期
                qdo.applyDate,
                // 拓展字段1
                qdo.extVarchar1,
                // 拓展字段2
                qdo.extVarchar2,
                // 拓展字段3
                qdo.extVarchar3,
                // 拓展字段4
                qdo.extVarchar4,
                // 拓展字段5
                qdo.extVarchar5,
                // 拓展字段6
                qdo.extVarchar6,
                // 拓展字段7
                qdo.extVarchar7,
                // 拓展字段8
                qdo.extVarchar8,
                // 拓展字段9
                qdo.extVarchar9,
                // 预算附件
                qdo.budgetFiles,
                // 流程定义的KEY
                qdo.procDefKey,
                // 预算年度
                qdo.finYear,
                // 预算总金额
                qdo.totalAmt,
                // 原始预算总金额
                qdo.originalTotalAmt,
                // 规划费用金额
                qdo.planAmt,
                // 原始规划费用金额
                qdo.originalPlanAmt,
                // 规划当量数金额
                qdo.planEqva,
                // 原始当量规划当量数
                qdo.planEqvaAmt,
                // 原始规划当量数
                qdo.originalPlanEqva,
                // 原始规划当量数金额
                qdo.originalPlanEqvaAmt,
                // 已拨付费用金额
                qdo.allocatedAmt,
                // 已拨付当量数
                qdo.allocatedEqva,
                // 已拨付当量数金额
                qdo.allocatedEqvaAmt,
                // 已拨付总金额
                qdo.allocatedTotalAmt,
                // 费用来源编码
                qdo.sourceCode,
                // 费用来源名称
                qdo.sourceName,
                // 交付BU_ID
                qdo.deliBuId,
                // 科目模板id
                qdo.subjectTempId,
                // 当量预估单价
                qdo.eqvaPrice,
                qdo.usedAmt,
                qdo.occupyAmt,
                qdo.occupyEqva,
                qdo.usedEqva,
                qdo.usedEqvaProportion,
                qdo.usedAmtProportion,
                qdo.allocatedAppropriation
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<BudgetVO> getJpaQueryWhere(BudgetQuery query) {
        JPAQuery<BudgetVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(BudgetQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        Long total = jpaQuery.fetchOne();
        total=total==null?0L:total;
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(BudgetQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        if (StringUtils.hasText(query.getKeyword())) {
            list.add(qdo.budgetName.like(SqlUtil.toSqlLikeString(query.getKeyword())).or(qdo.budgetCode.like(SqlUtil.toSqlLikeString(query.getKeyword()))));
        }
        /** 预算名称 精确 */
        if (!ObjectUtils.isEmpty(query.getBudgetName())) {
            list.add(qdo.budgetName.eq(query.getBudgetName()));
        }
        /** 预算状态：新建、审批中、激活（已审批）、关闭 精确 */
        if (!ObjectUtils.isEmpty(query.getBudgetStatus())) {
            list.add(qdo.budgetStatus.eq(query.getBudgetStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getSourceCode())) {
            list.add(qdo.sourceCode.eq(query.getSourceCode()));
        }

        if (!ObjectUtils.isEmpty(query.getSourceName())) {
            list.add(qdo.sourceName.eq(query.getSourceName()));
        }
        if (!ObjectUtils.isEmpty(query.getDeliBuId())) {
            list.add(qdo.deliBuId.eq(query.getDeliBuId()));
        }
        /** 版本号 精确 */
        if (!ObjectUtils.isEmpty(query.getVersionNo())) {
            list.add(qdo.versionNo.eq(query.getVersionNo()));
        }
        /** 流程名字 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstName())) {
            list.add(qdo.procInstName.eq(query.getProcInstName()));
        }
        /** 流程实例ID 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstId())) {
            list.add(qdo.procInstId.eq(query.getProcInstId()));
        }
        /** 流程审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            list.add(qdo.procInstStatus.eq(query.getProcInstStatus()));
        }
        /** 审批时间 精确 */
        if (!ObjectUtils.isEmpty(query.getApprovedTime())) {
            list.add(qdo.approvedTime.eq(query.getApprovedTime()));
        }
        /** 是否可选择 0 false 不可选择 1 true 可选择 精确 */
        if (!ObjectUtils.isEmpty(query.getSelectFlag())) {
            list.add(qdo.selectFlag.eq(query.getSelectFlag()));
        }
        /** 预算编码 精确 */
        if (!ObjectUtils.isEmpty(query.getBudgetCode())) {
            list.add(qdo.budgetCode.eq(query.getBudgetCode()));
        }
        /** 费用归属：合同项目、BU项目、商机项目 精确 */
        if (!ObjectUtils.isEmpty(query.getSourceType())) {
            list.add(qdo.sourceType.eq(query.getSourceType()));
        }
        /** 费用归属ID 精确 */
        if (!ObjectUtils.isEmpty(query.getSourceId())) {
            list.add(qdo.sourceId.eq(query.getSourceId()));
        }
        /** 控制类型：刚性、 柔性 、不控制 精确 */
        if (!ObjectUtils.isEmpty(query.getControlType())) {
            list.add(qdo.controlType.eq(query.getControlType()));
        }
        /** 开始日期 精确 */
        if (!ObjectUtils.isEmpty(query.getBudgetStartDate())) {
            list.add(qdo.budgetStartDate.eq(query.getBudgetStartDate()));
        }
        /** 结束日期 精确 */
        if (!ObjectUtils.isEmpty(query.getBudgetEndDate())) {
            list.add(qdo.budgetEndDate.eq(query.getBudgetEndDate()));
        }
        /** 申请人 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyResId())) {
            list.add(qdo.applyResId.eq(query.getApplyResId()));
        }
        /** 申请日期 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyDate())) {
            list.add(qdo.applyDate.eq(query.getApplyDate()));
        }
        /** 拓展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExtVarchar1())) {
            list.add(qdo.extVarchar1.eq(query.getExtVarchar1()));
        }
        /** 拓展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExtVarchar2())) {
            list.add(qdo.extVarchar2.eq(query.getExtVarchar2()));
        }
        /** 拓展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExtVarchar3())) {
            list.add(qdo.extVarchar3.eq(query.getExtVarchar3()));
        }
        /** 拓展字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExtVarchar4())) {
            list.add(qdo.extVarchar4.eq(query.getExtVarchar4()));
        }
        /** 拓展字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExtVarchar5())) {
            list.add(qdo.extVarchar5.eq(query.getExtVarchar5()));
        }
        /** 拓展字段6 精确 */
        if (!ObjectUtils.isEmpty(query.getExtVarchar6())) {
            list.add(qdo.extVarchar6.eq(query.getExtVarchar6()));
        }
        /** 拓展字段7 精确 */
        if (!ObjectUtils.isEmpty(query.getExtVarchar7())) {
            list.add(qdo.extVarchar7.eq(query.getExtVarchar7()));
        }
        /** 拓展字段8 精确 */
        if (!ObjectUtils.isEmpty(query.getExtVarchar8())) {
            list.add(qdo.extVarchar8.eq(query.getExtVarchar8()));
        }
        /** 拓展字段9 精确 */
        if (!ObjectUtils.isEmpty(query.getExtVarchar9())) {
            list.add(qdo.extVarchar9.eq(query.getExtVarchar9()));
        }
        /** 预算附件 精确 */
        if (!ObjectUtils.isEmpty(query.getBudgetFiles())) {
            list.add(qdo.budgetFiles.eq(query.getBudgetFiles()));
        }
        /** 流程定义的KEY 精确 */
        if (!ObjectUtils.isEmpty(query.getProcDefKey())) {
            list.add(qdo.procDefKey.eq(query.getProcDefKey()));
        }
        /** 预算年度 精确 */
        if (!ObjectUtils.isEmpty(query.getFinYear())) {
            list.add(qdo.finYear.eq(query.getFinYear()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public BudgetVO queryByKey(Long id) {
        JPAQuery<BudgetVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    public List<BudgetVO> queryByKeys(List<Long> ids) {
        JPAQuery<BudgetVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.in(ids));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<BudgetVO> queryListDynamic(BudgetQuery query) {
        JPAQuery<BudgetVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<BudgetVO> queryPaging(BudgetQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<BudgetVO> jpaQuery = getJpaQueryWhere(query);
        List<BudgetVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<BudgetVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public BudgetDO save(BudgetDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<BudgetDO> saveAll(List<BudgetDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(BudgetPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 预算名称
        if (payload.getBudgetName() != null) {
            update.set(qdo.budgetName, payload.getBudgetName());
        }
        // 费用归属：合同项目、BU项目、商机项目
        if (payload.getSourceType() != null) {
            update.set(qdo.sourceType, payload.getSourceType());
        }
        // 费用归属ID
        if (payload.getSourceId() != null) {
            update.set(qdo.sourceId, payload.getSourceId());
        }
        if (payload.getSourceCode() != null) {
            update.set(qdo.sourceCode, payload.getSourceCode());
        }
        if (payload.getSourceName() != null) {
            update.set(qdo.sourceName, payload.getSourceName());
        }
        if (payload.getDeliBuId() != null) {
            update.set(qdo.deliBuId, payload.getDeliBuId());
        }
        if (payload.getSubjectTempId() != null) {
            update.set(qdo.subjectTempId, payload.getSubjectTempId());
        }
        // 预算状态：新建、审批中、激活（已审批）、关闭
        if (payload.getBudgetStatus() != null) {
            update.set(qdo.budgetStatus, payload.getBudgetStatus());
        }
        // 版本号
        if (payload.getVersionNo() != null) {
            update.set(qdo.versionNo, payload.getVersionNo());
        }
        // 流程名字
        if (payload.getProcInstName() != null) {
            update.set(qdo.procInstName, payload.getProcInstName());
        }
        // 流程实例ID
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        // 流程审批状态
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        // 审批时间
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        // 是否可选择 0 false 不可选择 1 true 可选择
        if (payload.getSelectFlag() != null) {
            update.set(qdo.selectFlag, payload.getSelectFlag());
        }
        // 预算编码
        if (payload.getBudgetCode() != null) {
            update.set(qdo.budgetCode, payload.getBudgetCode());
        }
        // 控制类型：刚性、 柔性 、不控制
        if (payload.getControlType() != null) {
            update.set(qdo.controlType, payload.getControlType());
        }
        // 开始日期
        if (payload.getBudgetStartDate() != null) {
            update.set(qdo.budgetStartDate, payload.getBudgetStartDate());
        }
        // 结束日期
        if (payload.getBudgetEndDate() != null) {
            update.set(qdo.budgetEndDate, payload.getBudgetEndDate());
        }
        // 申请人
        if (payload.getApplyResId() != null) {
            update.set(qdo.applyResId, payload.getApplyResId());
        }
        // 申请日期
        if (payload.getApplyDate() != null) {
            update.set(qdo.applyDate, payload.getApplyDate());
        }
        // 拓展字段1
        if (payload.getExtVarchar1() != null) {
            update.set(qdo.extVarchar1, payload.getExtVarchar1());
        }
        // 拓展字段2
        if (payload.getExtVarchar2() != null) {
            update.set(qdo.extVarchar2, payload.getExtVarchar2());
        }
        // 拓展字段3
        if (payload.getExtVarchar3() != null) {
            update.set(qdo.extVarchar3, payload.getExtVarchar3());
        }
        // 拓展字段4
        if (payload.getExtVarchar4() != null) {
            update.set(qdo.extVarchar4, payload.getExtVarchar4());
        }
        // 拓展字段5
        if (payload.getExtVarchar5() != null) {
            update.set(qdo.extVarchar5, payload.getExtVarchar5());
        }
        // 拓展字段6
        if (payload.getExtVarchar6() != null) {
            update.set(qdo.extVarchar6, payload.getExtVarchar6());
        }
        // 拓展字段7
        if (payload.getExtVarchar7() != null) {
            update.set(qdo.extVarchar7, payload.getExtVarchar7());
        }
        // 拓展字段8
        if (payload.getExtVarchar8() != null) {
            update.set(qdo.extVarchar8, payload.getExtVarchar8());
        }
        // 拓展字段9
        if (payload.getExtVarchar9() != null) {
            update.set(qdo.extVarchar9, payload.getExtVarchar9());
        }
        // 预算附件
        if (payload.getBudgetFiles() != null) {
            update.set(qdo.budgetFiles, payload.getBudgetFiles());
        }
        // 流程定义的KEY
        if (payload.getProcDefKey() != null) {
            update.set(qdo.procDefKey, payload.getProcDefKey());
        }
        // 预算年度
        if (payload.getFinYear() != null) {
            update.set(qdo.finYear, payload.getFinYear());
        }
        // 预算总金额
        if (payload.getTotalAmt() != null) {
            update.set(qdo.totalAmt, payload.getTotalAmt());
        }
        // 原始预算总金额
        if (payload.getOriginalTotalAmt() != null) {
            update.set(qdo.originalTotalAmt, payload.getOriginalTotalAmt());
        }
        // 规划费用金额
        if (payload.getPlanAmt() != null) {
            update.set(qdo.planAmt, payload.getPlanAmt());
        }
        // 原始规划费用金额
        if (payload.getOriginalPlanAmt() != null) {
            update.set(qdo.originalPlanAmt, payload.getOriginalPlanAmt());
        }
        // 原始当量
        if (payload.getOriginalPlanEqva() != null) {
            update.set(qdo.originalPlanEqva, payload.getOriginalPlanEqva());
        }
        // 原始当量金额
        if (payload.getOriginalPlanEqvaAmt() != null) {
            update.set(qdo.originalPlanEqvaAmt, payload.getOriginalPlanEqvaAmt());
        }
        // 当量预算总数
        if (payload.getPlanEqva() != null) {
            update.set(qdo.planEqva, payload.getPlanEqva());
        }
        // 当量预算总金额
        if (payload.getPlanEqvaAmt() != null) {
            update.set(qdo.planEqvaAmt, payload.getPlanEqvaAmt());
        }
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        if (payload.getUsedAmt() != null) {
            update.set(qdo.usedAmt, payload.getUsedAmt());
        }
        if (payload.getOccupyEqva() != null) {
            update.set(qdo.occupyEqva, payload.getOccupyEqva());
        }
        if (payload.getUsedEqva() != null) {
            update.set(qdo.usedEqva, payload.getUsedEqva());
        }
        if (payload.getOccupyAmt() != null) {
            update.set(qdo.occupyAmt, payload.getOccupyAmt());
        }
        if (payload.getUsedEqvaProportion() != null) {
            update.set(qdo.usedEqvaProportion, payload.getUsedEqvaProportion());
        }
        if (payload.getUsedAmtProportion() != null) {
            update.set(qdo.usedAmtProportion, payload.getUsedAmtProportion());
        }
        if (payload.getAllocatedAppropriation() != null) {
            update.set(qdo.allocatedAppropriation, payload.getAllocatedAppropriation());
        }
        if (payload.getDeleteFlag() != null) {
            update.set(qdo.deleteFlag, payload.getDeleteFlag());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 预算名称
            if (nullFields.contains("budgetName")) {
                update.setNull(qdo.budgetName);
            }
            // 预算状态：新建、审批中、激活（已审批）、关闭
            if (nullFields.contains("budgetStatus")) {
                update.setNull(qdo.budgetStatus);
            }
            // 版本号
            if (nullFields.contains("versionNo")) {
                update.setNull(qdo.versionNo);
            }
            // 流程名字
            if (nullFields.contains("procInstName")) {
                update.setNull(qdo.procInstName);
            }
            // 流程实例ID
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
            // 流程审批状态
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            // 审批时间
            if (nullFields.contains("approvedTime")) {
                update.setNull(qdo.approvedTime);
            }
            // 是否可选择 0 false 不可选择 1 true 可选择
            if (nullFields.contains("selectFlag")) {
                update.setNull(qdo.selectFlag);
            }
            // 预算编码
            if (nullFields.contains("budgetCode")) {
                update.setNull(qdo.budgetCode);
            }
            // 费用归属：合同项目、BU项目、商机项目
            if (nullFields.contains("sourceType")) {
                update.setNull(qdo.sourceType);
            }
            // 费用归属ID
            if (nullFields.contains("sourceId")) {
                update.setNull(qdo.sourceId);
            }
            // 控制类型：刚性、 柔性 、不控制
            if (nullFields.contains("controlType")) {
                update.setNull(qdo.controlType);
            }
            // 开始日期
            if (nullFields.contains("budgetStartDate")) {
                update.setNull(qdo.budgetStartDate);
            }
            // 结束日期
            if (nullFields.contains("budgetEndDate")) {
                update.setNull(qdo.budgetEndDate);
            }
            // 申请人
            if (nullFields.contains("applyResId")) {
                update.setNull(qdo.applyResId);
            }
            // 申请日期
            if (nullFields.contains("applyDate")) {
                update.setNull(qdo.applyDate);
            }
            // 拓展字段1
            if (nullFields.contains("extVarchar1")) {
                update.setNull(qdo.extVarchar1);
            }
            // 拓展字段2
            if (nullFields.contains("extVarchar2")) {
                update.setNull(qdo.extVarchar2);
            }
            // 拓展字段3
            if (nullFields.contains("extVarchar3")) {
                update.setNull(qdo.extVarchar3);
            }
            // 拓展字段4
            if (nullFields.contains("extVarchar4")) {
                update.setNull(qdo.extVarchar4);
            }
            // 拓展字段5
            if (nullFields.contains("extVarchar5")) {
                update.setNull(qdo.extVarchar5);
            }
            // 拓展字段6
            if (nullFields.contains("extVarchar6")) {
                update.setNull(qdo.extVarchar6);
            }
            // 拓展字段7
            if (nullFields.contains("extVarchar7")) {
                update.setNull(qdo.extVarchar7);
            }
            // 拓展字段8
            if (nullFields.contains("extVarchar8")) {
                update.setNull(qdo.extVarchar8);
            }
            // 拓展字段9
            if (nullFields.contains("extVarchar9")) {
                update.setNull(qdo.extVarchar9);
            }
            // 预算附件
            if (nullFields.contains("budgetFiles")) {
                update.setNull(qdo.budgetFiles);
            }
            // 流程定义的KEY
            if (nullFields.contains("procDefKey")) {
                update.setNull(qdo.procDefKey);
            }
            // 预算年度
            if (nullFields.contains("finYear")) {
                update.setNull(qdo.finYear);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }


    /**
     * 根据费用归属 来查询
     *
     * @param sourceId
     * @param sourceType
     * @return
     */
    public BudgetVO querySimpleBySource(Long sourceId, String sourceType) {
        JPAQuery<BudgetVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.sourceId.eq(sourceId));
        jpaQuery.where(qdo.sourceType.eq(sourceType));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }


    public void updateAllocatedAmt(Long budgetId, BigDecimal allocatedAmt, BigDecimal allocatedEqva, BigDecimal allocatedEqvaAmt, BigDecimal allocatedTotalAmt) {
        jpaQueryFactory.update(qdo)
                .set(qdo.allocatedAmt, allocatedAmt)
                .set(qdo.allocatedEqva, allocatedEqva)
                .set(qdo.allocatedEqvaAmt, allocatedEqvaAmt)
                .set(qdo.allocatedTotalAmt, allocatedTotalAmt)
                .where(qdo.id.eq(budgetId))
                .execute();

    }

}

