package com.elitesland.tw.tw5.server.prd.cal.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalAccountFreezePayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalAccountFreezeQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalAccountFreezeService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalAccountFreezeVO;
import com.elitesland.tw.tw5.server.prd.cal.convert.CalAccountFreezeConvert;
import com.elitesland.tw.tw5.server.prd.cal.dao.CalAccountFreezeDAO;
import com.elitesland.tw.tw5.server.prd.cal.entity.CalAccountFreezeDO;
import com.elitesland.tw.tw5.server.prd.cal.repo.CalAccountFreezeRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 核算-账户冻结记录管理
 *
 * @author carl
 * @date 2023-11-13
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CalAccountFreezeServiceImpl extends BaseServiceImpl implements CalAccountFreezeService {

    private final CalAccountFreezeRepo calAccountFreezeRepo;
    private final CalAccountFreezeDAO calAccountFreezeDAO;

    @Override
    public PagingVO<CalAccountFreezeVO> queryPaging(CalAccountFreezeQuery query) {
        if (query.getAccId() == null) {
            return null;
        }
        return calAccountFreezeDAO.queryPaging(query);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CalAccountFreezeVO insert(CalAccountFreezePayload payload) {
        CalAccountFreezeDO entityDo = CalAccountFreezeConvert.INSTANCE.toDo(payload);
        return CalAccountFreezeConvert.INSTANCE.toVo(calAccountFreezeRepo.save(entityDo));
    }

    @Override
    public void batchInsert(List<CalAccountFreezePayload> payloads) {
        List<CalAccountFreezeDO> dos = CalAccountFreezeConvert.INSTANCE.toDos(payloads);
        calAccountFreezeDAO.saveAll(dos);
    }

//
//    @Override
//    public List<CalAccountFreezeVO> queryListDynamic(CalAccountFreezeQuery query) {
//        return calAccountFreezeDAO.queryListDynamic(query);
//    }
//
//    @Override
//    public CalAccountFreezeVO queryByKey(Long key) {
//        CalAccountFreezeDO entity = calAccountFreezeRepo.findById(key).orElseGet(CalAccountFreezeDO::new);
//        Assert.notNull(entity.getId(), "不存在");
//        CalAccountFreezeVO vo = CalAccountFreezeConvert.INSTANCE.toVo(entity);
//        return vo;
//    }
//

//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public CalAccountFreezeVO update(CalAccountFreezePayload payload) {
//        CalAccountFreezeDO entity = calAccountFreezeRepo.findById(payload.getId()).orElseGet(CalAccountFreezeDO::new);
//        Assert.notNull(entity.getId(), "不存在");
//        CalAccountFreezeDO entityDo = CalAccountFreezeConvert.INSTANCE.toDo(payload);
//        entity.copy(entityDo);
//        return CalAccountFreezeConvert.INSTANCE.toVo(calAccountFreezeRepo.save(entity));
//    }
//
//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public long updateByKeyDynamic(CalAccountFreezePayload payload) {
//        CalAccountFreezeDO entity = calAccountFreezeRepo.findById(payload.getId()).orElseGet(CalAccountFreezeDO::new);
//        Assert.notNull(entity.getId(), "不存在");
//        long result = calAccountFreezeDAO.updateByKeyDynamic(payload);
//        return result;
//    }
//
//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public void deleteSoft(List<Long> keys) {
//        if (!keys.isEmpty()) {
//            keys.stream().forEach(id -> {
//                Optional<CalAccountFreezeDO> optional = calAccountFreezeRepo.findById(id);
//                if (!optional.isEmpty()) {
//                    CalAccountFreezeDO entity = optional.get();
//                    calAccountFreezeRepo.save(entity);
//                }
//            });
//        }
//    }

}
