package com.elitesland.tw.tw5.server.prd.common.functionEnum;

import lombok.Getter;

public enum ReceStatusEnum {


    /**
     * 未开票
     */
    NO_INVOICE("1", "未开票"),
    /**
     * 部分付款
     */
    PART_PAYMENT("2", "部分收款"),
    /**
     * 全部付款
     */
    FULL_PAYMENT("3", "已全额收款"),
    /**
     * 已开票
     */
    OK_INVOICE("4", "已开票");
    ;

    @Getter
    private final String code;

    /**
     * 描述
     */
    @Getter
    private final String desc;

    ReceStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ReceStatusEnum getByCode(String code) {
        for (ReceStatusEnum value : ReceStatusEnum.values()) {
            if (value.getCode().equals(code)){
                return value;
            }
        }
        return null;
    }
}
