package com.elitesland.tw.tw5.server.prd.common.functionEnum;

import lombok.Getter;

/**
 * @author likunpeng
 * @date 2023/7/18
 */
public enum SaleConEnum {

    /**
     * 平台合同类型[salecon:plat_type]
     */
    FICTITIOUS("FICTITIOUS", "虚拟合同", "平台合同类型"),
    NO_CONTRACT_VIRTUAL_CONTRACT("NO_CONTRACT_VIRTUAL_CONTRACT", "无合同入场虚拟合同", "平台合同类型"),
    EXTERNAL("EXTERNAL", "平台外合同", "平台合同类型"),
    INTERNAL("INTERNAL", "平台内合同", "平台合同类型"),

    /**
     * 主子合同类型[salecon:mainType]
     */
    SUB("SUB", "子合同", "主子合同类型"),
    MAIN("MAIN", "主合同", "主子合同类型"),

    /**
     * 范围性质[salecon:range_property]
     */
    HALF_OPEN("HALF_OPEN", "半开口合同", "范围性质"),
    CLOSED("CLOSED", "闭口合同", "范围性质"),
    OPEN("OPEN", "开口合同", "范围性质"),
    ;


    @Getter
    private final String code;
    @Getter
    private final String desc;
    @Getter
    private final String type;

    SaleConEnum(String code, String desc, String type) {
        this.code = code;
        this.desc = desc;
        this.type = type;
    }
}
