package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityMeasureDRepo;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityMeasureDDAO;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpportunityMeasureDConvert;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityMeasureDService;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityMeasureDPayload;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityMeasureDDO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityMeasureDVO;
import org.springframework.stereotype.Service;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * 商机成单率计算指标详情
 *
 * @author likunpeng
 * @date 2023-11-03
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmOpportunityMeasureDServiceImpl extends BaseServiceImpl implements CrmOpportunityMeasureDService {

    private final CrmOpportunityMeasureDDAO crmOpportunityMeasureDDAO;


    @Override
    public List<CrmOpportunityMeasureDVO> queryAll() {
        return crmOpportunityMeasureDDAO.queryAll();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long deleteSoftByMeasureId(List<Long> measureIds) {
        if (CollectionUtils.isEmpty(measureIds)) {
            return null;
        }
        return crmOpportunityMeasureDDAO.deleteSoftByMeasureId(measureIds);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long deleteSoft(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        return crmOpportunityMeasureDDAO.deleteSoft(ids);
    }


}
