package com.elitesland.tw.tw5.server.prd.humanresources.examination.entity;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluatePayload;
import com.elitesland.tw.tw5.server.prd.humanresources.base.WorkflowBaseDO;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;

import org.hibernate.annotations.Where;
import com.elitescloud.boot.model.entity.BaseModel;


/**
 * @author : WWW
 * @date : 2023-12-2
 * @desc : 试用期考核
 */

@Entity
@Table(name = "prd_probation_exam")
@org.hibernate.annotations.Table(appliesTo = "prd_probation_exam", comment = "试用期考核")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PrdProbationExamDO extends WorkflowBaseDO {


    /**
     * 用户id
     */
    @Column(name = "user_id", columnDefinition = "bigint(20) comment '用户id'")
    private Long userId;

    /**
     * 用户名
     */
    @Column(name = "user_name", columnDefinition = "varchar(255) comment '用户名'")
    private String userName;

    /**
     * baseBU
     */
    @Column(name = "base_bu_id", columnDefinition = "bigint(20) comment 'baseBU'")
    private Long baseBuId;

    /**
     * 上级
     */
    @Column(name = "p_user_id", columnDefinition = "bigint(20) comment '上级'")
    private Long pUserId;

    /**
     * 上级名称
     */
    @Column(name = "p_user_name", columnDefinition = "varchar(255) comment '上级名称'")
    private String pUserName;

    /**
     * 试用期开始
     */
    @Column(name = "probation_start", columnDefinition = "date comment '试用期开始'")
    private LocalDate probationStart;

    /**
     * 试用期结束
     */
    @Column(name = "probation_end", columnDefinition = "date comment '试用期结束'")
    private LocalDate probationEnd;

    /**
     * 手机号
     */
    @Column(name = "phone", columnDefinition = "varchar(50) comment '手机号'")
    private String phone;

    /**
     * 邮箱
     */
    @Column(name = "email", columnDefinition = "varchar(255) comment '邮箱'")
    private String email;

    /**
     * 申请人id
     */
    @Column(name = "apply_user_id", columnDefinition = "bigint(20) comment '申请人id'")
    private Long applyUserId;

    /**
     * 申请人
     */
    @Column(name = "apply_user", columnDefinition = "varchar(255) comment '申请人'")
    private String applyUser;

    /**
     * 申请日期
     */
    @Column(name = "apply_date", columnDefinition = "date comment '申请日期'")
    private LocalDate applyDate;

    /**
     * 入职培训标记
     */
    @Column(name = "enroll_train_flag", columnDefinition = "tinyint(1) comment '入职培训标记'")
    private Boolean enrollTrainFlag;

    /**
     * 培训说明
     */
    @Column(name = "train_desc", columnDefinition = "varchar(2000) comment '培训说明'")
    private String trainDesc;

    /**
     * 成长收获
     */
    @Column(name = "self_eval1", columnDefinition = "text comment '成长收获'")
    private String selfEval1;

    /**
     * 近期工作成果
     */
    @Column(name = "self_eval2", columnDefinition = "text comment '近期工作成果'")
    private String selfEval2;

    /**
     * 自我定位
     */
    @Column(name = "self_eval3", columnDefinition = "text comment '自我定位'")
    private String selfEval3;

    /**
     * 需要改进的方面
     */
    @Column(name = "self_eval4", columnDefinition = "text comment '需要改进的方面'")
    private String selfEval4;

    /**
     * 建议
     */
    @Column(name = "self_eval5", columnDefinition = "text comment '建议'")
    private String selfEval5;

    /**
     * 上级评价说明
     */
    @Column(name = "p_user_eval_decs", columnDefinition = "varchar(2000) comment '上级评价说明'")
    private String pUserEvalDecs;

    /**
     * 上级评价id
     */
    @Column(name = "p_user_eval_id", columnDefinition = "bigint(20) comment '上级评价id'")
    private Long pUserEvalId;

    /**
     * 考核结果
     */
    @Column(name = "exam_res", columnDefinition = "varchar(255) comment '考核结果'")
    private String examRes;

    /**
     * 转正日期
     */
    @Column(name = "formal_data", columnDefinition = "date comment '转正日期'")
    private LocalDate formalData;

    /**
     * 考核类型(中/末)
     */
    @Column(name = "type", columnDefinition = "varchar(50) comment '考核类型(中/末)'")
    private String type;

    /**
     * bu负责人评价说明
     */
    @Column(name = "base_bu_eval_desc", columnDefinition = "varchar(2000) comment 'bu负责人评价说明'")
    private String baseBuEvalDesc;

    /**
     * bu负责人评价id
     */
    @Column(name = "base_bu_eval_id", columnDefinition = "bigint(20) comment 'bu负责人评价id'")
    private Long baseBuEvalId;

    /**
     * 完成标记
     */
    @Column(name = "finish_flag", columnDefinition = "tinyint(1) comment '完成标记'")
    private Boolean finishFlag;

    /**
     * 考核奖励
     */
    @Column(name = "exam_reward", columnDefinition = "varchar(255) comment '考核奖励'")
    private String examReward;


    /**
     * 是否内推
     */
    @Column(name = "recommend_flag", columnDefinition = "tinyint(1) comment '是否内推'")
    private Boolean recommendFlag;

    /**
     * 内推用户id
     */
    @Column(name = "recommend_user_id", columnDefinition = "bigint(20) comment '内推用户id'")
    private Long recommendUserId;

    /**
     * 流程名称
     */
    @Column(name = "name", columnDefinition = "varchar(255) comment '流程名称'")
    private String name;


    public Long getpUserId() {
        return pUserId;
    }

    public void setpUserId(Long pUserId) {
        this.pUserId = pUserId;
    }

    public String getpUserName() {
        return pUserName;
    }

    public void setpUserName(String pUserName) {
        this.pUserName = pUserName;
    }


    public String getpUserEvalDecs() {
        return pUserEvalDecs;
    }

    public void setpUserEvalDecs(String pUserEvalDecs) {
        this.pUserEvalDecs = pUserEvalDecs;
    }

    public Long getpUserEvalId() {
        return pUserEvalId;
    }

    public void setpUserEvalId(Long pUserEvalId) {
        this.pUserEvalId = pUserEvalId;
    }
}

