package com.elitesland.tw.tw5.server.prd.humanresources.examination.service;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamRangePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamResultPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamRangeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamRangeService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamResultService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamRangeVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamResultVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdPerformanceExamRangeConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.dao.PrdPerformanceExamRangeDao;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdPerformanceExamRangeDO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.repo.PrdPerformanceExamRangeRepo;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.collection.CollectionUtil;

import java.time.LocalDateTime;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-14
 * @desc : 绩效考核范围Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdPerformanceExamRangeServiceImpl implements PrdPerformanceExamRangeService {


    private final PrdPerformanceExamRangeDao prdPerformanceExamRangeDao;

    private final PrdPerformanceExamRangeRepo prdPerformanceExamRangeRepo;

    private final PrdPerformanceExamResultService prdPerformanceExamResultService;

    private final PrdPerformanceExamService prdPerformanceExamService;

    private final CacheUtil cacheUtil;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdPerformanceExamRangeVO save(PrdPerformanceExamRangePayload prdPerformanceExamRangePayload) {

        checkData(prdPerformanceExamRangePayload);
        //
        PrdPerformanceExamVO examVO = prdPerformanceExamService.get(prdPerformanceExamRangePayload.getExamId());
        if (null == examVO) {
            throw new BusinessException("id错误，未找到对应的绩效考核");
        }

        PrdPerformanceExamRangeDO prdPerformanceExamRangeDO = new PrdPerformanceExamRangeDO();
        prdPerformanceExamRangeDO = PrdPerformanceExamRangeConvert.INSTANCE.p2d(prdPerformanceExamRangePayload);
        PrdPerformanceExamRangeDO res = prdPerformanceExamRangeRepo.save(prdPerformanceExamRangeDO);

        // 新增绩效考核结果
        PrdPerformanceExamResultPayload prdPerformanceExamResultPayload = new PrdPerformanceExamResultPayload();
        prdPerformanceExamResultPayload.setRangeId(res.getId());
        prdPerformanceExamResultPayload.setExamName(examVO.getName());
        prdPerformanceExamResultPayload.setExamId(examVO.getId());
        prdPerformanceExamResultPayload.setState(ProcInstStatus.NOTSUBMIT.name());
        // 考核期间
        prdPerformanceExamResultPayload.setExamStartPeriod(examVO.getStartPeriod());
        prdPerformanceExamResultPayload.setExamEndPeriod(examVO.getEndPeriod());
        // 考核发起时间
        prdPerformanceExamResultPayload.setExamCreatTime(LocalDateTime.now());
        // 考核发起人
        SysUserDTO loginUser = GlobalUtil.getLoginUser();
        prdPerformanceExamResultPayload.setExamCreatUserId(loginUser.getId());
        prdPerformanceExamResultPayload.setExamCreatUser(loginUser.getUsername());
        // 分数上限
        prdPerformanceExamResultPayload.setScoreMin(examVO.getScoreMin());
        prdPerformanceExamResultPayload.setScoreMax(examVO.getScoreMax());

        // 资源类型
        prdPerformanceExamResultPayload.setResType(prdPerformanceExamRangePayload.getResType());
        // 合作方式
        prdPerformanceExamResultPayload.setCoopType(prdPerformanceExamRangePayload.getCoopType());
        // BaseBu
        prdPerformanceExamResultPayload.setBaseBuId(prdPerformanceExamRangePayload.getBuId());
        prdPerformanceExamResultPayload.setBaseBuName(prdPerformanceExamRangePayload.getBuName());

        prdPerformanceExamResultPayload.setEmpName(prdPerformanceExamRangePayload.getResName());
        prdPerformanceExamResultPayload.setUserId(prdPerformanceExamRangePayload.getUserId());
        prdPerformanceExamResultPayload.setEmpId(prdPerformanceExamRangePayload.getResId());
        // 考核说明
        prdPerformanceExamResultPayload.setExamDesc(examVO.getExamDesc());

        PrdPerformanceExamResultVO resultVO = prdPerformanceExamResultService.save(prdPerformanceExamResultPayload);


        return PrdPerformanceExamRangeConvert.INSTANCE.d2v(res);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdPerformanceExamRangeVO update(PrdPerformanceExamRangePayload prdPerformanceExamRangePayload) {

        Assert.notNull(prdPerformanceExamRangePayload.getId(), "id is null");
        PrdPerformanceExamRangeVO res = save(prdPerformanceExamRangePayload);
        return res;

    }


    @Override
    public PrdPerformanceExamRangeVO get(Long id) {

        if (null == id) {
            return null;
        }
        PrdPerformanceExamRangeVO res = prdPerformanceExamRangeDao.get(id);
        return res;

    }


    @Override
    public PagingVO<PrdPerformanceExamRangeVO> page(PrdPerformanceExamRangeQuery prdPerformanceExamRangeQuery) {

        PagingVO<PrdPerformanceExamRangeVO> res = prdPerformanceExamRangeDao.page(prdPerformanceExamRangeQuery);
        res.getRecords().forEach(x->{
            String userName = cacheUtil.getUserName(x.getUserId());
            x.setResName(userName);
        });
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdPerformanceExamRangeDao.del(ids);
        // 删除考核结果
        prdPerformanceExamResultService.delByRangeIds(ids);

        return res;

    }

    @Override
    public List<PrdPerformanceExamRangeVO> getList(PrdPerformanceExamRangeQuery prdPerformanceExamRangeQuery) {

        List<PrdPerformanceExamRangeVO> res = prdPerformanceExamRangeDao.getList(prdPerformanceExamRangeQuery);
        return res;

    }


    /**
     * 数据校验
     *
     * @param prdPerformanceExamRangePayload
     */
    private void checkData(PrdPerformanceExamRangePayload prdPerformanceExamRangePayload) {

        if (null == (prdPerformanceExamRangePayload.getUserId())) {
            throw new BusinessException("userId不能为空");
        }
        if (null == (prdPerformanceExamRangePayload.getBuId())) {
            throw new BusinessException("buId不能为空");
        }
        if (null == (prdPerformanceExamRangePayload.getExamId())) {
            throw new BusinessException("examId不能为空");
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateByCondition(PrdPerformanceExamRangePayload prdPerformanceExamRangePayload) {
        Assert.notNull(prdPerformanceExamRangePayload.getId(), "id不能为空");
        Long res = prdPerformanceExamRangeDao.update(prdPerformanceExamRangePayload);
        return res;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean batchSave(List<PrdPerformanceExamRangePayload> prdPerformanceExamRangePayload) {

        prdPerformanceExamRangePayload.forEach(x -> {
            Assert.notNull(x.getExamId(), "绩效id不能为空");
            save(x);
        });

        return true;
    }

    @Override
    @Transactional
    public Long delByExamId(Long id) {
        Long res = prdPerformanceExamRangeDao.delByExamId(id);
        return res;
    }


}

