package com.elitesland.tw.tw5.server.prd.humanresources.recommended.dao;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdInternalRecommPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdInternalRecommQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdInternalRecommVO;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.recommended.entity.PrdInternalRecommDO;
import com.elitesland.tw.tw5.server.prd.humanresources.recommended.entity.QPrdInternalRecommDO;
import com.elitesland.tw.tw5.server.prd.humanresources.recommended.entity.QPrdRecruitPositionDO;
import com.elitesland.tw.tw5.server.prd.humanresources.recommended.repo.PrdInternalRecommRepo;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 内部招聘-我的推荐
 *
 * @author zhangxiao
 * @date 2023-12-14
 */
@Repository
@RequiredArgsConstructor
public class PrdInternalRecommDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final PrdInternalRecommRepo repo;
    private final QPrdInternalRecommDO qdo = QPrdInternalRecommDO.prdInternalRecommDO;
    private final QPrdRecruitPositionDO qPrdRecruitPositionDO = QPrdRecruitPositionDO.prdRecruitPositionDO;
    private final FileUtil fileUtil;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdInternalRecommVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdInternalRecommVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                // 岗位id
                qdo.positId.as("posIt"),
                // 内部推荐编号
                qdo.docNo,
                // 采用奖励
                qdo.adoptReward,
                // 转正日期
                qdo.formalDate,
                // 推荐日期
                qdo.recommDate,
                // 是否入职 true 入职 false 不入职
                qdo.entryFlag,
                // 是否转正 true 转正 false 不转正
                qdo.formalFlag,
                // 筛选结果 1、采用 2、不合适 3、简历重复 4、招聘取消
                qdo.filterResult,
                // 招聘负责人
                qdo.managerUserId,
                //内部编号
                qPrdRecruitPositionDO.jobNo.as("internalPostNo"),
                //内部名称
                qPrdRecruitPositionDO.jobTitle.as("internalPostName"),
                //分类一
                qPrdRecruitPositionDO.jobType1.as("jobType1"),
                //分类二
                qPrdRecruitPositionDO.jobType2.as("jobType2"),
                // 转转奖励
                qdo.formalReward,
                // 被推荐人名称
                qdo.recommUserName,
                // 推荐人简历
                qdo.recommResume,
                // 推荐人手机号
                qdo.recommPhone,
                // 推荐状态 1、未提交2、审批中3、已通过4、撤回5、关闭6、已拒绝
                qdo.recommStatus,
                // 与推荐人关系
                qdo.relate,
                // 推荐理由
                qdo.reason,
                // 被推荐人档案id
                qdo.recommUserId,
                qdo.procInstId,
                qdo.procInstStatus,
                qdo.submitTime,
                qdo.approvedTime
        )).from(qdo).leftJoin(qPrdRecruitPositionDO).on(qPrdRecruitPositionDO.id.eq(qdo.positId));
    }


    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */


    private JPAQuery<PrdInternalRecommVO> getJpaQueryWhere(PrdInternalRecommQuery query) {
        JPAQuery<PrdInternalRecommVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(PrdInternalRecommQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(PrdInternalRecommQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 主键id 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 岗位id 精确 */
        if (!ObjectUtils.isEmpty(query.getPosIt())) {
            list.add(qdo.positId.eq(query.getPosIt()));
        }
        /** 内部推荐编号 精确 */
        if (!ObjectUtils.isEmpty(query.getDocNo())) {
            list.add(qdo.docNo.like("%" + query.getDocNo() + "%"));
        }
        /** 采用奖励 精确 */
        if (!ObjectUtils.isEmpty(query.getAdoptReward())) {
            list.add(qdo.adoptReward.eq(query.getAdoptReward()));
        }
        /** 转正日期 精确 */
        if (!ObjectUtils.isEmpty(query.getFormalDate())) {
            list.add(qdo.formalDate.eq(query.getFormalDate()));
        }
        /** 推荐日期 精确 */
        if (!ObjectUtils.isEmpty(query.getRecommDate())) {
            list.add(qdo.recommDate.eq(query.getRecommDate()));
        }
        /** 是否入职 true 入职 false 不入职 精确 */
        if (!ObjectUtils.isEmpty(query.getEntryFlag())) {
            list.add(qdo.entryFlag.eq(query.getEntryFlag()));
        }
        /** 是否转正 true 转正 false 不转正 精确 */
        if (!ObjectUtils.isEmpty(query.getFormalFlag())) {
            list.add(qdo.formalFlag.eq(query.getFormalFlag()));
        }
        /** 筛选结果 1、采用 2、不合适 3、简历重复 4、招聘取消 精确 */
        if (!ObjectUtils.isEmpty(query.getFilterResult())) {
            list.add(qdo.filterResult.eq(query.getFilterResult()));
        }
        /** 招聘负责人 精确 */
        if (!ObjectUtils.isEmpty(query.getManagerUserId())) {
            list.add(qdo.managerUserId.eq(query.getManagerUserId()));
        }
        /** 转转奖励 精确 */
        if (!ObjectUtils.isEmpty(query.getFormalReward())) {
            list.add(qdo.formalReward.eq(query.getFormalReward()));
        }
        /** 被推荐人名称 精确 */
        if (!ObjectUtils.isEmpty(query.getRecommUserName())) {
            list.add(qdo.recommUserName.eq(query.getRecommUserName()));
        }
        /** 推荐人简历 精确 */
        if (!ObjectUtils.isEmpty(query.getRecommResume())) {
            list.add(qdo.recommResume.eq(query.getRecommResume()));
        }
        /** 推荐人手机号 精确 */
        if (!ObjectUtils.isEmpty(query.getRecommPhone())) {
            list.add(qdo.recommPhone.eq(query.getRecommPhone()));
        }
        /** 推荐状态 1、未提交2、审批中3、已通过4、撤回5、关闭6、已拒绝 精确 */
        if (!ObjectUtils.isEmpty(query.getRecommStatus())) {
            list.add(qdo.recommStatus.eq(query.getRecommStatus()));
        }
        /** 与推荐人关系 精确 */
        if (!ObjectUtils.isEmpty(query.getRelate())) {
            list.add(qdo.relate.eq(query.getRelate()));
        }
        /** 推荐理由 精确 */
        if (!ObjectUtils.isEmpty(query.getReason())) {
            list.add(qdo.reason.eq(query.getReason()));
        }
        /** 被推荐人档案id 精确 */
        if (!ObjectUtils.isEmpty(query.getRecommUserId())) {
            list.add(qdo.recommUserId.eq(query.getRecommUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getRecommDateStart()) && !ObjectUtils.isEmpty(query.getRecommDateEnd())) {
            //  list.add(qdo.createTime.between(query.getCreateTimeStart(), query.getCreateTimeEnd()));
            list.add(qdo.recommDate.between(query.getRecommDateStart(), query.getRecommDateEnd()));
        }
        if (!ObjectUtils.isEmpty(query.getFormalDateStart()) && !ObjectUtils.isEmpty(query.getFormalDateEnd())) {
            //  list.add(qdo.createTime.between(query.getCreateTimeStart(), query.getCreateTimeEnd()));
            list.add(qdo.formalDate.between(query.getFormalDateStart(), query.getFormalDateEnd()));
        }
        if (!ObjectUtils.isEmpty(query.getInternalPostNameOrNo())) {
            list.add(qPrdRecruitPositionDO.jobNo.like("%" + query.getInternalPostNameOrNo() + "%").or(qPrdRecruitPositionDO.jobTitle.like("%" + query.getInternalPostNameOrNo() + "%")));
        }
        if (!ObjectUtils.isEmpty(query.getJobType1()) && !ObjectUtils.isEmpty(query.getJobType2())) {
            list.add(qPrdRecruitPositionDO.jobType1.eq(query.getJobType1()).and(qPrdRecruitPositionDO.jobType2.eq(query.getJobType2())));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PrdInternalRecommVO queryByKey(Long id) {
        JPAQuery<PrdInternalRecommVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PrdInternalRecommVO> queryListDynamic(PrdInternalRecommQuery query) {
        JPAQuery<PrdInternalRecommVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PrdInternalRecommVO> queryPaging(PrdInternalRecommQuery query) {

        var s = query.getRecommDateStart();
        var s1 = query.getRecommDateEnd();
        JPAQuery<PrdInternalRecommVO> jpaQuery = getJpaQueryWhere(query);
        List<PrdInternalRecommVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PrdInternalRecommVO>builder().records(result).total(jpaQuery.fetchCount()).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdInternalRecommDO save(PrdInternalRecommDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PrdInternalRecommDO> saveAll(List<PrdInternalRecommDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(PrdInternalRecommPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 主键id
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 岗位id
        if (payload.getPosIt() != null) {
            update.set(qdo.positId, payload.getPosIt());
        }
        // 内部推荐编号
        if (payload.getDocNo() != null) {
            update.set(qdo.docNo, payload.getDocNo());
        }
        // 采用奖励
        if (payload.getAdoptReward() != null) {
            update.set(qdo.adoptReward, payload.getAdoptReward());
        }
        // 转正日期
        if (payload.getFormalDate() != null) {
            update.set(qdo.formalDate, payload.getFormalDate());
        }
        // 推荐日期
        if (payload.getRecommDate() != null) {
            update.set(qdo.recommDate, payload.getRecommDate());
        }
        // 是否入职 true 入职 false 不入职
        if (payload.getEntryFlag() != null) {
            update.set(qdo.entryFlag, payload.getEntryFlag());
        }
        // 是否转正 true 转正 false 不转正
        if (payload.getFormalFlag() != null) {
            update.set(qdo.formalFlag, payload.getFormalFlag());
        }
        // 筛选结果 1、采用 2、不合适 3、简历重复 4、招聘取消
        if (payload.getFilterResult() != null) {
            update.set(qdo.filterResult, payload.getFilterResult());
        }
        // 招聘负责人
        if (payload.getManagerUserId() != null) {
            update.set(qdo.managerUserId, payload.getManagerUserId());
        }
        // 转转奖励
        if (payload.getFormalReward() != null) {
            update.set(qdo.formalReward, payload.getFormalReward());
        }
        // 被推荐人名称
        if (payload.getRecommUserName() != null) {
            update.set(qdo.recommUserName, payload.getRecommUserName());
        }
        // 推荐人简历
        if (payload.getRecommResume() != null) {
            update.set(qdo.recommResume, payload.getRecommResume());
        }
        // 推荐人手机号
        if (payload.getRecommPhone() != null) {
            update.set(qdo.recommPhone, payload.getRecommPhone());
        }
        // 推荐状态 1、未提交2、审批中3、已通过4、撤回5、关闭6、已拒绝
        if (payload.getRecommStatus() != null) {
            update.set(qdo.recommStatus, payload.getRecommStatus());
        }
        // 与推荐人关系
        if (payload.getRelate() != null) {
            update.set(qdo.relate, payload.getRelate());
        }
        // 推荐理由
        if (payload.getReason() != null) {
            update.set(qdo.reason, payload.getReason());
        }
        // 被推荐人档案id
        if (payload.getRecommUserId() != null) {
            update.set(qdo.recommUserId, payload.getRecommUserId());
        }
        // 被推荐人档案id
        if (payload.getRecommUserId() != null) {
            update.set(qdo.recommUserId, payload.getRecommUserId());
        }
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        if (payload.getSubmitTime() != null) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        if (payload.getDeleteFlag() != null) {
            update.set(qdo.deleteFlag, payload.getDeleteFlag());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 主键id
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 岗位id
            if (nullFields.contains("posIt")) {
                update.setNull(qdo.positId);
            }
            // 内部推荐编号
            if (nullFields.contains("docNo")) {
                update.setNull(qdo.docNo);
            }
            // 采用奖励
            if (nullFields.contains("adoptReward")) {
                update.setNull(qdo.adoptReward);
            }
            // 审批时间
            if (nullFields.contains("approvedTime")) {
                update.setNull(qdo.approvedTime);
            }
            // 转正日期
            if (nullFields.contains("formalDate")) {
                update.setNull(qdo.formalDate);
            }
            // 推荐日期
            if (nullFields.contains("recommDate")) {
                update.setNull(qdo.recommDate);
            }
            // 是否入职 true 入职 false 不入职
            if (nullFields.contains("entryFlag")) {
                update.setNull(qdo.entryFlag);
            }
            // 是否转正 true 转正 false 不转正
            if (nullFields.contains("formalFlag")) {
                update.setNull(qdo.formalFlag);
            }
            // 筛选结果 1、采用 2、不合适 3、简历重复 4、招聘取消
            if (nullFields.contains("filterResult")) {
                update.setNull(qdo.filterResult);
            }
            // 招聘负责人
            if (nullFields.contains("managerUserId")) {
                update.setNull(qdo.managerUserId);
            }
            // 转转奖励
            if (nullFields.contains("formalReward")) {
                update.setNull(qdo.formalReward);
            }
            // 被推荐人名称
            if (nullFields.contains("recommUserName")) {
                update.setNull(qdo.recommUserName);
            }
            // 推荐人简历
            if (nullFields.contains("recommResume")) {
                update.setNull(qdo.recommResume);
            }
            // 推荐人手机号
            if (nullFields.contains("recommPhone")) {
                update.setNull(qdo.recommPhone);
            }
            // 推荐状态 1、未提交2、审批中3、已通过4、撤回5、关闭6、已拒绝
            if (nullFields.contains("recommStatus")) {
                update.setNull(qdo.recommStatus);
            }
            // 与推荐人关系
            if (nullFields.contains("relate")) {
                update.setNull(qdo.relate);
            }
            // 推荐理由
            if (nullFields.contains("reason")) {
                update.setNull(qdo.reason);
            }
            // 被推荐人档案id
            if (nullFields.contains("recommUserId")) {
                update.setNull(qdo.recommUserId);
            }
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            if (nullFields.contains("submitTime")) {
                update.setNull(qdo.submitTime);
            }
            if (nullFields.contains("approvedTime")) {
                update.setNull(qdo.approvedTime);
            }
            if (nullFields.contains("deleteFlag")) {
                update.setNull(qdo.deleteFlag);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    public Boolean updateFormalReward(PrdInternalRecommPayload prdInternalRecommPayload) {
        long res = jpaQueryFactory.update(qdo)
                .set(qdo.formalReward, prdInternalRecommPayload.getFormalReward())
                .set(qdo.formalFlag, prdInternalRecommPayload.getFormalFlag())
                .set(qdo.formalDate, prdInternalRecommPayload.getFormalDate())
                .where(qdo.recommUserName.eq(prdInternalRecommPayload.getRecommUserName()))
                .where(qdo.managerUserId.eq(prdInternalRecommPayload.getManagerUserId()))
                .execute();

        return res > 0;
    }

    public List<PrdInternalRecommVO> getByPersonId(String name, Long personId) {
        List<PrdInternalRecommVO> res = jpaQueryFactory.select(Projections.bean(PrdInternalRecommVO.class,
                        qdo.id,
                        // 招聘负责人
                        qdo.managerUserId,
                        // 推荐人手机号
                        qdo.recommPhone,
                        // 推荐状态 1、未提交2、审批中3、已通过4、撤回5、关闭6、已拒绝
                        qdo.recommStatus,
                        qdo.procInstId,
                        qdo.procInstStatus,
                        qdo.personId

                )).from(qdo)
                .where(qdo.personId.eq(personId))
                //
                .where(qdo.recommStatus.eq(3))
                .fetch();

        return res;

    }

    public Boolean updateByPersonId(PrdInternalRecommPayload prdInternalRecommPayload) {
        long res = jpaQueryFactory.update(qdo)
                .set(qdo.entryFlag, prdInternalRecommPayload.getEntryFlag())
                .where(qdo.personId.eq(prdInternalRecommPayload.getPersonId()))
                .where(qdo.procInstStatus.eq(ProcInstStatus.APPROVED))
                .execute();
        return res > 0;

    }
}

