package com.elitesland.tw.tw5.server.prd.humanresources.recommended.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * 内部招聘管理
 *
 * @author zhangxiao
 * @date 2023-12-13
 */
@Entity
@Table(name = "prd_recruit_position", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "prd_recruit_position", comment = "内部招聘管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdRecruitPositionDO extends BaseModel implements Serializable {
    /**
     * 招聘编号
     */
    @Comment("招聘编号")
    @Column()
    private String jobNo;
    /**
     * 招聘名称
     */
    @Comment("招聘名称")
    @Column()
    private String jobTitle;
    /**
     * 招聘部门 （组织Id）
     */
    @Comment("招聘部门 （组织Id）")
    @Column()
    private Long baseBuId;
    /**
     * 工作地
     */
    @Comment("工作地")
    @Column()
    private String baseRegion;
    /**
     * 工作地说明
     */
    @Comment("工作地说明")
    @Column()
    private String baseRegionDesc;
    /**
     * 招聘人数
     */
    @Comment("招聘人数")
    @Column()
    private Integer recruitQty;
    /**
     * 工作类型 1、全职2、兼职
     */
    @Comment("工作类型 1、全职2、兼职")
    @Column()
    private Integer workType;
    /**
     * 服务方式 1、现场 2、远程 3、按需
     */
    @Comment("服务方式 1、现场 2、远程 3、按需")
    @Column()
    private Integer serviceMode;
    /**
     * 时间要求 1、常规固定 2、灵活安排
     */
    @Comment("时间要求 1、常规固定 2、灵活安排")
    @Column()
    private Integer timeRequirement;
    /**
     * 岗位简介
     */
    @Column(name = "job_profile", columnDefinition = "varchar(2000) comment '岗位简介'")
    private String jobProfile;
    /**
     * 岗位要求
     */
    @Column(name = "job_requirement", columnDefinition = "varchar(2000) comment '岗位要求'")
    private String jobRequirement;
    /**
     * 是否运行内部推荐(0,1)
     */
    @Comment("是否运行内部推荐(0,1)")
    @Column()
    private Boolean internalFlag;
    /**
     * 外部资源可见 1、可见(选择) 0、不可见
     */
    @Comment("外部资源可见 1、可见(选择) 0、不可见")
    @Column()
    private Boolean externalVisible;
    /**
     * 1、招聘中 2、招聘完成 3、招聘取消
     */
    @Comment("1、招聘中 2、招聘完成 3、招聘取消")
    @Column()
    private Integer recruitmentStatus;
    /**
     * 招聘负责人
     */
    @Comment("招聘负责人")
    @Column()
    private Long managerUserId;
    /**
     * 招聘分类一
     */
    @Comment("招聘分类一")
    @Column()
    private String jobType1;
    /**
     * 招聘分类二
     */
    @Comment("招聘分类二")
    @Column()
    private String jobType2;

    public void copy(PrdRecruitPositionDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
