package com.elitesland.tw.tw5.server.prd.inv.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * 发票行程单
 *
 * @author zoey
 * @date 2023-12-05
 */
@Entity
@Table(name = "inv_invoice_travel_itinerary", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "inv_invoice_travel_itinerary", comment = "发票行程单")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class InvInvoiceTravelItineraryDO extends BaseModel implements Serializable  {
    /** 发票ID */
    @Comment("发票ID")
    @Column()
    private Long invId;
    /** 百望系统发票ID */
    @Comment("百望系统发票ID")
    @Column()
    private Long baiwangInvId;
    /** 百望系统发票行程单ID */
    @Comment("百望系统发票行程单ID")
    @Column()
    private Long baiwangId;
    /** 发票代码 */
    @Comment("发票代码")
    @Column()
    private String invoiceCode;
    /** 发票号码 */
    @Comment("发票号码")
    @Column()
    private String invoiceNo;
    /** 出发站 */
    @Comment("出发站")
    @Column()
    private String fromstation;
    /** 到达站 */
    @Comment("到达站")
    @Column()
    private String tostation;
    /** 航班号 */
    @Comment("航班号")
    @Column()
    private String flightno;
    /** 乘机日期 */
    @Comment("乘机日期")
    @Column()
    private String traveldate;
    /** 乘机时间 */
    @Comment("乘机时间")
    @Column()
    private String traveltime;
    /** 座位等级 */
    @Comment("座位等级")
    @Column()
    private String seatlevel;
    /** 承运人 */
    @Comment("承运人")
    @Column()
    private String carrier;

    public void copy(InvInvoiceTravelItineraryDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
