package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TServerApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.service.TServerApplyService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.api.prd.my.query.TServerApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TServerApplyVO;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.seata.spring.annotation.GlobalTransactional;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 服务器申请
 *
 * @author lemon
 * @date 2023-09-23
 */
@Api(tags = "服务器申请")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/my/tServerApply")
@Slf4j
public class TServerApplyController {

private final TServerApplyService tServerApplyService;

    /**
     * 服务器申请-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @GlobalTransactional
    @ApiOperation("服务器申请-新增")
    public TwOutputUtil<TServerApplyVO> insert(@RequestBody TServerApplyPayload payload){
         return TwOutputUtil.ok(tServerApplyService.insert(payload));
    }

    /**
     * 服务器申请-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @GlobalTransactional
    @ApiOperation("服务器申请-更新")
    public TwOutputUtil<TServerApplyVO> update(@RequestBody TServerApplyPayload payload){
        return TwOutputUtil.ok(tServerApplyService.update(payload));
    }

    /**
     * 服务器申请-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("服务器申请-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody TServerApplyPayload payload){
        return TwOutputUtil.ok(tServerApplyService.updateByKeyDynamic(payload));
    }

    /**
     * 服务器申请-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
     @UdcNameClass
    @ApiOperation("服务器申请-主键查询")
    public TwOutputUtil<TServerApplyVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(tServerApplyService.queryByKey(key));
    }

    /**
     * 服务器申请-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("服务器申请-分页")
    public TwOutputUtil<PagingVO<TServerApplyVO>> paging(TServerApplyQuery query) {
        return TwOutputUtil.ok(tServerApplyService.queryPaging(query));
    }

    /**
     * 服务器申请-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("服务器申请-查询列表")
    public TwOutputUtil<List<TServerApplyVO>> queryList(TServerApplyQuery query) {
        return TwOutputUtil.ok(tServerApplyService.queryListDynamic(query));
    }

    /**
     * 服务器申请-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("服务器申请-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         tServerApplyService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

