package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitesland.tw.tw5.api.prd.my.payload.AbnormalWorkApplyDetailPayload;
import com.elitesland.tw.tw5.api.prd.my.query.AbnormalWorkApplyDetailQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.AbnormalWorkApplyDetailVO;
import com.elitesland.tw.tw5.server.prd.my.entity.AbnormalWorkApplyDetailDO;
import com.elitesland.tw.tw5.server.prd.my.entity.QAbnormalWorkApplyDO;
import com.elitesland.tw.tw5.server.prd.my.entity.QAbnormalWorkApplyDetailDO;
import com.elitesland.tw.tw5.server.prd.my.repo.AbnormalWorkApplyDetailRepo;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 远程办公申请明细
 *
 * @author wangly
 * @date 2024-06-12
 */
@Repository
@RequiredArgsConstructor
public class AbnormalWorkApplyDetailDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final AbnormalWorkApplyDetailRepo repo;
    private final QAbnormalWorkApplyDetailDO qdo = QAbnormalWorkApplyDetailDO.abnormalWorkApplyDetailDO;
    private final QAbnormalWorkApplyDO qAbnormalWorkApplyDO = QAbnormalWorkApplyDO.abnormalWorkApplyDO;
    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<AbnormalWorkApplyDetailVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(AbnormalWorkApplyDetailVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 远程办公申请ID
                qdo.applyId,
                // 月份
                qdo.workMonth,
                // 远程办公日期
                qdo.workDate,
                // 远程办公天数
                qdo.workDays,
                // 0.5天区分上午下午 AM上午 PM下午
                qdo.workInterval,
                // 流程实例ID
                qdo.procInstId,
                // 流程审批状态
                qdo.procInstStatus,
                // 审批时间
                qdo.approvedTime,
                // 申请人
                qAbnormalWorkApplyDO.applyUserId,
                // 组织id
                qAbnormalWorkApplyDO.orgId,
                // 事由id
                qAbnormalWorkApplyDO.reasonId,
                // 事由名称
                qAbnormalWorkApplyDO.reasonName,
                // 事由类型
                qAbnormalWorkApplyDO.reasonType,
                //远程办公地点
                qAbnormalWorkApplyDO.abnormalWorkAddr,
                // 远程办公原因
                qAbnormalWorkApplyDO.remark,
                // 审批状态
                qAbnormalWorkApplyDO.procInstStatus,
                // 申请时间
                qAbnormalWorkApplyDO.applyDate,
                // 级别
                qAbnormalWorkApplyDO.grade
        )).from(qdo).leftJoin(qAbnormalWorkApplyDO).on(qdo.applyId.eq(qAbnormalWorkApplyDO.id)).where(qAbnormalWorkApplyDO.deleteFlag.eq(0));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<AbnormalWorkApplyDetailVO> getJpaQueryWhere(AbnormalWorkApplyDetailQuery query) {
        JPAQuery<AbnormalWorkApplyDetailVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(AbnormalWorkApplyDetailQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo).leftJoin(qAbnormalWorkApplyDO).on(qdo.applyId.eq(qAbnormalWorkApplyDO.id)).where(qAbnormalWorkApplyDO.deleteFlag.eq(0));;
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(AbnormalWorkApplyDetailQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 远程办公申请ID 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyId())) {
            list.add(qdo.applyId.eq(query.getApplyId()));
        }
        /** 月份 精确 */
        if (!ObjectUtils.isEmpty(query.getWorkMonth())) {
            list.add(qdo.workMonth.eq(query.getWorkMonth()));
        }
        /** 休假日期 精确 */
        if (!ObjectUtils.isEmpty(query.getWorkDate())) {
            list.add(qdo.workDate.eq(query.getWorkDate()));
        }
        /** 休假天数 精确 */
        if (!ObjectUtils.isEmpty(query.getWorkDays())) {
            list.add(qdo.workDays.eq(query.getWorkDays()));
        }
        /** 0.5天区分上午下午 AM上午 PM下午 精确 */
        if (!ObjectUtils.isEmpty(query.getWorkInterval())) {
            list.add(qdo.workInterval.eq(query.getWorkInterval()));
        }
        /** 流程实例ID 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstId())) {
            list.add(qdo.procInstId.eq(query.getProcInstId()));
        }
        /** 审批时间 精确 */
        if (!ObjectUtils.isEmpty(query.getApprovedTime())) {
            list.add(qdo.approvedTime.eq(query.getApprovedTime()));
        }
        /** 外出申请人id 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyUserId())) {
            list.add(qAbnormalWorkApplyDO.applyUserId.eq(query.getApplyUserId()));
        }
        /** 归属bu_id 精确 */
        if (!ObjectUtils.isEmpty(query.getOrgId())) {
            list.add(qAbnormalWorkApplyDO.orgId.eq(query.getOrgId()));
        }
        /** 远程办公日期开始 精确 */
        if (!ObjectUtils.isEmpty(query.getAbnormalWorkStartDate())) {
            list.add(qdo.workDate.goe(query.getAbnormalWorkStartDate()));
        }
        /** 远程办公日期结束 精确 */
        if (!ObjectUtils.isEmpty(query.getAbnormalWorkEndDate())) {
            list.add(qdo.workDate.loe(query.getAbnormalWorkEndDate()));
        }
        /** 审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            list.add(qAbnormalWorkApplyDO.procInstStatus.eq(query.getProcInstStatus()));
        }
        /** 事由类型 精确 */
        if (!ObjectUtils.isEmpty(query.getReasonType())) {
            list.add(qAbnormalWorkApplyDO.reasonType.eq(query.getReasonType()));
        }
        /** 事由id 精确 */
        if (!ObjectUtils.isEmpty(query.getReasonId())) {
            list.add(qAbnormalWorkApplyDO.reasonId.eq(query.getReasonId()));
        }
        /** 申请日期开始 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyStartDate())) {
            list.add(qAbnormalWorkApplyDO.applyDate.goe(query.getApplyStartDate()));
        }
        /** 申请日期结束 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyEndDate())) {
            list.add(qAbnormalWorkApplyDO.applyDate.loe(query.getApplyEndDate()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public AbnormalWorkApplyDetailVO queryByKey(Long id) {
        JPAQuery<AbnormalWorkApplyDetailVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<AbnormalWorkApplyDetailVO> queryListDynamic(AbnormalWorkApplyDetailQuery query) {
        JPAQuery<AbnormalWorkApplyDetailVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<AbnormalWorkApplyDetailVO> queryPaging(AbnormalWorkApplyDetailQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<AbnormalWorkApplyDetailVO> jpaQuery = getJpaQueryWhere(query);
        List<AbnormalWorkApplyDetailVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<AbnormalWorkApplyDetailVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public AbnormalWorkApplyDetailDO save(AbnormalWorkApplyDetailDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<AbnormalWorkApplyDetailDO> saveAll(List<AbnormalWorkApplyDetailDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(AbnormalWorkApplyDetailPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 远程办公申请ID
        if (payload.getApplyId() != null) {
            update.set(qdo.applyId, payload.getApplyId());
        }
        // 月份
        if (payload.getWorkMonth() != null) {
            update.set(qdo.workMonth, payload.getWorkMonth());
        }
        // 休假日期
        if (payload.getWorkDate() != null) {
            update.set(qdo.workDate, payload.getWorkDate());
        }
        // 休假天数
        if (payload.getWorkDays() != null) {
            update.set(qdo.workDays, payload.getWorkDays());
        }
        // 0.5天区分上午下午 AM上午 PM下午
        if (payload.getWorkInterval() != null) {
            update.set(qdo.workInterval, payload.getWorkInterval());
        }
        // 流程实例ID
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        // 流程审批状态
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        // 审批时间
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 远程办公申请ID
            if (nullFields.contains("applyId")) {
                update.setNull(qdo.applyId);
            }
            // 月份
            if (nullFields.contains("workMonth")) {
                update.setNull(qdo.workMonth);
            }
            // 休假日期
            if (nullFields.contains("workDate")) {
                update.setNull(qdo.workDate);
            }
            // 休假天数
            if (nullFields.contains("workDays")) {
                update.setNull(qdo.workDays);
            }
            // 0.5天区分上午下午 AM上午 PM下午
            if (nullFields.contains("workInterval")) {
                update.setNull(qdo.workInterval);
            }
            // 流程实例ID
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
            // 流程审批状态
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            // 审批时间
            if (nullFields.contains("approvedTime")) {
                update.setNull(qdo.approvedTime);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

